<?php
/**
 * Sticky add-to-cart Functions Class.
 *
 * @package Rse\SB
 */

namespace RadiusTheme\SBPRO\Modules\StickyAddToCart;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Helpers\Cache;
use RadiusTheme\SB\Elementor\Helper\RenderHelpers;

defined( 'ABSPATH' ) || exit();

/**
 * Sticky add-to-cart Functions Class.
 */
class StickyAddToCartFns {
	/**
	 * Returns an array of settings fields.
	 *
	 * @return array
	 */
	public static function settings_field() {
		return [
			'sticky_settings'                    => [
				'id'    => 'sticky_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Settings', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'sticky_position'                    => [
				'id'      => 'sticky_position',
				'type'    => 'text_select',
				'options' => [
					'top'    => esc_html__( 'Top', 'shopbuilder-pro' ),
					'bottom' => esc_html__( 'Bottom', 'shopbuilder-pro' ),
				],
				'value'   => 'bottom',
				'label'   => __( 'Sticky Bar Position', 'shopbuilder-pro' ),
				'help'    => esc_html__( 'Choose where the sticky bar will appear.', 'shopbuilder-pro' ),
				'tab'     => 'general',
			],
			'visibility_triggers'                => [
				'id'    => 'visibility_triggers',
				'type'  => 'slider',
				'min'   => 10,
				'max'   => 1000,
				'unit'  => 'px',
				'value' => 200,
				'label' => __( 'Scrolling Distance', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose when the sticky bar should appear (e.g., only after scrolling past the main product details, when the default add-to-cart button is no longer visible).', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'show_fullwidth'                     => [
				'id'    => 'show_fullwidth',
				'type'  => 'switch',
				'label' => __( 'Show Full-Width Sticky Bar?', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enable this option to show full-width sticky bar.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'sticky_bar_width'                   => [
				'id'    => 'sticky_bar_width',
				'type'  => 'slider',
				'min'   => 300,
				'max'   => 2240,
				'unit'  => 'px',
				'value' => 1290,
				'label' => __( 'Sticky Bar (Container) Width', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose the width of the sticky bar. If you choose to display full-width sticky bar, this setting will act as container width.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'sticky_bar_animation'               => [
				'id'      => 'sticky_bar_animation',
				'type'    => 'select',
				'options' => [
					'slide' => esc_html__( 'Slide', 'shopbuilder-pro' ),
					'fade'  => esc_html__( 'Fade', 'shopbuilder-pro' ),
				],
				'value'   => 'slide',
				'label'   => __( 'Sticky Bar Animation', 'shopbuilder-pro' ),
				'help'    => esc_html__( 'Choose how the bar will appear on scroll.', 'shopbuilder-pro' ),
				'tab'     => 'general',
			],
			'button_label'                       => [
				'id'    => 'button_label',
				'type'  => 'text',
				'value' => __( 'Add to Cart', 'shopbuilder-pro' ),
				'label' => __( 'Add-to-Cart Button Label', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Customize the "Add to Cart" button label.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'visibility_settings'                => [
				'id'    => 'visibility_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Element Visibility', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'show_image'                         => [
				'id'    => 'show_image',
				'type'  => 'switch',
				'label' => __( 'Show Thumbnail Image?', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enable this option to show a thumbnail image of the product on the sticky bar.', 'shopbuilder-pro' ),
				'value' => 'on',
				'tab'   => 'general',
			],
			'show_product_title'                 => [
				'id'    => 'show_product_title',
				'type'  => 'switch',
				'label' => __( 'Show Product Title?', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enable this option to show the title of the product on the sticky bar.', 'shopbuilder-pro' ),
				'value' => 'on',
				'tab'   => 'general',
			],
			'show_quantity_selector'             => [
				'id'    => 'show_quantity_selector',
				'type'  => 'switch',
				'label' => __( 'Show Quantity Selector?', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enable ability to change the product quantity from the sticky add-to-cart bar.', 'shopbuilder-pro' ),
				'value' => 'on',
				'tab'   => 'general',
			],
			'show_on_variation'                  => [
				'id'    => 'show_on_variation',
				'type'  => 'switch',
				'label' => __( 'Show Sticky Bar on Variable Products?', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enable to allow the sticky add-to-cart bar to show for variable products, displaying product variation details.', 'shopbuilder-pro' ),
				'value' => 'on',
				'tab'   => 'general',
			],
			'responsive_visibility'              => [
				'id'      => 'responsive_visibility',
				'type'    => 'select',
				'options' => [
					'default' => esc_html__( 'Show on all devices', 'shopbuilder-pro' ),
					'desktop' => esc_html__( 'Show only on desktop devices', 'shopbuilder-pro' ),
					'mobile'  => esc_html__( 'Show only on mobile devices', 'shopbuilder-pro' ),
				],
				'value'   => 'default',
				'label'   => __( 'Responsive Behavior', 'shopbuilder-pro' ),
				'help'    => esc_html__( 'Choose how the sticky bar will behave in responsive devices.', 'shopbuilder-pro' ),
				'tab'     => 'general',
			],
			'bar_style_intro'                    => [
				'id'    => 'bar_style_intro',
				'type'  => 'title',
				'label' => esc_html__( 'Sticky Bar Styles', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'sticky_color_scheme'                => [
				'id'      => 'sticky_color_scheme',
				'type'    => 'text_select',
				'options' => [
					'light' => esc_html__( 'Light', 'shopbuilder-pro' ),
					'dark'  => esc_html__( 'Dark', 'shopbuilder-pro' ),
				],
				'value'   => 'light',
				'label'   => __( 'Sticky Bar Color Scheme', 'shopbuilder-pro' ),
				'help'    => esc_html__( 'Choose the color appearance of the sticky bar.', 'shopbuilder-pro' ),
				'tab'     => 'styles',
			],
			'sticky_bar_primary_color'           => [
				'id'    => 'sticky_bar_primary_color',
				'label' => esc_html__( 'Sticky Bar Primary Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose primary color for sticky bar', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_bg_color'                => [
				'id'    => 'sticky_bar_bg_color',
				'label' => esc_html__( 'Sticky Bar Background Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose background color for sticky bar', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_title_tag'               => [
				'id'      => 'sticky_bar_title_tag',
				'label'   => __( 'Sticky Bar Product Title Tag', 'shopbuilder-pro' ),
				'help'    => esc_html__( 'Select the HTML tag to use for the sticky bar title.', 'shopbuilder-pro' ),
				'type'    => 'select',
				'value'   => 'h4',
				'options' => [
					'h1' => esc_html__( 'H1', 'shopbuilder-pro' ),
					'h2' => esc_html__( 'H2', 'shopbuilder-pro' ),
					'h3' => esc_html__( 'H3', 'shopbuilder-pro' ),
					'h4' => esc_html__( 'H4', 'shopbuilder-pro' ),
					'h5' => esc_html__( 'H5', 'shopbuilder-pro' ),
					'h6' => esc_html__( 'H6', 'shopbuilder-pro' ),
				],
				'tab'     => 'styles',
			],
			'sticky_bar_title_font_size'         => [
				'id'    => 'sticky_bar_title_font_size',
				'type'  => 'text',
				'label' => esc_html__( 'Sticky Bar Product Title Font Size', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enter Font Size. Ex. 16px', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'sticky_bar_title_color'             => [
				'id'    => 'sticky_bar_title_color',
				'label' => esc_html__( 'Sticky Bar Product Title Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose color for the sticky bar title', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_content_font_size'       => [
				'id'    => 'sticky_bar_content_font_size',
				'type'  => 'text',
				'label' => esc_html__( 'Sticky Bar Content Font Size', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enter Font Size. Ex. 16px', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'sticky_bar_content_color'           => [
				'id'    => 'sticky_bar_content_color',
				'label' => esc_html__( 'Sticky Bar Content Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose color for sticky bar content', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_border_color'            => [
				'id'    => 'sticky_bar_border_color',
				'label' => esc_html__( 'Sticky Bar Border Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose color for sticky bar border', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_shadow'                  => [
				'id'    => 'sticky_bar_shadow',
				'type'  => 'text',
				'label' => esc_html__( 'Sticky Bar Box Shadow', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enter sticky bar box shadow.', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'sticky_bar_radius'                  => [
				'id'    => 'sticky_bar_radius',
				'type'  => 'text',
				'label' => esc_html__( 'Sticky Bar Border Radius', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enter sticky bar border radius. Ex. 10px | 5px 10px | 0 5px 5px 0', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'sticky_bar_padding'                 => [
				'id'    => 'sticky_bar_padding',
				'type'  => 'text',
				'label' => esc_html__( 'Sticky Bar Padding', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enter sticky bar padding. Ex. 10px | 5px 10px | 0 5px 5px 0', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'form_style_intro'                   => [
				'id'    => 'form_style_intro',
				'type'  => 'title',
				'label' => esc_html__( 'Form Input Styles', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'input_text_color'                   => [
				'id'    => 'input_text_color',
				'label' => esc_html__( 'Input Text Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose color for input text', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'input_bg_color'                     => [
				'id'    => 'input_bg_color',
				'label' => esc_html__( 'Input Background Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose background color for input', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'input_border_color'                 => [
				'id'    => 'input_border_color',
				'label' => esc_html__( 'Input Border Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose color for input border', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'qty_color'                          => [
				'id'    => 'qty_color',
				'label' => esc_html__( 'Input Quantity Icons Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose color for input quantity icons', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_button'                  => [
				'id'    => 'sticky_bar_button',
				'type'  => 'title',
				'label' => esc_html__( 'Add to Cart Button Settings', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'sticky_bar_button_text_color'       => [
				'id'    => 'sticky_bar_button_text_color',
				'label' => esc_html__( 'Add to Cart Button Text Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose color for add-to-cart button', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_button_hover_text_color' => [
				'id'    => 'sticky_bar_button_hover_text_color',
				'label' => esc_html__( 'Add to Cart Button Hover Text Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose hover color for add-to-cart button', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_button_bg_color'         => [
				'id'    => 'sticky_bar_button_bg_color',
				'label' => esc_html__( 'Add to Cart Button Background Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose background color for add-to-cart button', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'sticky_bar_button_hover_bg_color'   => [
				'id'    => 'sticky_bar_button_hover_bg_color',
				'label' => esc_html__( 'Add to Cart Button Hover Background Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Choose hover background color for add-to-cart button', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
		];
	}

	/**
	 * Get sticky add-to-cart settings data.
	 *
	 * @return array
	 */
	public static function get_settings_data() {
		$settings    = Fns::get_options( 'modules', 'sticky_add_to_cart' ) ?? [];
		$cache_key   = 'rtsb_sticky_cart_settings_data_' . md5( wp_json_encode( $settings ) );
		$cached_data = wp_cache_get( $cache_key, 'shopbuilder' );

		if ( false !== $cached_data ) {
			return $cached_data;
		}

		$settings_data = [
			'position'          => RenderHelpers::get_data( $settings, 'sticky_position', 'bottom' ),
			'scrolling'         => RenderHelpers::get_data( $settings, 'visibility_triggers', 200 ),
			'animation'         => RenderHelpers::get_data( $settings, 'sticky_bar_animation', 'slide' ),
			'button_label'      => RenderHelpers::get_data( $settings, 'button_label', '' ),
			'show_fullwidth'    => RenderHelpers::get_data( $settings, 'show_fullwidth', '' ),
			'show_thumb'        => RenderHelpers::get_data( $settings, 'show_image', '' ),
			'show_title'        => RenderHelpers::get_data( $settings, 'show_product_title', '' ),
			'heading_tag'       => self::product_title_tag(),
			'show_qty'          => RenderHelpers::get_data( $settings, 'show_quantity_selector', '' ),
			'show_on_variation' => RenderHelpers::get_data( $settings, 'show_on_variation', '' ),
			'visibility'        => RenderHelpers::get_data( $settings, 'responsive_visibility', 'default' ),
			'color_scheme'      => RenderHelpers::get_data( $settings, 'sticky_color_scheme', 'light' ),
		];

		wp_cache_set( $cache_key, $settings_data, 'shopbuilder', 12 * HOUR_IN_SECONDS );
		Cache::set_data_cache_key( $cache_key );

		return $settings_data;
	}

	/**
	 * Sticky add-to-cart product title tag.
	 *
	 * @return string
	 */
	public static function product_title_tag() {
		$tag = Fns::get_options( 'modules', 'sticky_add_to_cart' )['sticky_bar_title_tag'] ?? 'h4';

		return Fns::get_validated_html_tag( $tag );
	}
}
