<?php
/**
 * Smart Coupons Frontend Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\SmartCoupons;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Frontend\FreeGift;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Frontend\URLCoupon;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Frontend\VolumeDiscount;
use RadiusTheme\SBPRO\Modules\SmartCoupons\Frontend\CouponManagement;

defined( 'ABSPATH' ) || exit();

/**
 * Sticky add-to-cart Frontend Class.
 */
class SmartCouponsFrontEnd {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Options.
	 *
	 * @var array|mixed
	 */
	private array $options;

	/**
	 * Settings data.
	 *
	 * @var array|mixed
	 */
	private array $data;

	/**
	 * Asset Handle
	 *
	 * @var string
	 */
	private $handle = 'rtsb-smart-coupons';

	/**
	 * Class Constructor.
	 */
	private function __construct() {
		/**
		 * Get the options.
		 */
		$this->options = Fns::get_options( 'modules', 'smart_coupons' );

		/**
		 * Cart page modifications.
		 */
		CouponManagement::instance();
		FreeGift::instance();
		VolumeDiscount::instance();
		URLCoupon::instance();

		/**
		 * Dynamic styles.
		 */
		add_action( 'wp_enqueue_scripts', [ $this, 'module_styles' ], 99 );
	}

	/**
	 * Dynamic styles.
	 *
	 * @return void
	 */
	public function module_styles() {
		wp_enqueue_script( 'rtsb-tippy' );

		// Enqueue assets.
		$this->handle = Fns::enqueue_module_assets(
			$this->handle,
			'smart-coupons',
			[
				'context' => rtsbpro(),
				'version' => RTSBPRO_VERSION,
			]
		);

		$cache_key = 'rtsb_smart_coupon_styles_' . md5( wp_json_encode( $this->options ) );
		$parent    = '.shortcode_coupon_list .rtsb-row';

		// phpcs:disable
		// Disabled phpcs for one-liner display.
		$css_properties = [
			'sc_coupon_bg_color'   => [ 'selector' => $parent, 'property' => '--rtsb-coupon-background' ],
			'sc_coupon_text_color' => [ 'selector' => $parent, 'property' => '--rtsb-coupon-text-color' ],
		];
		// phpcs:enable

		// Generate dynamic CSS.
		Fns::dynamic_styles( $this->options, $cache_key, $css_properties );
	}
}
