<?php
/**
 * Smart Coupons Module Coupon Categories Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\SmartCoupons;

use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Smart Coupons Module Coupon Categories Class.
 */
class CouponCategories {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Class Constructor.
	 */
	private function __construct() {
		/**
		 * Actions.
		 */
		add_action( 'init', [ $this, 'add_coupon_categories' ], 20 );
		add_action( 'admin_footer', [ $this, 'add_category_button' ] );

		/**
		 * Filters
		 */
		add_filter( 'parent_file', [ $this, 'active_menu' ] );
	}

	/**
	 * Register custom taxonomy.
	 *
	 * @return void
	 */
	public function add_coupon_categories() {
		$labels = [
			'name'              => _x( 'Coupon Groups', 'taxonomy general name', 'shopbuilder-pro' ),
			'singular_name'     => _x( 'Group', 'taxonomy singular name', 'shopbuilder-pro' ),
			'search_items'      => __( 'Search Coupon Groups', 'shopbuilder-pro' ),
			'all_items'         => __( 'All Coupon Groups', 'shopbuilder-pro' ),
			'parent_item'       => __( 'Parent Coupon Group', 'shopbuilder-pro' ),
			'parent_item_colon' => __( 'Parent Coupon Group:', 'shopbuilder-pro' ),
			'edit_item'         => __( 'Edit Coupon Group', 'shopbuilder-pro' ),
			'update_item'       => __( 'Update Coupon Group', 'shopbuilder-pro' ),
			'add_new_item'      => __( 'Add New Coupon Group', 'shopbuilder-pro' ),
			'new_item_name'     => __( 'New Coupon Group Name', 'shopbuilder-pro' ),
			'menu_name'         => __( 'Groups', 'shopbuilder-pro' ),
		];

		$args = [
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'public'            => false,
			'show_admin_column' => true,
			'query_var'         => true,
			'show_in_menu'      => false,
			'show_in_rest'      => true,
			'rewrite'           => [ 'slug' => 'coupon-group' ],
			'description'       => __( 'Manage Coupon Groups', 'shopbuilder-pro' ),
		];

		register_taxonomy( 'rtsb_coupon_group', [ 'shop_coupon' ], $args );
		register_taxonomy_for_object_type( 'rtsb_coupon_group', 'shop_coupon' );
	}

	/**
	 * Active menu
	 *
	 * @param string $parent_file Parent file.
	 */
	public function active_menu( $parent_file ) {
		global $current_screen;

		$taxonomy  = $current_screen->taxonomy;
		$screen_id = $current_screen->id;

		if ( 'rtsb_coupon_group' === $taxonomy || 'marketing_page_rtsb-smart-coupons' === $screen_id ) {
			$parent_file = 'woocommerce-marketing';

			add_filter(
				'submenu_file',
				function () {
					return 'edit.php?post_type=shop_coupon';
				}
			);
		}

		return $parent_file;
	}

	/**
	 * Add category button.
	 *
	 * @return void
	 */
	public function add_category_button() {
		global $pagenow, $current_screen;

		$post_type = $current_screen->post_type;

		if ( 'shop_coupon' === $post_type ) {
			if ( 'post.php' === $pagenow || 'post-new.php' === $pagenow ) {
				ob_start();
				?>
				<div class="rtsb-view-category">
					<a target="_blank" href="<?php echo esc_url( admin_url( 'edit-tags.php?taxonomy=rtsb_coupon_group&post_type=shop_coupon' ) ); ?>" style="">
						<?php echo esc_html__( 'Manage coupon groups', 'shopbuilder-pro' ); ?>
					</a>
				</div>
				<?php
				$html = wp_json_encode( ob_get_clean() );
				?>
				<script>
					(function($) {
						$(document).ready(function() {
							var target = $('#rtsb_coupon_group-tabs');

							if (target.length) {
								// HTML already escaped.
								target.before(<?php echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>);
							}
						});
					})(jQuery);
				</script>
				<?php
			}
		}
	}
}
