<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\QuickCheckout;

use RadiusTheme\SB\Helpers\Fns;
use WC_Product;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class CheckoutFns {

	/**
	 * @return array
	 */
	public static function settings_field() {
		return apply_filters(
			'rtsb/module/quick_checkout/fields',
			[
				'quick_checkout_clear_cart'             => [
					'id'    => 'quick_checkout_clear_cart',
					'value' => '',
					'type'  => 'switch',
					'label' => esc_html__( 'Clear Cart items Before Quick Checkout?', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'help'  => esc_html__( 'Enable This option to clear cart items that already added. Then Current Items will add to cart and ready to checkout.', 'shopbuilder-pro' ),
				],
				'quick_checkout_button_action'          => [
					'id'      => 'quick_checkout_button_action',
					'type'    => 'select',
					'value'   => 'redirect',
					'label'   => esc_html__( 'Button Action', 'shopbuilder-pro' ),
					'options' => [
						'redirect' => esc_html__( 'Redirect to Checkout', 'shopbuilder-pro' ),
						'popups'   => esc_html__( 'Open In a modal', 'shopbuilder-pro' ),
					],
					'help'    => esc_html__( 'Checkout Button Behavior After Click.', 'shopbuilder-pro' ),
					'tab'     => 'general',
				],
				'quick_checkout_button_text'            => [
					'id'    => 'quick_checkout_button_text',
					'type'  => 'text',
					'value' => esc_html__( 'Buy Now', 'shopbuilder-pro' ),
					'label' => esc_html__( 'Button Text', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				// Product Loop.
				'quick_checkout_shop_wrapper_heading'   => [
					'id'    => 'quick_checkout_shop_wrapper_heading',
					'type'  => 'title',
					'label' => esc_html__( 'Shop Page Settings', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				'show_quick_checkout_on_loop'           => [
					'id'    => 'show_quick_checkout_on_loop',
					'value' => 'on',
					'type'  => 'switch',
					'label' => esc_html__( 'Show in Shop Page', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				'loop_quick_checkout_position'          => [
					'id'         => 'loop_quick_checkout_position',
					'type'       => 'select',
					'value'      => 'custom',
					'label'      => esc_html__( 'Shop Page Button Position', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'You can manage Checkout Button position in shop page.', 'shopbuilder-pro' ),
					'options'    => [
						'before_add_to_cart' => esc_html__( 'Before Add To Cart', 'shopbuilder-pro' ),
						'after_add_to_cart'  => esc_html__( 'After Add To Cart', 'shopbuilder-pro' ),
						'shortcode'          => esc_html__( 'Use Shortcode', 'shopbuilder-pro' ),
						'custom'             => esc_html__( 'Custom Position', 'shopbuilder-pro' ),
					],
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_on_loop',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'loop_quick_checkout_shortcode'         => [
					'type'       => 'raw',
					'label'      => ' ',
					'html'       => sprintf(
					/* translators: 1: The shortcode.*/
						esc_html__( 'Choose where to show Checkout Button in WooCommerce product\'s loop. Copy this shortcode %1$s and paste it where you want to show.', 'shopbuilder-pro' ),
						'<code>[rtsb_quick_checkout_button]</code>'
					),

					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_on_loop',
								'value'    => 'on',
								'operator' => '==',
							],
							[
								'item'     => 'modules.quick_checkout.loop_quick_checkout_position',
								'value'    => 'shortcode',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'loop_custom_hook_name'                 => [
					'id'         => 'loop_custom_hook_name',
					'type'       => 'text',
					'label'      => esc_html__( 'Enter Hook Name', 'shopbuilder-pro' ),
					'help'       => sprintf(
					/* translators: 1: The shortcode.*/
						esc_html__( 'Or Copy the php code %1$s and paste it in your product query where you want to show the button.', 'shopbuilder-pro' ),
						"<code>&lt;?php do_action( 'rtsb/modules/quick_checkout/frontend/display' ); ?&gt;</code>"
					),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_on_loop',
								'value'    => 'on',
								'operator' => '==',
							],
							[
								'item'     => 'modules.quick_checkout.loop_quick_checkout_position',
								'value'    => 'custom',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'loop_hook_priority'                    => [
					'id'         => 'loop_hook_priority',
					'type'       => 'number',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Hook Priority', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'Checkout Button position hook priority.', 'shopbuilder-pro' ),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_on_loop',
								'value'    => 'on',
								'operator' => '==',
							],
							[
								'item'     => 'modules.quick_checkout.loop_quick_checkout_position',
								'value'    => 'shortcode',
								'operator' => '!=',
							],
						],
					],
					'tab'        => 'general',
				],

				// End Product Loop.
				// Single Product Page.
				'quick_checkout_single_wrapper_heading' => [
					'id'    => 'quick_checkout_single_wrapper_heading',
					'type'  => 'title',
					'label' => esc_html__( 'Product Page Settings', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				'show_quick_checkout_product_page'      => [
					'id'    => 'show_quick_checkout_product_page',
					'value' => 'on',
					'type'  => 'switch',
					'label' => esc_html__( 'Show Checkout Button in Product Page', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				'product_quick_checkout_position'       => [
					'id'         => 'product_quick_checkout_position',
					'label'      => esc_html__( 'Product Page Button Position', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'You can manage Checkout Button position in single product page.', 'shopbuilder-pro' ),
					'type'       => 'select',
					'value'      => 'custom',
					'options'    => [
						'before_add_to_cart' => esc_html__( 'Before Add To Cart', 'shopbuilder-pro' ),
						'after_add_to_cart'  => esc_html__( 'After Add To Cart', 'shopbuilder-pro' ),
						'after_thumbnail'    => esc_html__( 'After Image', 'shopbuilder-pro' ),
						'after_summary'      => esc_html__( 'After Summary', 'shopbuilder-pro' ),
						'after_short_desc'   => esc_html__( 'After Short Description', 'shopbuilder-pro' ),
						'shortcode'          => esc_html__( 'Use Shortcode', 'shopbuilder-pro' ),
						'custom'             => esc_html__( 'Custom Position', 'shopbuilder-pro' ),
					],
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_product_page',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'product_quick_checkout_shortcode'      => [
					'type'       => 'raw',
					'label'      => ' ',
					'html'       => sprintf(
					/* translators: 1: The shortcode.*/
						esc_html__( 'Choose where to show button on the product page. Copy this shortcode %1$s and paste it where you want to show the button.', 'shopbuilder-pro' ),
						'<code>[rtsb_quick_checkout_button]</code>'
					),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_product_page',
								'value'    => 'on',
								'operator' => '==',
							],
							[
								'item'     => 'modules.quick_checkout.product_quick_checkout_position',
								'value'    => 'shortcode',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'general',
				],
				'product_custom_hook_name'              => [
					'id'         => 'product_custom_hook_name',
					'type'       => 'text',
					'label'      => esc_html__( 'Product Hook Name', 'shopbuilder-pro' ),
					'tab'        => 'general',
					'help'       => sprintf(
					/* translators: 1: The shortcode.*/
						esc_html__( 'Copy this php code %1$s and paste it in your product query where you want to show the button.', 'shopbuilder-pro' ),
						"<code>&lt;?php do_action( 'rtsb/modules/quick_checkout/frontend/display' ); ?&gt;</code>"
					),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_product_page',
								'value'    => 'on',
								'operator' => '==',
							],
							[
								'item'     => 'modules.quick_checkout.product_quick_checkout_position',
								'value'    => 'custom',
								'operator' => '==',
							],
						],
					],

				],
				'product_hook_priority'                 => [
					'id'         => 'product_hook_priority',
					'type'       => 'number',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Hook Priority', 'shopbuilder-pro' ),
					'tab'        => 'general',
					'dependency' => [
						'rules'    => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_product_page',
								'value'    => 'on',
								'operator' => '==',
							],
						],
						'relation' => 'and',
					],
				],
				// Style Tab
				/**
				 * TODO: need below controls:
				 * TODO: 1. Button alignment
				 * TODO: 2. Button margin
				 * TODO: 3. Button Border radius.
				 */
				'loop_quick_checkout_button_height'     => [
					'id'         => 'loop_quick_checkout_button_height',
					'type'       => 'number',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Shop Page Button Height (px)', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'Checkout Button Button Height (px).', 'shopbuilder-pro' ),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_on_loop',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'style',
				],
				'loop_quick_checkout_button_padding'    => [
					'id'         => 'loop_quick_checkout_button_padding',
					'type'       => 'text',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Shop Page Button Padding (px)', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'Checkout Button Button Padding (px). Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_on_loop',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'style',
				],
				'loop_quick_checkout_button_margin'     => [
					'id'         => 'loop_quick_checkout_button_margin',
					'type'       => 'text',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Shop Page Button Margin (px)', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'Checkout Button Button Margin (px). Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_on_loop',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'style',
				],
				'product_quick_checkout_button_height'  => [
					'id'         => 'loop_quick_checkout_button_height',
					'type'       => 'number',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Product Page Button Height (px)', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'Checkout Button Button Height (px).', 'shopbuilder-pro' ),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_product_page',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'style',
				],

				'product_quick_checkout_button_padding' => [
					'id'         => 'product_quick_checkout_button_padding',
					'type'       => 'text',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Product Page Button Padding (px)', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'Checkout Button Button Padding (px). Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_product_page',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'style',
				],
				'product_quick_checkout_button_margin'  => [
					'id'         => 'product_quick_checkout_button_margin',
					'type'       => 'text',
					'size'       => 'small',
					'min'        => 0,
					'max'        => 999,
					'label'      => esc_html__( 'Product Page Button Margin (px)', 'shopbuilder-pro' ),
					'help'       => esc_html__( 'Checkout Button Button Margin (px). Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
					'dependency' => [
						'rules' => [
							[
								'item'     => 'modules.quick_checkout.show_quick_checkout_product_page',
								'value'    => 'on',
								'operator' => '==',
							],
						],
					],
					'tab'        => 'style',
				],
				'quick_checkout_background_color'       => [
					'id'    => 'quick_checkout_background_color',
					'label' => esc_html__( 'Checkout Button Background Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Change Notification background color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'quick_checkout_text_color'             => [
					'id'    => 'quick_checkout_text_color',
					'label' => esc_html__( 'Checkout Button Text Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Text Color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'quick_checkout_background_hover_color' => [
					'id'    => 'quick_checkout_background_hover_color',
					'label' => esc_html__( 'Checkout Button Hover Background Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Change Notification background color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

				'quick_checkout_text_hover_color'       => [
					'id'    => 'quick_checkout_text_hover_color',
					'label' => esc_html__( 'Checkout Button Hover Text Color', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Text Color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'style',
				],

			]
		);
	}
}
