<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\ProductSizeChart;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class SizeChart {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * @var array|mixed
	 */
	private array $options;

	/**
	 *
	 */
	private function __construct() {
		$this->options = Fns::get_options( 'modules', 'product_size_chart' );
		SizeChartFrontEnd::instance();
		add_filter('woocommerce_product_tabs', [ $this,  'add_custom_product_tab' ]);
	}

	// Callback function to display the content of the custom tab.
	public function size_chart_tab_content() {
		do_action( 'rtsb/modules/product_size_chart/frontend/display' );
	}

	public function add_custom_product_tab($tabs) {
		$chart = SizeChartFns::get_size_chart_for_current_product();
		if ( is_array( $chart ) && ! count( $chart ) ) {
			return $tabs;
		}
		// Check your condition here to determine whether to add the custom tab or not.
		$product_button_position = $this->options['product_size_chart_position'] ?? '';
		if ( 'product_tab' !== $product_button_position ) {
			return $tabs;
		}
		$product_hook_priority = absint( $this->options['product_hook_priority'] ?? 50 );
		// Add the new tab to the $tabs array.
		$tabs['custom_tab'] = array(
			'title'    => $this->options['size_chart_button_text'] ?? esc_html__( 'Size Chart', 'shopbuilder-pro' ), // Replace 'Custom Tab' with your desired tab title.
			'priority' => $product_hook_priority, // Set the priority for the position of the tab.
			'callback' => [ $this, 'size_chart_tab_content' ] // Callback function to display the tab content.
		);
		return $tabs;
	}

}
