<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\MultiStepsCheckout;

use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class MultiStepsCheckoutFns {
	/**
	 * @return array
	 */
	public static function settings_field() {
		return apply_filters(
			'rtsb/module/multistep_checkout_settings/fields',
			array_merge(
				[
					// Cart Drawer.
					'checkout_step_settings'   => [
						'id'    => 'checkout_step_settings',
						'type'  => 'title',
						'label' => esc_html__( 'Multi-step Checkout Settings', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],
					'checkout_layout'          => [
						'id'      => 'checkout_layout',
						'label'   => esc_html__( 'Checkout Layout', 'shopbuilder-pro' ),
						'help'    => esc_html__( 'Choose the checkout layout appearance', 'shopbuilder-pro' ),
						'type'    => 'image_select',
						'value'   => 'layout1',
						'tab'     => 'general',
						'options' => [
							'layout1' => [
								'label' => esc_html__( 'Layout 1', 'shopbuilder-pro' ),
								'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout-preview/multistep-checkout-layout-1.jpg' ) ),
							],
							'layout2' => [
								'label' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
								'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout-preview/multistep-checkout-lauout-2.jpg' ) ),
							],

						],

					],
					'login_step_visibility'    => [
						'id'    => 'show_login_step',
						'type'  => 'switch',
						'label' => esc_html__( 'Login Step Visibility', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Enable this option to show Login Step. Please note that this settings will override the WooCommerce Guest checkout login option.', 'shopbuilder-pro' ),
						'tab'   => 'general',
						'value' => 'on',
					],

					'show_back_to_cart_button' => [
						'id'    => 'show_back_to_cart_button',
						'type'  => 'switch',
						'label' => esc_html__( 'Back to Cart Button Visibility', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Enable this option to Show Back to cart button', 'shopbuilder-pro' ),
						'tab'   => 'general',
						'value' => 'on',
					],

					'checkout_text_change'     => [
						'id'    => 'checkout_text_change',
						'type'  => 'title',
						'label' => esc_html__( 'Change Label', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],

					// Change all text.
					'back_to_top_btn_text'     => [
						'id'    => 'back_to_top_btn_text',
						'type'  => 'text',
						'label' => esc_html__( 'Back to Cart', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Change "Back to cart" button text', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],
					'previous_btn_text'        => [
						'id'    => 'previous_btn_text',
						'type'  => 'text',
						'label' => esc_html__( 'Previous Button', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Change "Previous" button text', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],
					'next_btn_text'            => [
						'id'    => 'next_btn_text',
						'type'  => 'text',
						'label' => esc_html__( 'Next Button', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Change "Next" button text', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],
					'skip_login_btn_text'      => [
						'id'    => 'skip_login_btn_text',
						'type'  => 'text',
						'label' => esc_html__( 'Skip Login', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Change "Skip Login" button text', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],
					'place_order_btn_text'     => [
						'id'    => 'place_order_btn_text',
						'type'  => 'text',
						'label' => esc_html__( 'Place Order', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Change "Place Order" button text', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],
					'multi_step_icon_note'     => [
						'id'   => 'multi_step_icon_note',
						'type' => 'description',
						'text' => esc_html__( 'Please note that, only layout 2 support multi-step menu icon', 'shopbuilder-pro' ),
						'tab'  => 'step_icon',
					],
				],
				self::get_icon_settings( 'login', 'Login' ),
				self::get_icon_settings( 'billing', 'Billing' ),
				self::get_icon_settings( 'shipping', 'Shipping' ),
				self::get_icon_settings( 'order', 'Order' ),
				self::get_icon_settings( 'payment', 'Payment' ),
				[
					// TODO: Not implemented yet.
					// Style.
					'primary_color'                      => [
						'id'          => 'primary_color',
						'label'       => esc_html__( 'Primary Color', 'shopbuilder-pro' ),
						'type'        => 'color',
						'default_val' => '#034DFF',
						'tab'         => 'style',
					],
					'wrapper_padding'                    => [
						'id'    => 'wrapper_padding',
						'label' => esc_html__( 'Wrapper Padding', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Wrapper padding. Example 1: 20px, Example 2: 20px 20px 20px 20px', 'shopbuilder-pro' ),
						'type'  => 'text',
						'tab'   => 'style',
					],
					// Timeline Control.
					'timeline_styles'                    => [
						'id'    => 'timeline_styles',
						'type'  => 'title',
						'label' => esc_html__( 'Timeline', 'shopbuilder-pro' ),
						'tab'   => 'style',
					],
					'timeline_color'                     => [
						'id'    => 'timeline_color',
						'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'timeline_active_color'              => [
						'id'    => 'timeline_active_color',
						'label' => esc_html__( 'Active Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'timeline_font_size'                 => [
						'id'    => 'timeline_font_size',
						'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 50,
						'unit'  => 'px',
						'value' => 15,
						'tab'   => 'style',
					],
					'timeline_position'                  => [
						'id'    => 'timeline_position',
						'label' => esc_html__( 'Top Position', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => -200,
						'max'   => 200,
						'unit'  => 'px',
						'tab'   => 'style',
					],
					// Back To cart.
					'back_to_cart_button_styles'         => [
						'id'    => 'back_to_cart_button_styles',
						'type'  => 'title',
						'label' => esc_html__( 'Back To Cart Button Style ', 'shopbuilder-pro' ),
						'tab'   => 'style',
					],
					'back_to_cart_button_height'         => [
						'id'    => 'next_button_height',
						'label' => esc_html__( 'Height (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 100,
						'unit'  => 'px',
						'value' => 50,
						'tab'   => 'style',
					],
					'back_to_cart_button_font_size'      => [
						'id'    => 'next_button_font_size',
						'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 50,
						'unit'  => 'px',
						'value' => 15,
						'tab'   => 'style',
					],
					'back_to_cart_button_bg_color'       => [
						'id'    => 'next_button_bg_color',
						'label' => esc_html__( 'Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'back_to_cart_button_hover_bg_color' => [
						'id'    => 'next_button_hover_bg_color',
						'label' => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'back_to_cart_button_color'          => [
						'id'    => 'next_button_color',
						'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'back_to_cart_button_hover_color'    => [
						'id'    => 'next_button_hover_color',
						'label' => esc_html__( 'Hover Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'back_to_cart_button_border_color'   => [
						'id'    => 'next_button_border_color',
						'label' => esc_html__( 'Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'back_to_cart_button_hover_border_color' => [
						'id'    => 'next_button_hover_border_color',
						'label' => esc_html__( 'Hover Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],

					'prev_button_styles_settings'        => [
						'id'    => 'prev_button_styles_settings',
						'type'  => 'title',
						'tab'   => 'style',
						'label' => esc_html__( 'Prev Button Style', 'shopbuilder-pro' ),
					],
					'prev_button_height'                 => [
						'id'    => 'prev_button_height',
						'label' => esc_html__( 'Height (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 100,
						'unit'  => 'px',
						'value' => 50,
						'tab'   => 'style',
					],
					'prev_button_font_size'              => [
						'id'    => 'prev_button_font_size',
						'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 50,
						'unit'  => 'px',
						'value' => 15,
						'tab'   => 'style',
					],
					'prev_button_bg_color'               => [
						'id'    => 'prev_button_bg_color',
						'label' => esc_html__( 'Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'prev_button_hover_bg_color'         => [
						'id'    => 'prev_button_hover_bg_color',
						'label' => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'prev_button_color'                  => [
						'id'    => 'prev_button_color',
						'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'prev_button_hover_color'            => [
						'id'    => 'prev_button_hover_color',
						'label' => esc_html__( 'Hover Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'prev_button_border_color'           => [
						'id'    => 'prev_button_border_color',
						'label' => esc_html__( 'Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'prev_button_hover_border_color'     => [
						'id'    => 'prev_button_hover_border_color',
						'label' => esc_html__( 'Hover Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					// Next Button.
					'next_button_styles_settings'        => [
						'id'    => 'next_button_styles_settings',
						'type'  => 'title',
						'tab'   => 'style',
						'label' => esc_html__( 'Next Button Style', 'shopbuilder-pro' ),
					],
					'next_button_height'                 => [
						'id'    => 'next_button_height',
						'label' => esc_html__( 'Height (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 100,
						'unit'  => 'px',
						'value' => 50,
						'tab'   => 'style',
					],
					'next_button_font_size'              => [
						'id'    => 'next_button_font_size',
						'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 50,
						'unit'  => 'px',
						'value' => 15,
						'tab'   => 'style',
					],
					'next_button_bg_color'               => [
						'id'    => 'next_button_bg_color',
						'label' => esc_html__( 'Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'next_button_hover_bg_color'         => [
						'id'    => 'next_button_hover_bg_color',
						'label' => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'next_button_color'                  => [
						'id'    => 'next_button_color',
						'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'next_button_hover_color'            => [
						'id'    => 'next_button_hover_color',
						'label' => esc_html__( 'Hover Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'next_button_border_color'           => [
						'id'    => 'next_button_border_color',
						'label' => esc_html__( 'Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'next_button_hover_border_color'     => [
						'id'    => 'next_button_hover_border_color',
						'label' => esc_html__( 'Hover Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					// Place Order.
					'place_order_button_styles_settings' => [
						'id'    => 'place_order_button_styles_settings',
						'type'  => 'title',
						'tab'   => 'style',
						'label' => esc_html__( 'Place Order Button Style', 'shopbuilder-pro' ),
					],
					'place_order_button_height'          => [
						'id'    => 'place_order_button_height',
						'label' => esc_html__( 'Height (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 100,
						'unit'  => 'px',
						'value' => 50,
						'tab'   => 'style',
					],
					'place_order_button_font_size'       => [
						'id'    => 'place_order_button_font_size',
						'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
						'type'  => 'slider',
						'min'   => 10,
						'max'   => 50,
						'unit'  => 'px',
						'value' => 15,
						'tab'   => 'style',
					],
					'place_order_button_bg_color'        => [
						'id'    => 'place_order_button_bg_color',
						'label' => esc_html__( 'Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'place_order_button_hover_bg_color'  => [
						'id'    => 'place_order_button_hover_bg_color',
						'label' => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'place_order_button_color'           => [
						'id'    => 'place_order_button_color',
						'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'place_order_button_hover_color'     => [
						'id'    => 'place_order_button_hover_color',
						'label' => esc_html__( 'Hover Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'place_order_button_border_color'    => [
						'id'    => 'place_order_button_border_color',
						'label' => esc_html__( 'Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
					'place_order_button_hover_border_color' => [
						'id'    => 'place_order_button_hover_border_color',
						'label' => esc_html__( 'Hover Border Color', 'shopbuilder-pro' ),
						'tab'   => 'style',
						'type'  => 'color',
					],
				]
			)
		);
	}

	/**
	 * Checkout Steps
	 *
	 * @return array[]
	 */
	public static function checkout_steps() {

		return apply_filters(
			'rtsb_checkout_steps',
			[
				'billing'  => [
					'title'    => __( 'Billing', 'shopbuilder-pro' ),
					'position' => 10,
					'class'    => 'rtrb-checkout-step-billing',
					'sections' => [ 'billing' ],
				],
				'shipping' => [
					'title'    => __( 'Shipping', 'shopbuilder-pro' ),
					'position' => 20,
					'class'    => 'rtrb-checkout-step-shipping',
					'sections' => [ 'shipping' ],
				],
				'order'    => [
					'title'    => __( 'Order', 'shopbuilder-pro' ),
					'position' => 30,
					'class'    => 'rtrb-checkout-step-order',
					'sections' => [ 'order' ],
				],
				'payment'  => [
					'title'    => __( 'Payment', 'shopbuilder-pro' ),
					'position' => 40,
					'class'    => 'rtrb-checkout-step-payment',
					'sections' => [ 'payment' ],
				],
			]
		);
	}
	/**
	 * Retrieve an array of custom icons with their HTML representation.
	 *
	 * @return array
	 */
	public static function get_icons() {

		if ( method_exists( Fns::class, 'get_icons' ) ) {
			return Fns::get_icons();
		}
		// TODO:: Below Code Will Remove In the future.
		$icon        = Fns::get_custom_icon_names();
		$icons_array = [];
		foreach ( $icon as $value ) {
			$icons_array[ $value ] = '<i class="rtsb-icon rtsb-icon-' . $value . '"></i> <span class="icon-name">' . ucfirst( str_replace( '-', ' ', $value ) ) . '</span>';
		}
		return $icons_array;
	}
	/**
	 * Retrieve an array of custom icon settings for different navigation steps.
	 *
	 * @param string $type  The type of icon (e.g., 'login', 'billing').
	 * @param string $label The label for the icon (e.g., 'Login', 'Billing').
	 *
	 * @return array The array of icon settings.
	 */
	private static function get_icon_settings( $type, $label ) {
		return [
			"{$type}_icon_settings" => [
				'id'    => "{$type}_icon_settings",
				'type'  => 'title',
				// translators: %s is replaced with the icon type (e.g., Login, Billing).
				'label' => sprintf( esc_html__( '%s Navigation Icon', 'shopbuilder-pro' ), $label ),
				'tab'   => 'step_icon',
			],
			"{$type}_icon"          => [
				'id'      => "{$type}_icon",
				'label'   => esc_html__( 'Icon', 'shopbuilder-pro' ),
				// translators: %s is replaced with the icon type (e.g., Login, Billing).
				'help'    => sprintf( esc_html__( 'Please select the %s icon.', 'shopbuilder-pro' ), $label ),
				'type'    => 'select',
				'value'   => 'none',
				'options' => [
					'none'   => esc_html__( 'None', 'shopbuilder-pro' ),
					'custom' => esc_html__( 'Select Icon', 'shopbuilder-pro' ),
					'upload' => esc_html__( 'Upload Icon', 'shopbuilder-pro' ),
				],
				'tab'     => 'step_icon',
			],
			"{$type}_custom_icon"   => [
				'id'         => "{$type}_custom_icon",
				'label'      => esc_html__( 'Select Icon', 'shopbuilder-pro' ),
				// translators: %s is replaced with the icon type (e.g., Login, Billing).
				'help'       => sprintf( esc_html__( 'Please choose the %s custom icon.', 'shopbuilder-pro' ), $label ),
				'type'       => 'icon_select',
				'searchable' => true,
				'options'    => self::get_icons(),
				'dependency' => [
					'rules' => [
						[
							'item'     => "modules.multi_step_checkout.{$type}_icon",
							'value'    => 'custom',
							'operator' => '==',
						],
					],
				],
				'tab'        => 'step_icon',
			],
			"{$type}_image_icon"    => [
				'id'         => "{$type}_image_icon",
				'type'       => 'fileupload',
				'label'      => esc_html__( 'Upload Custom Icon', 'shopbuilder-pro' ),
				// translators: %s is replaced with the icon type (e.g., Login, Billing).
				'help'       => sprintf( esc_html__( 'Please upload the %s custom icon.', 'shopbuilder-pro' ), $label ),
				'dependency' => [
					'rules' => [
						[
							'item'     => "modules.multi_step_checkout.{$type}_icon",
							'value'    => 'upload',
							'operator' => '==',
						],
					],
				],
				'tab'        => 'step_icon',
			],
		];
	}
	/**
	 * Generates HTML markup for displaying an endpoint icon.
	 *
	 * @param array   $data     The endpoint data containing icon information.
	 * @param string  $endpoint The endpoint identifier.
	 * @param boolean $wrapper  Whether to wrap the icon in a span element.
	 *
	 * @return string
	 */
	public static function get_icon_html( $data, $endpoint, $wrapper = true ) {
		if ( empty( $data ) || 'none' === $data[ $endpoint . '_icon' ] ) {
			return '';
		}

		$html = $wrapper ? '<span class="icon ' . esc_attr( $endpoint ) . '_icon">' : '';

		if ( 'custom' === $data[ $endpoint . '_icon' ] ) {
			$html .= ! empty( $data[ $endpoint . '_custom_icon' ] ) ? '<i class="rtsb-icon rtsb-icon-' . esc_attr( $data[ $endpoint . '_custom_icon' ] ) . '"></i>' : '';
		} else {
			$icon_html  = '';
			$image_icon = json_decode( stripslashes( $data[ $endpoint . '_image_icon' ] ?? '' ), true );
			$icon_url   = $image_icon['source'] ?? '';
			$icon_id    = $image_icon['id'] ?? 0;
			$extension  = ! empty( $icon_url ) ? strtolower( substr( strrchr( $image_icon['source'], '.' ), 1 ) ) : '';

			if ( 'svg' === $extension ) {
				$content = file_get_contents( $icon_url ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
				$is_svg  = strpos( $content, '<svg' );

				if ( false !== $is_svg ) {
					$icon_html = substr( $content, $is_svg );
				}
			} else {
				$attr = [
					'class' => 'rtsb-icon-img',
					'alt'   => esc_html( ucfirst( $endpoint ) ) . esc_html__( ' Icon', 'shopbuilder-pro' ),
				];

				$icon_html = wp_get_attachment_image( absint( $icon_id ), 'full', true, $attr );
			}

			$html .= $icon_html;
		}

		$html .= $wrapper ? '</span>' : '';

		return $html;
	}
}
