<?php
/**
 * Main MiniCart class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\MultiStepsCheckout;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class MultiStepsCheckout {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * @var array|mixed
	 */
	private array $options;

	/**
	 * Asset Handle
	 *
	 * @var string
	 */
	private $handle = 'rtsb-multi-step-checkout';

	/**
	 * Class constructor
	 */
	private function __construct() {
		$this->options = Fns::get_options( 'modules', 'multi_step_checkout' );
		if ( class_exists( 'Astra_Woocommerce' ) ) {
			remove_action( 'wp', [ \Astra_Woocommerce::get_instance(), 'woocommerce_checkout' ] );
		}
		add_filter( 'woocommerce_locate_template', [ $this, 'woocommerce_locate_template' ], 30, 3 );
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_public_scripts' ], 99 );
	}

	/**
	 * WooCommerce locate template
	 *
	 * @param  string $template The template.
	 * @param  string $template_name The template name.
	 * @param  string $template_path The template path.
	 *
	 * @return string
	 */
	public function woocommerce_locate_template( $template, $template_name, $template_path ) { // phpcs:ignore Generic.CodeAnalysis.UnusedFunctionParameter.FoundAfterLastUsed

		if ( 'checkout/form-checkout.php' !== $template_name ) {
			return $template;
		}
		MultiStepsHooks::instance();
		$checkout_style = $this->options['checkout_layout'] ?? 'form-checkout';
		$new_template   = RTSBPRO_PATH . "templates/multi-step-checkout/{$checkout_style}.php";
		return ( 'layout1' !== $checkout_style && file_exists( $new_template ) )
			? $new_template
			: RTSBPRO_PATH . 'templates/multi-step-checkout/form-checkout.php';
	}


	/**
	 * Public CSS
	 *
	 * @return void
	 */
	public function enqueue_public_scripts() {
		// Enqueue assets.
		$this->handle = Fns::enqueue_module_assets(
			$this->handle,
			'multi-step-checkout',
			[
				'context' => rtsbpro(),
				'version' => RTSBPRO_VERSION,
			]
		);

		if ( ! apply_filters( 'rtsb/module/step_checkout/show_button', true ) ) {
			return;
		}
		$cache_key = 'multi_step_checkout_cache_key';
		// Selector variables.
		$back_to_cart_selector       = '.rtrb-checkout-steps-wrapper button#rtrb-checkout-back-to-cart';
		$back_to_cart_hover_selector = $back_to_cart_selector . ':hover';
		$prev_selector               = '.rtrb-checkout-steps-wrapper button#rtrb-checkout-prev';
		$prev_hover_selector         = $prev_selector . ':hover';
		$next_selector               = '.rtrb-checkout-steps-wrapper button#rtrb-checkout-next';
		$next_hover_selector         = $next_selector . ':hover';

		$place_order_selector       = '.rtrb-checkout-steps-wrapper .woocommerce-checkout button[name=woocommerce_checkout_place_order]';
		$place_order_hover_selector = $place_order_selector . ':hover';

		$timeline              = '.rtrb-checkout-tab-container .rtrb-checkout-tab-item .rtrb-checkout-tab-text';
		$timeline_active_color = '.rtrb-checkout-tab-container .rtrb-checkout-tab-item.current .rtrb-checkout-tab-text';

        // phpcs:disable
        // Disabled phpcs for one-liner display.
        $css_properties = [
            'primary_color'                             => [ 'selector' => ':root', 'property' => '--rtsb-checkout-primary' ],
            'wrapper_padding'                           => [ 'selector' => '.rtrb-checkout-multistep-wrapper', 'property' => 'padding' ],
            'timeline_color'                            => [ 'selector' => $timeline, 'property' => 'color' ],
            'timeline_active_color'                     => [ 'selector' => $timeline_active_color, 'property' => 'color' ],
            'timeline_font_size'                        => [ 'selector' => $timeline, 'property' => 'font-size', 'unit' => 'px' ],
            'timeline_position'                         => [ 'selector' => $timeline, 'property' => 'top', 'unit' => 'px' ],
            'back_to_cart_button_height'                => [ 'selector' => $back_to_cart_selector, 'property' => 'height', 'unit' => 'px' ],
            'back_to_cart_button_font_size'             => [ 'selector' => $back_to_cart_selector, 'property' => 'font-size', 'unit' => 'px' ],
            'back_to_cart_button_bg_color'              => [ 'selector' => $back_to_cart_selector, 'property' => 'background-color' ],
            'back_to_cart_button_hover_bg_color'        => [ 'selector' => $back_to_cart_hover_selector, 'property' => 'background-color' ],
            'back_to_cart_button_color'                 => [ 'selector' => $back_to_cart_selector, 'property' => 'color' ],
            'back_to_cart_button_hover_color'           => [ 'selector' => $back_to_cart_hover_selector, 'property' => 'color' ],
            'back_to_cart_button_border_color'          => [ 'selector' => $back_to_cart_selector, 'property' => 'border-color' ],
            'back_to_cart_button_hover_border_color'    => [ 'selector' => $back_to_cart_hover_selector, 'property' => 'border-color' ],
            'prev_button_height'                        => [ 'selector' => $prev_selector, 'property' => 'height', 'unit' => 'px' ],
            'prev_button_font_size'                     => [ 'selector' => $prev_selector, 'property' => 'font-size', 'unit' => 'px' ],
            'prev_button_bg_color'                      => [ 'selector' => $prev_selector, 'property' => 'background-color' ],
            'prev_button_hover_bg_color'                => [ 'selector' => $prev_hover_selector, 'property' => 'background-color' ],
            'prev_button_color'                         => [ 'selector' => $prev_selector, 'property' => 'color' ],
            'prev_button_hover_color'                   => [ 'selector' => $prev_hover_selector, 'property' => 'color' ],
            'prev_button_border_color'                  => [ 'selector' => $prev_selector, 'property' => 'border-color' ],
            'prev_button_hover_border_color'            => [ 'selector' => $prev_hover_selector, 'property' => 'border-color' ],
            'next_button_height'                        => [ 'selector' => $next_selector, 'property' => 'height', 'unit' => 'px' ],
            'next_button_font_size'                     => [ 'selector' => $next_selector, 'property' => 'font-size', 'unit' => 'px' ],
            'next_button_bg_color'                      => [ 'selector' => $next_selector, 'property' => 'background-color' ],
            'next_button_hover_bg_color'                => [ 'selector' => $next_hover_selector, 'property' => 'background-color' ],
            'next_button_color'                         => [ 'selector' => $next_selector, 'property' => 'color' ],
            'next_button_hover_color'                   => [ 'selector' => $next_hover_selector, 'property' => 'color' ],
            'next_button_border_color'                  => [ 'selector' => $next_selector, 'property' => 'border-color' ],
            'next_button_hover_border_color'            => [ 'selector' => $next_hover_selector, 'property' => 'border-color' ],
            'place_order_button_height'                 => [ 'selector' => $place_order_selector, 'property' => 'height', 'unit' => 'px' ],
            'place_order_button_font_size'              => [ 'selector' => $place_order_selector, 'property' => 'font-size', 'unit' => 'px' ],
            'place_order_button_bg_color'               => [ 'selector' => $place_order_selector, 'property' => 'background-color' ],
            'place_order_button_hover_bg_color'         => [ 'selector' => $place_order_hover_selector, 'property' => 'background-color' ],
            'place_order_button_color'                  => [ 'selector' => $place_order_selector, 'property' => 'color' ],
            'place_order_button_hover_color'            => [ 'selector' => $place_order_hover_selector, 'property' => 'color' ],
            'place_order_button_border_color'           => [ 'selector' => $place_order_selector, 'property' => 'border-color' ],
            'place_order_button_hover_border_color'     => [ 'selector' => $place_order_hover_selector, 'property' => 'border-color' ],
        ];
        // phpcs:enable
		// Generate dynamic CSS.
		Fns::dynamic_styles( $this->options, $cache_key, $css_properties );
	}
}
