<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\MiniCart;

use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class MiniCartFns {

	/**
	 * @return array
	 */
	public static function settings_field() {
		// Get Cart Page ID
		$cart_page_id = get_option( 'woocommerce_cart_page_id' ) ?? 0;
		// Get Checkout Page ID
		$checkout_page_id = get_option( 'woocommerce_checkout_page_id' ) ?? 0;

		return apply_filters(
			'rtsb/module/minicart_settings/fields',
			[

				// Cart Drawer
				// ======================
				'mini_cart_wrapper_heading'        => [
					'id'    => 'mini_cart_wrapper_heading',
					'type'  => 'title',
					'label' => esc_html__( 'Cart Drawer Settings', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'mini_cart_drawer_style'           => [
					'id'      => 'mini_cart_drawer_style',
					'type'    => 'select',
					'value'   => 'style1',
					'label'   => esc_html__( 'Drawer Style', 'shopbuilder-pro' ),
					'options' => [
						'style1' => esc_html__( 'Style - 01', 'shopbuilder-pro' ),
						'style2' => esc_html__( 'Style - 02', 'shopbuilder-pro' ),
						'style3' => esc_html__( 'Style - 03', 'shopbuilder-pro' ),
					],
					'tab'     => 'general',
				],

				'mini_cart_open_style'             => [
					'id'      => 'mini_cart_open_style',
					'type'    => 'select',
					'value'   => 'open-always',
					'label'   => esc_html__( 'Drawer Opening Behavior', 'shopbuilder-pro' ),
					'options' => [
						'open-always'  => esc_html__( 'Open each time after add to the cart', 'shopbuilder-pro' ),
						'open-onclick' => esc_html__( 'Open when floating button is clicked', 'shopbuilder-pro' ),
					],
					'tab'     => 'general',
				],

				'mini_cart_position'               => [
					'id'      => 'mini_cart_position',
					'type'    => 'select',
					'value'   => 'left_center',
					'label'   => esc_html__( 'Mini Cart Position ', 'shopbuilder-pro' ),
					'help'    => esc_html__( 'You can manage mini_cart position.', 'shopbuilder-pro' ),
					'options' => [
						'left_center'  => esc_html__( 'left Center', 'shopbuilder-pro' ),
						'left_bottom'  => esc_html__( 'left Bottom', 'shopbuilder-pro' ),
						'right_center' => esc_html__( 'Right Center', 'shopbuilder-pro' ),
						'right_bottom' => esc_html__( 'Right Bottom', 'shopbuilder-pro' ),
					],
					'tab'     => 'general',
				],

				'mini_cart_extra_field_visibility' => [
					'id'    => 'mini_cart_extra_field_visibility',
					'type'  => 'switch',
					'label' => esc_html__( 'Price extra field Visibility', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable to showing all cost (Shipping, Tax etc) in price table. Otherwise only Subtotal will show.', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => 'on',
				],

				'mini_cart_coupon_visibility'      => [
					'id'    => 'mini_cart_coupon_visibility',
					'type'  => 'switch',
					'label' => esc_html__( 'Coupon Form Visibility', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'You may show / hide coupon input box on the mini-cart footer area', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'mini_cart_empty_text'             => [
					'id'    => 'mini_cart_empty_text',
					'type'  => 'text',
					'label' => esc_html__( 'Empty Cart Message', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enter empty cart message. E.g: No products in the cart', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => esc_html__( 'No products in the cart.', 'shopbuilder-pro' ),
				],

				'mini_cart_go_shopping_btn_text'   => [
					'id'    => 'mini_cart_go_shopping_btn_text',
					'type'  => 'text',
					'label' => esc_html__( 'Shop Button Text', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Change Go Shopping Button text', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => esc_html__( 'Go Shopping', 'shopbuilder-pro' ),
				],

				'mini_cart_empty_image'            => [
					'id'    => 'mini_cart_empty_image',
					'type'  => 'fileupload',
					'label' => esc_html__( 'Empty Cart Image', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Upload empty cart image. Please upload the exact size image.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'mini_cart_loading_image'          => [
					'id'    => 'mini_cart_loading_image',
					'type'  => 'fileupload',
					'label' => esc_html__( 'Loader Image', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Upload loader image. Please upload the exact size gif image.', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'mini_cart_float_button_heading'   => [
					'id'    => 'mini_cart_float_button_heading',
					'type'  => 'title',
					'label' => esc_html__( 'Float Button Settings', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				'hide_mini_cart'                   => [
					'id'    => 'hide_mini_cart',
					'type'  => 'switch',
					'label' => esc_html__( 'Hide Mini Cart', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to hide mini cart', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],
				'mini_cart_float_btn_style'        => [
					'id'      => 'mini_cart_float_btn_style',
					'type'    => 'select',
					'value'   => 'style1',
					'label'   => esc_html__( 'Float Button Style', 'shopbuilder-pro' ),
					'options' => [
						'style1' => esc_html__( 'Style # 01', 'shopbuilder-pro' ),
						'style2' => esc_html__( 'Style # 02', 'shopbuilder-pro' ),
						'style3' => esc_html__( 'Style # 03', 'shopbuilder-pro' ),
						'style4' => esc_html__( 'Style # 04', 'shopbuilder-pro' ),
					],
					'tab'     => 'general',
				],

				'mini_cart_others_settings'        => [
					'id'    => 'mini_cart_others_settings',
					'type'  => 'title',
					'label' => esc_html__( 'Others Settings', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'mini_cart_flying_animation'       => [
					'id'    => 'mini_cart_flying_animation',
					'type'  => 'switch',
					'label' => esc_html__( 'Flying Cart (Animation)', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to animated flying cart', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => 'on',
				],

				'mini_cart_overlay_visibility'     => [
					'id'    => 'mini_cart_overlay_visibility',
					'type'  => 'switch',
					'label' => esc_html__( 'Overlay Visibility', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to show the overlay', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => 'on',
				],

				'mini_cart_show_on_mobile'         => [
					'id'    => 'mini_cart_show_on_mobile',
					'type'  => 'switch',
					'label' => esc_html__( 'Show On Mobile', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'Enable this option to Show On Mobile.', 'shopbuilder-pro' ),
					'tab'   => 'general',
					'value' => 'on',
				],

				'mini_cart_custom_selector'        => [
					'id'    => 'mini_cart_custom_selector',
					'type'  => 'text',
					'label' => esc_html__( 'Custom Class to Open Mini Cart', 'shopbuilder-pro' ),
					'help'  => esc_html__( 'If you would like to open the mini-cart by custom button on click just add the class name with comma separator. E.g: .icon-area-content a, span.cart-btn', 'shopbuilder-pro' ),
					'tab'   => 'general',
				],

				'mini_cart_include_page'           => [
					'id'              => 'mini_cart_include_page',
					'label'           => esc_html__( 'Include Pages', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'If you don\'t choose any page from here the Mini Cart will show all pages.', 'shopbuilder-pro' ),
					'type'            => 'search_and_multi_select',
					'placeholder'     => esc_html__( 'Choose Pages', 'shopbuilder-pro' ),
					'func_with_param' => [
						Fns::class,
						'get_post_types',
						[
							'post_type'        => 'page',
							'suppress_filters' => false,
						],
					],
					'options'         => Fns::get_post_types(
						null,
						[
							'post_type'        => 'page',
							'suppress_filters' => false,
							'post__not_in'     => [
								$cart_page_id,
								$checkout_page_id,
							],
						]
					),
					'tab'             => 'filter',
				],

				'mini_cart_include_archive'        => [
					'id'              => 'mini_cart_include_archive',
					'label'           => esc_html__( 'Include Archive Page', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'If you don\'t choose any page from here the Mini Cart will show all archive pages.', 'shopbuilder-pro' ),
					'type'            => 'search_and_multi_select',
					'placeholder'     => esc_html__( 'Choose Archive Page', 'shopbuilder-pro' ),
					'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'archive' ] ],
					'options'         => Fns::get_post_types( null, [ 'post_type' => 'archive' ] ),
					'tab'             => 'filter',
				],

				'mini_cart_include_details_page'   => [
					'id'              => 'mini_cart_include_details_page',
					'label'           => esc_html__( 'Include Details Page', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'If you don\'t choose any details page from here the Mini Cart will show all details pages.', 'shopbuilder-pro' ),
					'type'            => 'search_and_multi_select',
					'placeholder'     => esc_html__( 'Choose Details Page', 'shopbuilder-pro' ),
					'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'archive' ] ],
					'options'         => Fns::get_post_types( null, [ 'post_type' => 'archive' ] ),
					'tab'             => 'filter',
				],

				'mini_cart_exclude_page'           => [
					'id'              => 'mini_cart_exclude_page',
					'label'           => esc_html__( 'Exclude Pages', 'shopbuilder-pro' ),
					'help'            => esc_html__( 'Exclude pages from here.', 'shopbuilder-pro' ),
					'type'            => 'search_and_multi_select',
					'placeholder'     => esc_html__( 'Choose Pages', 'shopbuilder-pro' ),
					'func_with_param' => [
						Fns::class,
						'get_post_types',
						[
							'post_type'        => 'page',
							'suppress_filters' => false,
						],
					],
					'options'         => Fns::get_post_types(
						null,
						[
							'post_type'        => 'page',
							'suppress_filters' => false,
							'post__not_in'     => [
								$cart_page_id,
								$checkout_page_id,
							],
						]
					),
					'tab'             => 'filter',
				],

				// Floating Button Style Tab.

				'mini_cart_float_bg'               => [
					'id'    => 'mini_cart_float_bg',
					'label' => esc_html__( 'Button Background', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'floating_button',
				],

				'mini_cart_float_bg_hover'         => [
					'id'    => 'mini_cart_float_bg_hover',
					'label' => esc_html__( 'Button Background - Hover', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'floating_button',
				],

				'mini_cart_btn_width'              => [
					'id'          => 'mini_cart_btn_width',
					'type'        => 'number',
					'sanitize_fn' => 'absint',
					'help'        => esc_html__( 'If you need you can enter float button width', 'shopbuilder-pro' ),
					'label'       => esc_html__( 'Float Button Min Width', 'shopbuilder-pro' ),
					'tab'         => 'floating_button',
				],

				'mini_cart_float_btn_radius'       => [
					'id'          => 'mini_cart_float_btn_radius',
					'type'        => 'text',
					'placeholder' => '10px',
					'label'       => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
					'help'        => esc_html__( 'Enter Border Radius. Ex. 10px | 5px 5px 5px 5px | 0 5px 5px 0', 'shopbuilder-pro' ),
					'tab'         => 'floating_button',
				],

				'mini_cart_primary'                => [
					'id'    => 'mini_cart_primary',
					'label' => esc_html__( 'Drawer Primary Color', 'shopbuilder-pro' ),
					'type'  => 'color',
					'tab'   => 'minicart_area',
				],

				'mini_cart_secondary'              => [
					'id'          => 'mini_cart_secondary',
					'label'       => esc_html__( 'Drawer Secondary Color', 'shopbuilder-pro' ),
					'type'        => 'color',
					'default_val' => '#505B74',
					'tab'         => 'minicart_area',
				],

			]
		);
	}
}
