<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\FlashSaleCountdown;

use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;
use RadiusTheme\SBPRO\Modules\PreOrder\PreOrderFns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class Countdown {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * @var array
	 */
	private $cache = [];

	/**
	 * Hello
	 */
	private function __construct() {
		if ( wp_doing_ajax() || ! is_admin() ) {
			// Price Html.
			add_filter( 'woocommerce_get_price_html', [ $this, 'custom_price_html_display' ], 10, 2 );
			// Generating dynamically the product "sale price".
			add_filter( 'woocommerce_product_is_on_sale', [ $this, 'campaign_set_product_as_on_sale' ], 50, 2 );
			// add_action( 'woocommerce_before_calculate_totals', [ $this, 'custom_discounted_cart_item_price' ], 20, 1 );
			// Hello.
			add_filter( 'woocommerce_cart_contents_changed', [ $this, 'adjust_cart_subtotal' ], 25, 1 );
			// Product price calculate for cart.
			// add_filter( 'woocommerce_product_get_regular_price', [ $this, 'customize_regular_price' ], 15, 2 );
			// add_filter( 'woocommerce_product_get_sale_price', [ $this, 'product_get_sale_price' ], 15, 2 );
			// add_filter( 'woocommerce_product_get_price', [ $this, 'product_get_price' ], 15, 2 );
			// Generating dynamically the product "sale price".
			// Generating dynamically the product "sale price" for variable products.
			// Example Resource : https://stackoverflow.com/questions/49943319/change-product-variation-prices-via-a-hook-in-woocommerce-3-3 .
			// add_filter( 'woocommerce_product_variation_get_sale_price', [ $this, 'product_get_sale_price' ], 14, 2 );
			// add_filter( 'woocommerce_product_variation_get_price', [ $this, 'product_get_price' ], 15, 2 );
			// Hook to modify variation product prices.
			// add_filter( 'woocommerce_variation_prices', [ $this, 'woocommerce_variation_prices_array' ], 5, 2 );
			 CountdownFrontEnd::instance();
		}
	}

	/**
	 * Determines if a product should be marked as on sale based on campaign settings.
	 *
	 * Checks if a product is associated with an active campaign and applies the campaign discount logic.
	 * Utilizes caching for performance optimization.
	 *
	 * @param bool        $on_sale Whether the product is already marked as on sale.
	 * @param \WC_Product $product The WooCommerce product object.
	 *
	 * @return bool True if the product is on sale due to a campaign or previous conditions; otherwise, the original $on_sale value.
	 */
	public function campaign_set_product_as_on_sale( $on_sale, $product ) {
		if ( $on_sale || ! $product instanceof \WC_Product ) {
			return $on_sale;
		}
		$product_id = $product->get_id();
		$cache_key  = 'campaign_cache_on_sale_' . $product_id;
		if ( isset( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}
		$campaign = CountdownFns::get_campaign_for_current_product( $product );
		if ( empty( $campaign ) ) {
			return $on_sale;
		}
		$discount_price = $campaign['discount_amount'] ?? 0;
		if ( ! empty( $discount_price ) ) {
			$this->cache[ $cache_key ] = true;
			return $this->cache[ $cache_key ];
		}
		$this->cache[ $cache_key ] = $on_sale;
		return $this->cache[ $cache_key ];
	}

	/**
	 * Price Html Customize.
	 *
	 * @param string $price_html string.
	 * @param object $product product object.
	 * @return mixed|string
	 */
	public function custom_price_html_display( $price_html, $product ) {
		if ( ! $product instanceof \WC_Product ) {
			return $price_html;
		}
		$is_on_pre_order = 'variation' === $product->get_type()
			? PreOrderFns::variation_id_is_on_pre_order( $product->get_id() )
			: PreOrderFns::is_on_pre_order( $product );

		if ( $is_on_pre_order ) {
			return $price_html;
		}

		$campaign = CountdownFns::get_campaign_for_current_product( $product );

		if ( empty( $campaign ) || empty( $campaign['discount_amount'] ) ) {
			return $price_html;
		}

		if ( $product->is_type( 'variable' ) ) {
			$min_regular = $product->get_variation_regular_price( 'min', true );
			$max_regular = $product->get_variation_regular_price( 'max', true );
			$min_sale    = $min_regular - CountdownFns::campaign_discount_price( $min_regular, $campaign );
			$max_sale    = $max_regular - CountdownFns::campaign_discount_price( $max_regular, $campaign );
			// Return range price display with del/ins.
			return wc_price( $min_sale ) . ' – ' . wc_price( $max_sale );
		}

		// Simple product.
		$regular_price = floatval( $product->get_regular_price() );
		$sale_price    = $regular_price - CountdownFns::campaign_discount_price( $regular_price, $campaign );
		// return '<del>' . wc_price( $regular_price ) . '</del> <ins>' . wc_price( $sale_price ) . '</ins>';

		return wc_format_sale_price( $regular_price, $sale_price );
	}

	/**
	 * @param $cart_contents
	 * @return array
	 */
	public function adjust_cart_subtotal( $cart_contents ) {
		foreach ( $cart_contents as $cart_item ) {
			$campaign = CountdownFns::get_campaign_for_current_product( $cart_item['data'] );
			if ( empty( $campaign ) || empty( $campaign['discount_amount'] ) ) {
				continue;
			}
			$regular_price = floatval( $cart_item['data']->get_regular_price() );
			$sale_price    = $regular_price - CountdownFns::campaign_discount_price( $regular_price, $campaign );
			$cart_item['data']->set_price( $sale_price );
		}
		return $cart_contents;
	}
	/**
	 * Calculates the sale price for a variation based on campaign discount settings.
	 *
	 * Retrieves the discount information for the product and applies it to the variation's regular price
	 * if a valid campaign is active. Returns the adjusted sale price or the original sale price if no campaign applies.
	 *
	 * @param float|mixed $sale_price   The original sale price of the variation.
	 * @param int         $variation_id The ID of the product variation.
	 * @param \WC_Product $product      The WooCommerce product object.
	 *
	 * @return float The calculated sale price for the variation.
	 */
	private function product_get_sale_price_for_variation( $sale_price, $variation_id, $product ) {
		$campaign = CountdownFns::get_campaign_for_current_product( $product );

		if ( empty( $campaign ) ) {
			return $sale_price;
		}
		$discount_amount = $campaign['discount_amount'] ?? 0;
		if ( empty( $discount_amount ) ) {
			return $sale_price;
		}

		$regular_price  = floatval( get_post_meta( $variation_id, '_regular_price', true ) );
		$discount_price = floatval( CountdownFns::campaign_discount_price( $regular_price, $campaign ) );

		return $regular_price - $discount_price;
	}


	/**
	 * @param array  $prices_array prices array.
	 * @param object $product product object.
	 * @return array
	 */
	public function woocommerce_variation_prices_array( $prices_array, $product ) {
		if ( is_array( $prices_array['price'] ) ) {
			foreach ( $prices_array['price'] as $key => $value ) {
				// $prices_array['price'][ $key ] = $this->product_get_sale_price_for_variation( $value, $key, $product );
			}
		}

		return $prices_array;
	}

	/**
	 * Filters the sale price of a product, with compatibility for product addons.
	 *
	 * @param float       $sale_price The original sale price of the product.
	 * @param \WC_Product $product    The WooCommerce product object.
	 *
	 * @return float Filtered sale price. Returns the original sale price if conditions are not met.
	 */
	public function product_get_price( $sale_price, $product ) {
		if ( ! $product instanceof \WC_Product ) {
			return $sale_price;
		}
		$type = $product->get_type();
		/**
		 * Product addons compatibility.
		 */
		if ( ( FnsPro::is_module_active( 'product_add_ons' ) )
			&& ( 'variation' === $type || 'simple' === $type ) && AddOnsFns::product_has_addons( $product, 'variation' === $type ) ) {
			return $sale_price;
		}
		// return $this->product_get_sale_price( $sale_price, $product );
	}
	/**
	 * Filters the sale price of a product, with compatibility for product addons.
	 *
	 * @param float       $sale_price The original sale price of the product.
	 * @param \WC_Product $product    The WooCommerce product object.
	 *
	 * @return float Filtered sale price. Returns the original sale price if conditions are not met.
	 */
	public function product_get_sale_price( $sale_price, $product ) {
		return 10;
		if ( ! $product instanceof \WC_Product || ! apply_filters( 'rtsb/calculate/countdown/campaign', true, $product ) ) {
			return $sale_price;
		}

		$product_id = $product->get_id();
		$cache_key  = 'campaign_cache_' . $product_id;

		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}

		$campaign = CountdownFns::get_campaign_for_current_product( $product );

		if ( ! empty( $campaign ) ) {
			$discount_amount = $campaign['discount_amount'] ?? 0;

			if ( ! empty( $discount_amount ) ) {
				$regular_price  = floatval( get_post_meta( $product_id, '_regular_price', true ) );
				$discount_price = floatval( CountdownFns::campaign_discount_price( $regular_price, $campaign ) );
				$sale_price     = $regular_price - $discount_price;
			}
		}
		$this->cache[ $cache_key ] = $sale_price;
		return $this->cache[ $cache_key ];
	}
}
