<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\CurrencySwitcher;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class SwitcherInit {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * @var array
	 */
	private static $cache = [];

	/**
	 * @var array|mixed
	 */
	private array $options;

	/**
	 * Notifications hooks.
	 */
	private function __construct() {
		// If the cached result doesn't exist, fetch it from the database.
		global $currency_switcher_options; // Define global variable.
		$this->options             = Fns::get_options( 'modules', 'currency_switcher' ); // Assign options to the global variable.
		$currency_switcher_options = $this->options;
		$this->general();
		if ( wp_doing_ajax() || ! is_admin() ) {
			$this->frontend_init();
		}
	}
	/**
	 * @return void
	 */
	public function frontend_init() {
		CurrencyFrontend::instance();
		FrontendPrice::instance();
	}
	/**
	 * @return void
	 */
	public function general() {
		CurrencySwitcher::instance();
	}
}
