<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\CurrencySwitcher;

use RadiusTheme\SB\Helpers\Cache;
use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class CurrencyBase {

	/**
	 * @var array
	 */
	public $cache = [];
	/**
	 * @var
	 */
	private $available_currency;
	/**
	 * @var
	 */
	private $current_currency;
	/**
	 * @var
	 */
	private $default_currency;
	/**
	 * @var
	 */
	private $current_currency_settings;
	/**
	 * @var
	 */
	private $current_rate;
	/**
	 * @var
	 */
	private $available_gateway = [];

	/**
	 * Notifications hooks.
	 */
	public function __construct() {
		/**
		 * Max-Mind-Licence-Key: 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
		 */
		$this->available_currency        = $this->set_active_currency_list();
		$this->current_currency          = $this->set_current_currency();
		$this->default_currency          = CsFns::get_default_currency();
		$this->current_currency_settings = $this->set_currency_settings();
		$this->current_rate              = $this->set_current_rate();
		$this->available_gateway         = $this->set_available_gateway();
	}

	/**
	 * @return array
	 */
	protected function set_currency_settings() {
		// This will functional Latter.
		$cache_key = 'set_current_currency_settings';
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}
		$list                      = $this->get_available_currency();
		$code                      = $this->get_current_currency();
		$this->cache[ $cache_key ] = $list[ $code ] ?? [];
		return $this->cache[ $cache_key ];
	}

	/**
	 * @return bool
	 */
	public function is_available_currency( $code = '' ) {
		if ( empty( $code ) ) {
			$code = $this->get_current_currency();
		}
		return in_array( $code, array_keys( $this->get_available_currency() ), true );
	}

	/**
	 *
	 * @return array
	 */
	protected function set_active_currency_list() {
		$cache_key = 'set_active_currency_list';
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}
		$options = $this->all_currency_list();
		if ( ! is_array( $options ) ) {
			return [];
		}
		$currency_list = [];
		foreach ( $options as $currency ) {
			if ( 'on' !== ( $currency['activate_currency'] ?? null ) ) {
				continue;
			}
			$allow = [];
			if ( isset( $currency['allow_payment_methods'] ) ) {
				$allow = array_map(
					function ( $method ) {
						return $method['value'];
					},
					$currency['allow_payment_methods']
				);
			}
			$currency['allow_payment_methods']   = $allow;
			$currency_list[ $currency['title'] ] = $currency;
		}

		$default_currency = reset( $currency_list );
		// New array to be added as the first item.
		$new_currency              = [
			CsFns::get_default_currency() => wp_parse_args(
				[
					'activate_currency'     => 'on',
					'title'                 => CsFns::get_default_currency(),
					'currency_rate'         => 1,
					'currency_exchange_fee' => 0,
					'custom_symbol'         => null,
					'currency_position'     => get_option( 'woocommerce_currency_pos' ),
					'thousand_separator'    => get_option( 'woocommerce_price_thousand_sep' ),
					'decimal_separator'     => get_option( 'woocommerce_price_decimal_sep' ),
					'number_of_decimals'    => wc_get_price_decimals(),
					'allow_payment_methods' => array_keys( CsFns::payment_gateways() ),
				],
				$default_currency
			),
		];
		$this->cache[ $cache_key ] = array_merge( $new_currency, $currency_list );

		return $this->cache[ $cache_key ];
	}

	/**
	 *
	 * @return array
	 */
	protected function all_currency_list() {
		$cache_key = 'all_currency_list';
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}
		$options       = $this->get_currency_list();
		$currency_list = [];
		if ( ! is_array( $options ) ) {
			return [];
		}
		foreach ( $options as $currency ) {
			if ( empty( $currency['title'] ) ) {
				continue;
			}
			$currency_list[ $currency['title'] ] = $currency;
		}
		$this->cache[ $cache_key ] = $currency_list;
		return $this->cache[ $cache_key ];
	}


	/**
	 * @return string
	 */
	protected function set_current_currency() {
		// This will functional Latter.
		$cache_key = 'set_current_currency';
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}
		$this->cache[ $cache_key ] = Fns::getSession( 'rtsb_currency' ) ?? CsFns::get_default_currency();
		return $this->cache[ $cache_key ];
	}


	/**
	 * Get product min/max price.
	 *
	 * @return array|false
	 */
	private function get_currency_list() {
		// Check if the cached result exists.
		$cache_key     = 'get_currency_list';
		$cached_result = wp_cache_get( $cache_key, 'shopbuilder' );

		if ( false !== $cached_result ) {
			// Return the cached result.
			return $cached_result;
		}
		global $currency_switcher_options;
		$campaign_list = json_decode( $currency_switcher_options['currency_options'] ?? '', true );

		// Store the result in the cache.
		wp_cache_set( $cache_key, $campaign_list, 'shopbuilder', 3600 ); // Cache for 1 hour.
		Cache::set_data_cache_key( $cache_key );
		return $campaign_list;
	}


	/**
	 * @return array
	 */
	protected function set_available_gateway() {
		$current_currency_settings = $this->get_currency_settings();
		$gateway                   = ! empty( $current_currency_settings['allow_payment_methods'] ) ? $current_currency_settings['allow_payment_methods'] : [];
		return is_array( $gateway ) ? array_map( 'sanitize_text_field', $gateway ) : [];
	}
	/**
	 * @return float|int
	 */
	protected function set_current_rate() {
		$current_currency_settings = $this->get_currency_settings();
		$rate                      = ! empty( $current_currency_settings['currency_rate'] ) ? floatval( $current_currency_settings['currency_rate'] ) : 1;
		return $rate + $this->get_exchange_fee();
	}
	/**
	 * @return float|int
	 */
	protected function get_exchange_fee() {
		$current_currency_settings = $this->get_currency_settings();
		return ! empty( $current_currency_settings['currency_exchange_fee'] ) ? floatval( $current_currency_settings['currency_exchange_fee'] ) : 0;
	}

	/**
	 * @param string $currency
	 * @return mixed|string
	 */
	protected function get_currency_symbol( $currency ) {
		$cache_key = 'get_currency_symbol_' . $currency;
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}
		$active = self::get_currency_settings( $currency );
		if ( ! empty( $active['custom_symbol'] ) ) {
			$this->cache[ $cache_key ] = $active['custom_symbol'];
			return $this->cache[ $cache_key ];
		}
		$symbols                   = get_woocommerce_currency_symbols();
		$this->cache[ $cache_key ] = $symbols[ $currency ] ?? '';
		return $this->cache[ $cache_key ];
	}

	/**
	 * Get Geo Currency.
	 *
	 * @return string
	 */
	public function get_geo_currency() {
		// Try to get the cached currency value from the transient.
        // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$currency_transient_key = 'rtsb_geo_currency_' . md5( sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ?? '' ) ) );
		// TODO:: Need To add The transient, After Compleate development.
		$currency = false; // get_transient( $currency_transient_key );
		// If the transient does not exist.
		if ( false === $currency ) {
			// TODO:: Need to make it compatible after completing development.
			$user_location = [
				'country'  => '',
				'state'    => 'CA',
				'city'     => 'San Francisco',
				'postcode' => '94103',
			];
			if ( class_exists( 'WC_Geolocation' ) && ! in_array( ( $_SERVER['REMOTE_ADDR'] ?? '' ), [ '::1', '127.0.0.1' ], true ) ) {
				$user_location = \WC_Geolocation::geolocate_ip();
			}
			$currency = CsFns::get_country_or_currency( ( $user_location['country'] ?? null ), 'currency' ) ?: $this->get_default_currency();
			// Set the transient with a 1-hour expiration.
			set_transient( $currency_transient_key, $currency, HOUR_IN_SECONDS );
		}
		return $currency;
	}

	/**
	 * @return array
	 */
	public function get_available_currency() {
		return $this->available_currency;
	}

	/**
	 * @return array
	 */
	public function get_currency_settings() {
		return $this->current_currency_settings;
	}

	/**
	 * @return string
	 */
	public function get_default_currency() {
		return $this->default_currency;
	}

	/**
	 * @return string
	 */
	public function get_current_currency() {
		return $this->current_currency;
	}

	/**
	 * @return float|int
	 */
	public function get_current_rate() {
		return $this->current_rate;
	}
	/**
	 * @return float|int
	 */
	public function get_available_gateway() {
		return $this->available_gateway;
	}

	/**
	 * @return float|int
	 */
	public function get_default_currency_settings() {
		return ! empty( $this->available_currency[ $this->default_currency ] ) ? $this->available_currency[ $this->default_currency ] : [];
	}
}
