<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\CurrencySwitcher;

use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class CsFns {
	/**
	 * @var array
	 */
	private static $cache = [];

	/**
	 * @return array
	 */
	public static function settings_field() {
		$settings = self::general() + self::currency_options() + self::switcher_styles();
		return apply_filters( 'rtsb/module/currency_switcher_settings/fields', $settings );
	}

	/**
	 * @return array
	 */
	private static function general() {
		return [
			'show_sticky_currency_widget'  => [
				'id'    => 'show_sticky_currency_widget',
				'value' => 'on',
				'type'  => 'switch',
				'label' => esc_html__( 'Display Sticky Currency Widget', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Enable this option to display the sticky currency widget on your shop.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'show_currency_shortcode'      => [
				'type'  => 'raw',
				'label' => ' ',
				'html'  => sprintf(
				/* translators: 1: The shortcode.*/
					esc_html__( 'Use the %1$s shortcode to add the Currency Switcher button to your shop.', 'shopbuilder-pro' ),
					'<code>[currency_switcher]</code>'
				),
				'tab'   => 'general',
			],
			'currency_switcher_position'   => [
				'id'         => 'currency_switcher_position',
				'type'       => 'select',
				'label'      => esc_html__( 'Currency Switcher Position', 'shopbuilder-pro' ),
				'value'      => 'left-bottom',
				'options'    => [
					'left-top'     => esc_html__( 'Left Top', 'shopbuilder-pro' ),
					'left-middle'  => esc_html__( 'Left Middle', 'shopbuilder-pro' ),
					'left-bottom'  => esc_html__( 'Left Bottom', 'shopbuilder-pro' ),
					'right-top'    => esc_html__( 'Right Top', 'shopbuilder-pro' ),
					'right-middle' => esc_html__( 'Right Middle', 'shopbuilder-pro' ),
					'right-bottom' => esc_html__( 'Right Bottom', 'shopbuilder-pro' ),
					// 'bottom-center' => esc_html__( 'Bottom Center', 'shopbuilder-pro' ),
				],
				'tab'        => 'general',
				'help'       => esc_html__( 'Display the sticky currency widget in your shop at your preferred location.', 'shopbuilder-pro' ),
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.show_sticky_currency_widget',
							'value'    => 'on',
							'operator' => '==',
						],
					],
				],
			],

			'enable_currency_flag'         => [
				'id'    => 'enable_currency_flag',
				'value' => 'on',
				'type'  => 'switch',
				'label' => esc_html__( 'Show Currency Flag', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'enable_currency_text'         => [
				'id'    => 'enable_currency_text',
				'value' => 'on',
				'type'  => 'switch',
				'label' => esc_html__( 'Show Currency Text', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],

			'exchange_rates'               => [
				'id'      => 'exchange_rates',
				'type'    => 'select',
				'label'   => esc_html__( 'How to Set Exchange Rates', 'shopbuilder-pro' ),
				'value'   => 'manually',
				'options' => [
					'manually'      => __( '<b>Manually</b> - Enter the rates manually in the currency field', 'shopbuilder-pro' ),
					'automatically' => __( '<b>Automatically</b> - Retrieve rates from a currency provider', 'shopbuilder-pro' ),
				],
				'tab'     => 'general',
				'help'    => esc_html__( 'Choose to set exchange rates automatically or enter the values manually.', 'shopbuilder-pro' ),
			],

			'exchange_rate_resources'      => [
				'id'         => 'exchange_rate_resources',
				'type'       => 'select',
				'label'      => esc_html__( 'Exchange Rate Providers', 'shopbuilder-pro' ),
				'value'      => 'cuex',
				'options'    => [
					'yahoo-finance' => esc_html__( 'Yahoo Finance', 'shopbuilder-pro' ),
					'cuex'          => esc_html__( 'CUEX', 'shopbuilder-pro' ),
					'xe'            => esc_html__( 'XE', 'shopbuilder-pro' ),
				],
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.exchange_rates',
							'value'    => 'automatically',
							'operator' => '==',
						],
					],
				],
				'help'       => __( 'Select your preferred providers for exchange rates.<br /><b>Note:</b> Yahoo Finance does not provide currency rates for some currencies.', 'shopbuilder-pro' ),
				'tab'        => 'general',
			],
			'cuex_api_key'                 => [
				'id'         => 'cuex_api_key',
				'type'       => 'text',
				'label'      => esc_html__( 'CUEX Authorization Key', 'shopbuilder-pro' ),
				'tab'        => 'general',
				'help'       => esc_html__( 'Enter your Cuex authorization key to enable access to the currency exchange rates provided by CUEX (Optional).', 'shopbuilder-pro' ),
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.exchange_rates',
							'value'    => 'automatically',
							'operator' => '==',
						],
						[
							'item'     => 'modules.currency_switcher.exchange_rate_resources',
							'value'    => 'cuex',
							'operator' => '==',
						],
					],
				],
			],

			/*
			'transferwise_api_key'         => [
				'id'         => 'transferwise_api_key',
				'type'       => 'text',
				'label'      => esc_html__( 'TransferWise Authorization Key', 'shopbuilder-pro' ),
				'tab'        => 'general',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.exchange_rates',
							'value'    => 'automatically',
							'operator' => '==',
						],
						[
							'item'     => 'modules.currency_switcher.exchange_rate_resources',
							'value'    => 'transferWise',
							'operator' => '==',
						],
					],
				],
			],

			*/

			'update_exchange_rates'        => [
				'id'         => 'update_exchange_rates',
				'type'       => 'number',
				'label'      => esc_html__( 'Automatic Currency Update Interval (Hours)', 'shopbuilder-pro' ),
				'help'       => esc_html__( 'Specify the interval, in hours, for updating the exchange rates automatically. Example: 24.', 'shopbuilder-pro' ),
				'tab'        => 'general',
				'min'        => 1,
				'step'       => 1,
				'integer'    => true,
				'value'      => 24,
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.exchange_rates',
							'value'    => 'automatically',
							'operator' => '==',
						],
					],
				],
			],
			'location_settings'            => [
				'id'    => 'location_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Location Settings', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			// 'auto_detect'                => [
			// 'id'      => 'auto_detect',
			// 'type'    => 'select',
			// 'label'   => esc_html__( 'Auto Detect.', 'shopbuilder-pro' ),
			// 'options' => [
			// 'no'                => esc_html__( 'No', 'shopbuilder-pro' ),
			// 'auto_select'       => esc_html__( 'Auto select currency', 'shopbuilder-pro' ),
			// 'approximate_price' => esc_html__( 'Approximate Price', 'shopbuilder-pro' ),
			// 'polylang'          => esc_html__( 'Language Polylang', 'shopbuilder-pro' ),
			// 'translatePress'    => esc_html__( 'TranslatePress Multilingual', 'shopbuilder-pro' ),
			// 'wpml'              => esc_html__( 'WPML Multilingual', 'shopbuilder-pro' ),
			// ],
			// 'tab'     => 'general',
			// ],
			'enable_geolocation'           => [
				'id'    => 'enable_geolocation',
				'value' => '',
				'type'  => 'switch',
				'label' => esc_html__( 'Geolocation', 'shopbuilder-pro' ),
				'help'  => sprintf(
					/* translators: 1: Admin URL. 2: Default currency */
					__( 'To use geolocation for automatically displaying the customer\'s local currency, <a target="_blank" href="%1$s">please add WooCommerce Geolocation API</a> first. <br /><br /><b>Note: </b>if this option is disabled, or if the user\'s local currency is unavailable or geolocation fails, the customer will see the default currency (%2$s).', 'shopbuilder-pro' ),
					admin_url( 'admin.php?page=wc-settings&tab=integration' ),
					self::get_default_currency()
				),
				'tab'   => 'general',
			],
			'checkout_settings'            => [
				'id'    => 'checkout_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Checkout Settings', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],

			'checkout_currency'            => [
				'id'      => 'checkout_currency',
				'type'    => 'select',
				'label'   => esc_html__( 'Checkout Currency Display Options', 'shopbuilder-pro' ),
				'help'    => esc_html__( 'Select how the currency should appear at checkout.', 'shopbuilder-pro' ),
				'value'   => 'customer-selected',
				'options' => [
					'customer-selected' => esc_html__( 'Customer\'s Selected Currency', 'shopbuilder-pro' ),
					'default-currency'  => esc_html__( 'Forced Default Currency Display', 'shopbuilder-pro' ),
					// 'customer-country'  => esc_html__( 'Forced, based on the customer\'s country', 'shopbuilder-pro' ),
				],
				'tab'     => 'general',
			],
			// 'checkout_base_on_customers_country' => [
			// 'id'         => 'checkout_base_on_customers_country',
			// 'type'       => 'select',
			// 'label'      => esc_html__( 'Force currency selection based on: ', 'shopbuilder-pro' ),
			// 'value'      => 'billing',
			// 'options'    => [
			// 'billing'  => esc_html__( 'Customer Billing Address', 'shopbuilder-pro' ),
			// 'shipping' => esc_html__( 'Customer Shipping Address', 'shopbuilder-pro' ),
			//
			// ],
			// 'tab'        => 'general',
			// 'dependency' => [
			// 'rules' => [
			// [
			// 'item'     => 'modules.currency_switcher.checkout_currency',
			// 'value'    => 'customer-country',
			// 'operator' => '==',
			// ],
			// ],
			// ],
			// ],
			// 'customer_currency_geolocation_message' => [
			// 'id'         => 'customer_currency_geolocation_message',
			// 'type'       => 'description',
			// 'text'       => esc_html__( '"Forced to the customer\'s country" It\'s only work if Geolocation enabled.', 'shopbuilder-pro' ),
			// 'tab'        => 'general',
			// 'dependency' => [
			// 'rules' => [
			// [
			// 'item'     => 'modules.currency_switcher.checkout_currency',
			// 'value'    => 'customer-country',
			// 'operator' => '==',
			// ],
			// ],
			// ],
			// ],
			'update_currency_on_cart_page' => [
				'id'         => 'currency_on_cart_page',
				'value'      => 'on',
				'type'       => 'switch',
				'label'      => esc_html__( 'Update Currency on Cart Page', 'shopbuilder-pro' ),
				'help'       => esc_html__( 'Automatically update the currency on the cart page to match the currency selected during checkout.', 'shopbuilder-pro' ),
				'tab'        => 'general',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.checkout_currency',
							'value'    => [ 'customer-selected' ],
							'operator' => '!in',
						],
					],
				],
			],

		];
	}

	/**
	 * @return array
	 */
	private static function page_filter() {
		return [
			/*
			'switcher_btn_include_page' => [
				'id'              => 'switcher_btn_include_page',
				'label'           => esc_html__( 'Include Pages', 'shopbuilder-pro' ),
				'help'            => esc_html__( 'Leave this field blank to display the Currency Switcher on all pages.', 'shopbuilder-pro' ),
				'type'            => 'search_and_multi_select',
				'placeholder'     => esc_html__( 'Choose Pages', 'shopbuilder-pro' ),
				'func_with_param' => [
					Fns::class,
					'get_post_types',
					[
						'post_type' => 'page',
					],
				],
				'options'         => Fns::get_post_types(
					null,
					[
						'post_type' => 'page',
					]
				),
				'tab'             => 'filter',
			],
			'switcher_btn_exclude_page' => [
				'id'              => 'switcher_btn_exclude_page',
				'label'           => esc_html__( 'Exclude Pages', 'shopbuilder-pro' ),
				'help'            => esc_html__( 'Choose pages where you don\'t want the Currency Switcher to appear.', 'shopbuilder-pro' ),
				'type'            => 'search_and_multi_select',
				'placeholder'     => esc_html__( 'Choose Pages', 'shopbuilder-pro' ),
				'func_with_param' => [
					Fns::class,
					'get_post_types',
					[
						'post_type' => 'page',
					],
				],
				'options'         => Fns::get_post_types(
					null,
					[
						'post_type' => 'page',
					]
				),
				'tab'             => 'filter',
			],
			'switcher_btn_include_archive'      => [
				'id'              => 'switcher_btn_include_archive',
				'label'           => esc_html__( 'Include Archive Page', 'shopbuilder-pro' ),
				'help'            => esc_html__( 'Leave this field blank to display the Currency Switcher on all archive pages.', 'shopbuilder-pro' ),
				'type'            => 'search_and_multi_select',
				'placeholder'     => esc_html__( 'Choose Archive Page', 'shopbuilder-pro' ),
				'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'archive' ] ],
				'options'         => Fns::get_post_types( null, [ 'post_type' => 'archive' ] ),
				'tab'             => 'filter',
			],
			'switcher_btn_include_details_page' => [
				'id'              => 'switcher_btn_include_details_page',
				'label'           => esc_html__( 'Include Details Page', 'shopbuilder-pro' ),
				'help'            => esc_html__( 'Leave this field blank to display the Currency Switcher on all details pages.', 'shopbuilder-pro' ),
				'type'            => 'search_and_multi_select',
				'placeholder'     => esc_html__( 'Choose Details Page', 'shopbuilder-pro' ),
				'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'archive' ] ],
				'options'         => Fns::get_post_types( null, [ 'post_type' => 'archive' ] ),
				'tab'             => 'filter',
			],
			*/

		];
	}

	/**
	 * @return array[]
	 */
	private static function switcher_styles() {
		return [
			'switcher_preset'            => [
				'id'      => 'switcher_preset',
				'label'   => esc_html__( 'Switcher Appearance', 'shopbuilder-pro' ),
				'help'    => esc_html__( 'Select the desired appearance for the switcher.', 'shopbuilder-pro' ),
				'type'    => 'image_select',
				'value'   => 'preset1',
				'options' => [
					'preset1' => [
						'label' => esc_html__( 'Preset 1', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/currency-switcher/currency-flag-ltl.svg' ) ),
					],
					'preset2' => [
						'label' => esc_html__( 'Preset 2', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/currency-switcher/currency-ltl.svg' ) ),
					],
				],
				'tab'     => 'styles',
			],
			'currency_text_color'        => [
				'id'    => 'currency_text_color',
				'label' => esc_html__( 'Currency Text Color', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Specify the color for the currency text.', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'currency_active_text_color' => [
				'id'    => 'currency_active_text_color',
				'label' => esc_html__( 'Active Currency Text Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],

			'currency_text_font_size'    => [
				'id'    => 'currency_text_font_size',
				'type'  => 'text',
				'label' => esc_html__( 'Currency Text Font Size', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Example: 14px', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],

			'switcher_bg_color'          => [
				'id'    => 'switcher_bg_color',
				'label' => esc_html__( 'Switcher Background', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],

			'placeholder_section'        => [
				'id'         => 'placeholder_section',
				'type'       => 'title',
				'label'      => esc_html__( 'Label Section', 'shopbuilder-pro' ),
				'tab'        => 'styles',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.switcher_preset',
							'value'    => [ 'preset2' ],
							'operator' => 'in',
						],
					],
				],
			],
			'currency_label_bg_color'    => [
				'id'         => 'currency_label_bg_color',
				'label'      => esc_html__( 'Label Background', 'shopbuilder-pro' ),
				'type'       => 'color',
				'tab'        => 'styles',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.switcher_preset',
							'value'    => [ 'preset2' ],
							'operator' => 'in',
						],
					],
				],
			],
			'currency_label_text_color'  => [
				'id'         => 'currency_label_text_color',
				'label'      => esc_html__( 'Label Text Color', 'shopbuilder-pro' ),
				'type'       => 'color',
				'tab'        => 'styles',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.switcher_preset',
							'value'    => [ 'preset2' ],
							'operator' => 'in',
						],
					],
				],
			],
			'currency_icon_bg_color'     => [
				'id'         => 'currency_icon_bg_color',
				'label'      => __( 'Currency Symbol Background', 'shopbuilder-pro' ),
				'type'       => 'color',
				'tab'        => 'styles',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.switcher_preset',
							'value'    => [ 'preset2' ],
							'operator' => 'in',
						],
					],
				],
			],
			'currency_icon_color'        => [
				'id'         => 'currency_icon_color',
				'label'      => esc_html__( 'Currency Symbol Color', 'shopbuilder-pro' ),
				'type'       => 'color',
				'tab'        => 'styles',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.switcher_preset',
							'value'    => [ 'preset2' ],
							'operator' => 'in',
						],
					],
				],
			],
			'currency_label_font_size'   => [
				'id'         => 'currency_label_font_size',
				'type'       => 'text',
				'label'      => esc_html__( 'Label Font Size', 'shopbuilder-pro' ),
				'help'       => esc_html__( 'Example: 14px', 'shopbuilder-pro' ),
				'tab'        => 'styles',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.switcher_preset',
							'value'    => [ 'preset2' ],
							'operator' => 'in',
						],
					],
				],
			],
			'currency_icon_font_size'    => [
				'id'         => 'currency_icon_font_size',
				'type'       => 'text',
				'label'      => esc_html__( 'Currency Symbol Font Size', 'shopbuilder-pro' ),
				'help'       => esc_html__( 'Example: 14px', 'shopbuilder-pro' ),
				'tab'        => 'styles',
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.currency_switcher.switcher_preset',
							'value'    => [ 'preset2' ],
							'operator' => 'in',
						],
					],
				],
			],

		];
	}
	/**
	 * @return array
	 */
	private static function currency_options() {
		$currency_code_options = get_woocommerce_currencies();
		$currency_code         = [];
		foreach ( $currency_code_options as $code => $name ) {
			$currency_code[ $code ] = $name . ' (' . get_woocommerce_currency_symbol( $code ) . ') — ' . esc_html( $code );
		}

		return [
			'currency_field_intro' => [
				'id'   => 'currency_field_intro',
				'type' => 'description',
				'text' => esc_html__( 'To add new currencies, simply click on the \'Add New\' button below.', 'shopbuilder-pro' ),
				'tab'  => 'currencies',
			],

			// 'update_all_currency'  => [
			// 'id'         => 'update_all_currency',
			// 'type'       => 'update_currency_button',
			// 'label'      => 'Update All Rates',
			// 'text'       => esc_html__( 'Update All Rates', 'shopbuilder-pro' ),
			// 'tab'        => 'currencies',
			// 'dependency' => [
			// 'rules' => [
			// [
			// 'item'     => 'modules.currency_switcher.exchange_rates',
			// 'value'    => 'automatically',
			// 'operator' => '==',
			// ],
			// ],
			// ],
			// ],
			// End Single Product Page.
			'currency_options'     => [
				'id'     => 'currency_options',
				'type'   => 'repeaters',
				'label'  => '',
				'tab'    => 'currencies',
				// 'defaults' => $default_options,
				'repeat' => [
					'activate_currency'     => [
						'id'    => 'activate_currency',
						'type'  => 'switch',
						'value' => 'on',
						'label' => esc_html__( 'Enable this Currency', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Switch on for activate this currency.', 'shopbuilder-pro' ),
					],
					'title'                 => [
						'id'         => 'title',
						'label'      => esc_html__( 'Select Currency', 'shopbuilder-pro' ),
						'help'       => esc_html__( 'Choose your preferred currency from the dropdown list.', 'shopbuilder-pro' ),
						'type'       => 'select',
						'value'      => array_key_first( $currency_code ),
						'options'    => $currency_code,
						'searchable' => true,
					],
					'custom_symbol'         => [
						'id'    => 'custom_symbol',
						'label' => esc_html__( 'Custom Currency Symbol', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Enter your custom currency symbol to display it throughout your shop. Keep blank to show the default symbol. Example: CAD $', 'shopbuilder-pro' ),
						'type'  => 'text',
					],
					'currency_rate'         => [
						'id'         => 'currency_rate',
						'type'       => 'currency_rate',
						'label'      => esc_html__( 'Currency Rate', 'shopbuilder-pro' ),
						'help'       => sprintf(
							/* translators: 1: The Currency Code.*/
							esc_html__( 'Set the exchange rate based on %s, your default currency.', 'shopbuilder-pro' ),
							self::get_default_currency()
						),
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.currency_switcher.currency_options.title',
									'value'    => self::get_default_currency(),
									'operator' => '!=',
								],
							],
						],
					],
					'currency_exchange_fee' => [
						'id'         => 'currency_exchange_fee',
						'type'       => 'number',
						'label'      => esc_html__( 'Exchange Fee', 'shopbuilder-pro' ),
						'help'       => __( 'Apply a fixed exchange fee to the original rate. <br /><br />For example, if the original rate is 10.50 and the exchange fee rate is 0.5, the end rate would be 11.00.', 'shopbuilder-pro' ),
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.currency_switcher.currency_options.title',
									'value'    => self::get_default_currency(),
									'operator' => '!=',
								],
							],
						],
					],
					'currency_position'     => [
						'id'      => 'currency_position',
						'label'   => esc_html__( 'Currency Position', 'shopbuilder-pro' ),
						'help'    => esc_html__( 'Specify where the currency symbol should appear.', 'shopbuilder-pro' ),
						'type'    => 'select',
						'value'   => get_option( 'woocommerce_currency_pos' ) ?? 'left',
						'options' => [
							'left'        => esc_html__( 'Left', 'shopbuilder-pro' ),
							'right'       => esc_html__( 'Right', 'shopbuilder-pro' ),
							'left_space'  => esc_html__( 'Left with space', 'shopbuilder-pro' ),
							'right_space' => esc_html__( 'Right with space', 'shopbuilder-pro' ),
						],

					],
					'thousand_separator'    => [
						'id'    => 'thousand_separator',
						'type'  => 'text',
						'value' => wc_get_price_thousand_separator(),
						'label' => esc_html__( 'Thousand Separator', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Specify the character to use as the thousand separator. Example: ,', 'shopbuilder-pro' ),
					],
					'decimal_separator'     => [
						'id'    => 'decimal_separator',
						'type'  => 'text',
						'value' => wc_get_price_decimal_separator(),
						'label' => esc_html__( 'Decimal Separator', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Specify the character to use as the decimal separator. Example: .', 'shopbuilder-pro' ),
					],
					'number_of_decimals'    => [
						'id'    => 'number_of_decimals',
						'type'  => 'number',
						'min'   => 0,
						'max'   => 5,
						'value' => wc_get_price_decimals(),
						'label' => esc_html__( 'Number of Decimals', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Specify the number of decimal places to display for numerical values. Example: 2', 'shopbuilder-pro' ),
					],

					'allow_payment_methods' => [
						'id'              => 'allow_payment_methods',
						'label'           => esc_html__( 'Select Allowed Payment Methods', 'shopbuilder-pro' ),
						'help'            => esc_html__( 'Specify which payment methods to allow. Leave this field blank to allow all available payment methods.', 'shopbuilder-pro' ),
						'type'            => 'search_and_multi_select',
						'placeholder'     => ! empty( self::search_payment_gateways() ) ? esc_html__( 'Choose allow payment methods', 'shopbuilder-pro' ) : esc_html__( 'No active payment methods found.', 'shopbuilder-pro' ),
						'func_with_param' => [ self::class, 'search_payment_gateways', [] ],
						'options'         => self::search_payment_gateways(),
					],

				],
			],
		];
	}
	/**
	 * @return string
	 */
	public static function get_default_currency() {
		$cache_key = 'get_default_currency';
		if ( ! empty( self::$cache[ $cache_key ] ) ) {
			return self::$cache[ $cache_key ];
		}
		self::$cache[ $cache_key ] = get_option( 'woocommerce_currency', 'USD' );
		return self::$cache[ $cache_key ];
	}

	/**
	 * Get Payment Geteways
	 *
	 * @return array
	 */
	/**
	 * Get Payment Geteways
	 *
	 * @return array
	 */
	public static function search_payment_gateways() {
		$all       = self::payment_gateways();
		$available = [];
		foreach ( $all as $key => $item ) {
			$available[] = [
				'label' => $item,
				'value' => $key,
			];
		}

		return $available;
	}

	/**
	 * Get Payment Geteways
	 *
	 * @return array
	 */
	public static function payment_gateways() {
		$cache_key = 'rtsb_payment_gateways_ebanled';
		if ( ! empty( self::$cache[ $cache_key ] ) ) {
			return self::$cache[ $cache_key ];
		}
		$selected         = [];
		$payment_gateways = WC()->payment_gateways->get_available_payment_gateways();
		foreach ( $payment_gateways as $key => $gateway ) {
			$selected[ $key ] = $gateway->title;
		}
		self::$cache[ $cache_key ] = $selected;
		return self::$cache[ $cache_key ];
	}

	/**
	 * 237 countries.
	 * Two-letter country code (ISO 3166-1 alpha-2) => Three-letter currency code (ISO 4217).
	 * Source https://www.zedangle.com/blog/list-currency-code-country-code-php-array
	 */
	public static function get_country_currency() {
		$currency = [
			'AED' => 'AE',
			'AFN' => 'AF',
			'ALL' => 'AL',
			'AMD' => 'AM',
			'ANG' => 'CW',
			'AOA' => 'AO',
			'ARS' => 'AR',
			'AUD' => 'AU',
			'AWG' => 'AW',
			'AZN' => 'AZ',
			'BAM' => 'BA',
			'BBD' => 'BB',
			'BDT' => 'BD',
			'BGN' => 'BG',
			'BHD' => 'BH',
			'BIF' => 'BI',
			'BMD' => 'BM',
			'BND' => 'BN',
			'BOB' => 'BO',
			'BRL' => 'BR',
			'BSD' => 'BS',
			'BTC' => 'NA',
			'BTN' => 'BT',
			'BWP' => 'BW',
			'BYR' => 'BY',
			'BYN' => 'BY',
			'BZD' => 'BZ',
			'CAD' => 'CA',
			'CDF' => 'CD',
			'CHF' => 'CH',
			'CLP' => 'CL',
			'CNY' => 'CN',
			'COP' => 'CO',
			'CRC' => 'CR',
			'CUC' => 'CU',
			'CUP' => 'CU',
			'CVE' => 'CV',
			'CZK' => 'CZ',
			'DJF' => 'DJ',
			'DKK' => 'DK',
			'DOP' => 'DO',
			'DZD' => 'DZ',
			'EGP' => 'EG',
			'ERN' => 'ER',
			'ETB' => 'ET',
			'EUR' => 'EU',
			'FJD' => 'FJ',
			'FKP' => 'FK',
			'GBP' => 'GB',
			'GEL' => 'GE',
			'GGP' => 'GG',
			'GHS' => 'GH',
			'GIP' => 'GI',
			'GMD' => 'GM',
			'GNF' => 'GN',
			'GTQ' => 'GT',
			'GYD' => 'GY',
			'HKD' => 'HK',
			'HNL' => 'HN',
			'HRK' => 'HR',
			'HTG' => 'HT',
			'HUF' => 'HU',
			'IDR' => 'ID',
			'ILS' => 'IL',
			'IMP' => 'IM',
			'INR' => 'IN',
			'IQD' => 'IQ',
			'IRR' => 'IR',
			'IRT' => 'IR',
			'ISK' => 'IS',
			'JEP' => 'JE',
			'JMD' => 'JM',
			'JOD' => 'JO',
			'JPY' => 'JP',
			'KES' => 'KE',
			'KGS' => 'KG',
			'KHR' => 'KH',
			'KMF' => 'KM',
			'KPW' => 'KP',
			'KRW' => 'KR',
			'KWD' => 'KW',
			'KYD' => 'KY',
			'KZT' => 'KZ',
			'LAK' => 'LA',
			'LBP' => 'LB',
			'LKR' => 'LK',
			'LRD' => 'LR',
			'LSL' => 'LS',
			'LYD' => 'LY',
			'MAD' => 'MA',
			'MDL' => 'MD',
			'MGA' => 'MG',
			'MKD' => 'MK',
			'MMK' => 'MM',
			'MNT' => 'MN',
			'MOP' => 'MO',
			'MRU' => 'MR',
			'MUR' => 'MU',
			'MVR' => 'MV',
			'MWK' => 'MW',
			'MXN' => 'MX',
			'MYR' => 'MY',
			'MZN' => 'MZ',
			'NAD' => 'NA',
			'NGN' => 'NG',
			'NIO' => 'NI',
			'NOK' => 'NO',
			'NPR' => 'NP',
			'NZD' => 'NZ',
			'OMR' => 'OM',
			'PAB' => 'PA',
			'PEN' => 'PE',
			'PGK' => 'PG',
			'PHP' => 'PH',
			'PKR' => 'PK',
			'PLN' => 'PL',
			'PRB' => 'NA',
			'PYG' => 'PY',
			'QAR' => 'QA',
			'RON' => 'RO',
			'RSD' => 'RS',
			'RUB' => 'RU',
			'RWF' => 'RW',
			'SAR' => 'SA',
			'SBD' => 'SB',
			'SCR' => 'SC',
			'SDG' => 'SD',
			'SEK' => 'SE',
			'SGD' => 'SG',
			'SHP' => 'SH',
			'SLL' => 'SL',
			'SOS' => 'SO',
			'SRD' => 'SR',
			'SSP' => 'SS',
			'STN' => 'ST',
			'SYP' => 'SY',
			'SZL' => 'SZ',
			'THB' => 'TH',
			'TJS' => 'TJ',
			'TMT' => 'TM',
			'TND' => 'TN',
			'TOP' => 'TO',
			'TRY' => 'TR',
			'TTD' => 'TT',
			'TWD' => 'TW',
			'TZS' => 'TZ',
			'UAH' => 'UA',
			'UGX' => 'UG',
			'USD' => 'US',
			'UYU' => 'UY',
			'UZS' => 'UZ',
			'VEF' => 'VE',
			'VES' => 'VE',
			'VND' => 'VN',
			'VUV' => 'VU',
			'WST' => 'WS',
			'XAF' => 'XAF',
			'XCD' => 'XCD',
			'XOF' => 'XOF',
			'XPF' => 'XPF',
			'YER' => 'YE',
			'ZAR' => 'ZA',
			'ZMW' => 'ZM',
		];
		return apply_filters( 'rtsb/currencies/country', $currency );
	}

	/**
	 * @param string $code code for country/currency.
	 * @param string $get country||currency.
	 * @return int|mixed|string
	 */
	public static function get_country_or_currency( $code, $get = 'country' ) {
		if ( empty( $code ) || empty( $get ) ) {
			return '';
		}
		$code     = strtoupper( $code );
		$the_code = self::get_country_currency();

		if ( 'currency' === $get ) {
			$the_code = array_flip( $the_code );
			return $the_code[ $code ] ?? '';
		}
		return $the_code[ $code ] ?? '';
	}
}
