<?php
/**
 * Customize My Account Module Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\BulkDiscount;

defined( 'ABSPATH' ) || exit();

/**
 * Back-order Module Class.
 */
class ProductsDiscount extends DiscountCalculator {

	/**
	 * Module Class Constructor.
	 */
	public function __construct( $product ) {
		$this->product = $product;
		parent::__construct();
	}
	/**
	 * Get Product Id
	 */
	public function set_product() {
		return $this->product;
	}

	/**
	 * Calculate Discount
	 */
	/**
	 * Get Product Id
	 */
	public function get_price_html() {
		if ( ! $this->has_product_discount() ) {
			return false;
		}
		$note = esc_html__( 'Bulk Discount Available', 'shopbuilder-pro' );
		if ( is_admin() && ! wp_doing_ajax() ) {
			return false;
		}
		$discountRule = $this->get_discount_rules();
		$type         = $discountRule['discount_type'] ?? 'fixed';
		$discounts    = $discountRule['bulk_discount_condition'] ?? [];
		if ( empty( array_keys( $discounts ) ) ) {
			return false;
		}
		// Sort by quantity (key) in descending order.
		$use_currency = ( 'percentage' !== $type );
		$angel        = '<svg xmlns="http://www.w3.org/2000/svg" width="7" height="9" viewBox="0 0 7 9" fill="none"> <path d="M5.6915 3.65882C6.30382 4.05246 6.30382 4.94754 5.6915 5.34118L1.54076 8.00951C0.875247 8.43734 1.28916e-07 7.9595 1.63499e-07 7.16833L3.96773e-07 1.83167C4.31355e-07 1.0405 0.875246 0.562658 1.54076 0.990487L5.6915 3.65882Z" fill="currentColor"/></svg>';
		$price_html   = '';
		foreach ( $discounts as $qty => $val ) {
			$value       = $use_currency ? wp_strip_all_tags( wc_price( $val ) ) : $val . '%';
			$price_html .= '<span class="min-qty">' . $angel . sprintf(
				/* translators: %1$s is quantity and %2$s is price value */
				__( 'Buy %1$s+, get %2$s off!', 'shopbuilder-pro' ),
				'<span class="number">' . $qty . '</span>',
				'<span class="number">' . $value . '</span>'
			) . '</span>';
		}
		$price_html = apply_filters( 'rtsb/bulk/discount/notice/text', $price_html, $type, $discounts );
		$info_icon  = '<svg width="16" height="16" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="currentColor"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><circle cx="12" cy="12" data-name="--Circle" r="10"/><path d="M12 12v4M12 8h0"/></g></svg>';
		$info_icon  = apply_filters( 'rtsb/bulk/discount/notice/icon', $info_icon, $type, $discounts );
		// data-trigger="mouseenter".
		$sale_icon  = '<svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none"><path d="M6 1L1 6.4H5.5L5 10L10 4.6H5.5L6 1Z" stroke="currentColor" stroke-width="0.8" stroke-linecap="round" stroke-linejoin="round"/></svg>';
		$price_html = '<span class="rtsb-bulk-discount-note" data-trigger="mouseenter" data-theme="rtsb-bulk-discount"> 
            <span class="rtsb-bulk-discount-notice">' . $note . '</span> 
            <span class="rtsb-bulk-discount-info-icon" >' . $info_icon . '<span class="rtsb-tippy-data"> <span class="rtsb-tippy-content"> <span class="rtsb-bulk-discount-badge">' . esc_html__( 'Sale', 'shopbuilder-pro' ) . $sale_icon . '</span>  ' . $price_html . '</span></span></span></span>';

		return apply_filters( 'rtsb/bulk/discount/notice/html', $price_html, $type, $discounts );
	}
}
