<?php
/**
 * Customize My Account Module Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\BulkDiscount;

defined( 'ABSPATH' ) || exit();

/**
 * Back-order Module Class.
 */
class CartDiscountCalculator extends DiscountCalculator {

	/**
	 * @var
	 */
	private $cart_item;

	/**
	 * Module Class Constructor.
	 */
	public function __construct( $cart_item ) {
		$this->cart_item = $cart_item;
		parent::__construct();
	}
	/**
	 * Get Product Id
	 */
	public function set_product() {
		return $this->cart_item['data'];
	}

	/**
	 * Calculate Discount
	 */
	/**
	 * Get Product Id
	 */
	public function calculate_discount() {
		$calc = [
			'price'         => 0,
			'discountLabel' => '',
			'discount'      => '',
			'type'          => '',
		];
		if ( ! $this->hasDiscount ) {
			return $calc;
		}
		return $this->apply_discount();
	}
	/**
	 * Calculate Discount
	 */
	/**
	 * Get Product Id
	 */
	private function apply_discount() {
		$calc         = [
			'price'         => 0,
			'discountLabel' => '',
			'discount'      => '',
			'type'          => '',
		];
		$discountRule = $this->get_discount_rules();
		if ( empty( $discountRule ) ) {
			return $calc;
		}
		$allowHtml = [
			'br'     => [],
			'em'     => [],
			'strong' => [],
		];
		$discount  = 0;
		$apply_on  = $discountRule['discount_apply_on'] ?? 'regular-price';
		$price     = 'sale-price' === $apply_on && $this->product->get_sale_price() ? $this->product->get_sale_price() : $this->product->get_regular_price();
		$type      = $discountRule['discount_type'] ?? 'fixed';
		$discounts = $discountRule['bulk_discount_condition'] ?? [];
		if ( empty( $discounts ) ) {
			return $calc;
		}
		// Sort by quantity (key) in descending order.
		krsort( $discounts );

		foreach ( $discounts as $qty => $val ) {
			if ( absint( $this->cart_item['quantity'] ) >= $qty ) {
				$discount = $val;
				break;
			}
		}
		if ( empty( $discount ) ) {
			return $calc;
		}
		$discountLabel = $this->product->get_name();
		if ( 'percentage' === $type ) {
			$amount     = $price - ( $price * $discount / 100 );
			$price_html = sprintf(
			/* translators: %s is discount price. */
				__( 'Price: %1$s <br/> Save: %2$s', 'shopbuilder-pro' ),
				wc_price( $price ),
				$discount . '%'
			);
		} elseif ( 'fixed-amount' === $type ) {
			$amount     = $discount;
			$price_html = sprintf(
			/* translators: %s is discount price. */
				__( 'Save on Subtotal: %1$s', 'shopbuilder-pro' ),
				wc_price( $discount )
			);
			$label = sprintf(
			/* translators: %s is discount price. */
				__( 'Subtotal discount: %1$s', 'shopbuilder-pro' ),
				$discountLabel
			);
			$discountLabel = apply_filters( 'rtsb/subtotal/discount/label', $label, $discountLabel );
		} else {
			if ( $discount > $price ) {
				return $calc;
			}
			$amount     = $price - $discount;
			$price_html = sprintf(
			/* translators: %s is discount price. */
				__( 'Price: %1$s <br/> Save: %2$s', 'shopbuilder-pro' ),
				wc_price( $price ),
				wc_price( $discount )
			);
		}
		if ( ( $price * $this->cart_item['quantity'] ) < $amount ) {
			$amount = $price * $this->cart_item['quantity'];
		}

		$price_html            = apply_filters( 'rtsb/discount/price/html', $price_html, $price, $discount, $this->cart_item );
		$calc['price']         = $amount;
		$calc['discountLabel'] = $discountLabel;
		$calc['discount']      = wp_kses( $price_html, $allowHtml );
		$calc['type']          = $type;
		return $calc;
	}
}
