<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\BulkDiscount;

use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class BulkDiscountFns {
	/**
	 * @return array
	 */
	public static function get_options() {
		return Fns::get_options( 'modules', 'bulk_discounts' );
	}

	/**
	 * @param $product Product Id Or Object.
	 * @return bool
	 */
	public static function product_has_bulk_discounts( $product ) {
		if ( is_int( $product ) ) {
			$product = wc_get_product( $product );
		}
		$discount = new ProductsDiscount( $product );
		return $discount->has_product_discount();
	}
	/**
	 * @return array
	 */
	public static function settings_field() {
		$fields = [
			'general_settings'                    => [
				'id'    => 'general_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Settings', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'discount_message_in_product_loop'    => [
				'id'    => 'discount_message_in_product_loop',
				'type'  => 'switch',
				'label' => esc_html__( 'Show Discount Availability Note', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Display discount availability message in shop, archive, related, upsell, and cross-sell sections', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'discount_message_in_product_details' => [
				'id'    => 'discount_message_in_product_details',
				'type'  => 'switch',
				'label' => esc_html__( 'Show Discount Availability Note in Product details page', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Display discount availability message in product details page.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'enable_cart_message'                 => [
				'id'    => 'enable_cart_message',
				'type'  => 'switch',
				'label' => esc_html__( 'Enable Cart Discount Message', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Inform customers about applied discounts directly in the cart.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'cart_message'                        => [
				'id'         => 'cart_message',
				'label'      => esc_html__( 'Cart Message', 'shopbuilder-pro' ),
				'type'       => 'textarea',
				'help'       => esc_html__( 'Add the discount message to appear in the cart when applicable.', 'shopbuilder-pro' ),
				'tab'        => 'general',
				'value'      => esc_html__( 'Bulk Discount Applied!!', 'shopbuilder-pro' ),
				'dependency' => [
					'rules' => [
						[
							'item'     => 'modules.bulk_discounts.enable_cart_message',
							'value'    => 'on',
							'operator' => '==',
						],
					],
				],
			],
			'disable_coupons'                     => [
				'id'    => 'disable_coupons',
				'type'  => 'switch',
				'label' => esc_html__( 'Disable Coupons', 'shopbuilder-pro' ),
				'help'  => __( 'Automatically disable coupons if any product in the cart has a bulk discount.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],

			'rules_field_intro'                   => [
				'id'   => 'rules_field_intro',
				'type' => 'description',
				'text' => esc_html__( 'To add new discount rules, simply click on the \'Add New\' button below.', 'shopbuilder-pro' ),
				'tab'  => 'rules',
			],
			'rules'                               => [
				'id'     => 'rules',
				'type'   => 'repeaters',
				'label'  => '',
				'tab'    => 'rules',
				'repeat' => [
					'title'                        => [
						'id'          => 'title',
						'label'       => esc_html__( 'Discount Title', 'shopbuilder-pro' ),
						'type'        => 'text',
						'placeholder' => esc_html__( 'Discount Title', 'shopbuilder-pro' ),
						'value'       => esc_html__( 'Untitled Rule', 'shopbuilder-pro' ),
						'help'        => esc_html__( 'The title of the discount.', 'shopbuilder-pro' ),
					],
					// This Field Only For Bulk Discount.
					'apply_for'                    => [
						'id'      => 'apply_for',
						'type'    => 'select',
						'value'   => 'product',
						'isPro'   => ! rtsb()->has_pro(),
						'label'   => esc_html__( 'Applicable For', 'shopbuilder-pro' ),
						'options' => [
							'product'     => esc_html__( 'Products', 'shopbuilder-pro' ),
							'product_cat' => esc_html__( 'Product Categories', 'shopbuilder-pro' ),
							'product_tag' => esc_html__( 'Product Tag', 'shopbuilder-pro' ),
						],
						'help'    => esc_html__( 'Specify whether the discount applies to selected products, categories or tags.', 'shopbuilder-pro' ),
					],
					'applicable_products'          => [
						'id'              => 'applicable_products',
						'type'            => 'search_and_multi_select',
						'label'           => esc_html__( 'Applicable Products', 'shopbuilder-pro' ),
						'help'            => esc_html__( 'Choose specific products to include. Leave blank to apply the discount to all products.', 'shopbuilder-pro' ),
						'placeholder'     => esc_html__( 'Search Products', 'shopbuilder-pro' ),
						'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'product' ] ],
						'options'         => Fns::get_post_types( null, [ 'post_type' => 'product' ] ),
						'dependency'      => [
							'rules' => [
								[
									'item'     => 'modules.bulk_discounts.rules.apply_for',
									'value'    => 'product',
									'operator' => '==',
								],
							],
						],
					],
					'applicable_categories'        => [
						'id'              => 'applicable_categories',
						'type'            => 'search_and_multi_select',
						'label'           => esc_html__( 'Applicable Categories', 'shopbuilder-pro' ),
						'help'            => esc_html__( 'Choose specific categories to include. Leave blank to apply the discount to all categories.', 'shopbuilder-pro' ),
						'placeholder'     => esc_html__( 'Search Category', 'shopbuilder-pro' ),
						'func_with_param' => [
							Fns::class,
							'products_category_query',
						],
						'options'         => Fns::products_category_query(),
						'dependency'      => [
							'rules' => [
								[
									'item'     => 'modules.bulk_discounts.rules.apply_for',
									'value'    => 'product_cat',
									'operator' => '==',
								],
							],
						],
					],

					'applicable_tags'              => [
						'id'              => 'applicable_tags',
						'type'            => 'search_and_multi_select',
						'label'           => esc_html__( 'Applicable Tags', 'shopbuilder-pro' ),
						'help'            => esc_html__( 'Choose specific tags to include. Leave blank to apply the discount to all tags.', 'shopbuilder-pro' ),
						'placeholder'     => esc_html__( 'Search Tags', 'shopbuilder-pro' ),
						'func_with_param' => [
							Fns::class,
							'products_tags_query',
						],
						'options'         => Fns::products_tags_query(),
						'dependency'      => [
							'rules' => [
								[
									'item'     => 'modules.bulk_discounts.rules.apply_for',
									'value'    => 'product_tag',
									'operator' => '==',
								],
							],
						],
					],
					// This Field Only For Bulk Discount.
					'discount_type'                => [
						'id'      => 'discount_type',
						'type'    => 'select',
						'value'   => 'percentage',
						'label'   => esc_html__( 'Discount Type', 'shopbuilder-pro' ),
						'help'    => esc_html__( 'Select the type of discount.', 'shopbuilder-pro' ),
						'options' => [
							'percentage'   => esc_html__( 'Percentage (%)', 'shopbuilder-pro' ),
							'fixed'        => esc_html__( 'Fixed Discount - Per Item', 'shopbuilder-pro' ),
							'fixed-amount' => esc_html__( 'Fixed Amount Discount on Cart', 'shopbuilder-pro' ),
						],
					],
					'discount_apply_on'            => [
						'id'      => 'discount_apply_on',
						'type'    => 'select',
						'value'   => 'regular-price',
						'label'   => esc_html__( 'Discount Applies On', 'shopbuilder-pro' ),
						'help'    => esc_html__( 'Define whether the discount applies to the regular price or sale price.', 'shopbuilder-pro' ),
						'options' => [
							'regular-price' => esc_html__( 'Regular Price', 'shopbuilder-pro' ),
							'sale-price'    => esc_html__( 'Sale Price ( If Available )', 'shopbuilder-pro' ),
						],
					],
					'bulk_discount_condition'      => [
						'id'          => 'bulk_discount_condition',
						'label'       => __( 'Bulk Discount Condition', 'shopbuilder-pro' ),
						'type'        => 'textarea',
						'placeholder' => esc_html__( 'Example: 10:5|20:10|30:15 (Quantity:Discount%).', 'shopbuilder-pro' ),
						'help'        => esc_html__( 'Set quantity-based discount rules using \'Quantity:Discount\' pairs separated by | (e.g., 10:5 for 5% or $5 off above 10 items, based on the discount type).', 'shopbuilder-pro' ),
						'tab'         => 'general',
					],
					'exclude_product'              => [
						'id'              => 'exclude_product',
						'type'            => 'search_and_multi_select',
						'isPro'           => ! rtsb()->has_pro(),
						'label'           => esc_html__( 'Exclude Products', 'shopbuilder-pro' ),
						'help'            => esc_html__( 'Choose specific products to exclude. Leave blank to exclude none.', 'shopbuilder-pro' ),
						'placeholder'     => esc_html__( 'Search Products', 'shopbuilder-pro' ),
						'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'product' ] ],
						'options'         => Fns::get_post_types( null, [ 'post_type' => 'product' ] ),
						'dependency'      => [
							'rules' => [
								[
									'item'     => 'modules.bulk_discounts.rules.apply_for',
									'value'    => 'product',
									'operator' => '!=',
								],
							],
						],
					],

					'user_roles'                   => [
						'id'       => 'user_roles',
						'label'    => esc_html__( 'Select User Roles', 'shopbuilder-pro' ),
						'help'     => esc_html__( 'Choose user roles eligible for the discount. Leave blank to apply to all users.', 'shopbuilder-pro' ),
						'type'     => 'select',
						'isPro'    => ! rtsb()->has_pro(),
						'value'    => [],
						'options'  => Fns::get_all_user_roles(),
						'multiple' => true,
					],
					'enable_date_range'            => [
						'id'    => 'enable_date_range',
						'type'  => 'switch',
						'label' => esc_html__( 'Date Range', 'shopbuilder-pro' ),
						'help'  => esc_html__( 'Enable date range for discount.', 'shopbuilder-pro' ),
					],
					'discount_start_date_and_time' => [
						'id'         => 'discount_start_date_and_time',
						'type'       => 'datetime',
						'format'     => 'YYYY-MM-DD HH:mm',
						'showtime'   => true,
						'label'      => esc_html__( 'Discount Start Date', 'shopbuilder-pro' ),
						'help'       => esc_html__( 'Select the start date and time for the discount.', 'shopbuilder-pro' ),
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.bulk_discounts.rules.enable_date_range',
									'value'    => 'on',
									'operator' => '==',
								],
							],
						],
					],
					'discount_end_date_and_time'   => [
						'id'         => 'discount_end_date_and_time',
						'type'       => 'datetime',
						'format'     => 'YYYY-MM-DD HH:mm',
						'showtime'   => true,
						'label'      => esc_html__( 'Discount End Date', 'shopbuilder-pro' ),
						'help'       => esc_html__( 'Select the end date and time for the discount.', 'shopbuilder-pro' ),
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.bulk_discounts.rules.enable_date_range',
									'value'    => 'on',
									'operator' => '==',
								],
							],
						],
					],
				],
			],
			'badge_text_color'                    => [
				'id'    => 'badge_text_color',
				'label' => esc_html__( 'Tooltip Badge Text Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'badge_bg_color'                      => [
				'id'    => 'badge_bg_color',
				'label' => esc_html__( 'Tooltip Badge Background', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_bg_color'                     => [
				'id'    => 'notice_bg_color',
				'label' => esc_html__( 'Tooltip Background', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_border_color'                 => [
				'id'    => 'notice_border_color',
				'label' => esc_html__( 'Tooltip Border Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_text_color'                   => [
				'id'    => 'notice_text_color',
				'label' => esc_html__( 'Tooltip Text Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_list_arrow_color'             => [
				'id'    => 'notice_list_arrow_color',
				'label' => esc_html__( 'Tooltip List Arrow Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_number_color'                 => [
				'id'    => 'notice_number_color',
				'label' => esc_html__( 'Tooltip Number Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_tooltip_arrow_color'          => [
				'id'    => 'notice_tooltip_arrow_color',
				'label' => esc_html__( 'Tooltip Arrow Color (Down Arrow)', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'style_settings_product_showcase'     => [
				'id'    => 'style_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Product Showcase', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'showcase_note_font_size'             => [
				'id'    => 'showcase_note_font_size',
				'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
				'type'  => 'slider',
				'min'   => 10,
				'max'   => 50,
				'unit'  => 'px',
				'value' => 15,
				'tab'   => 'styles',
			],
			'showcase_note_font_color'            => [
				'id'    => 'showcase_note_font_color',
				'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'showcase_note_margin'                => [
				'id'    => 'showcase_note_margin',
				'type'  => 'text',
				'size'  => 'small',
				'min'   => 0,
				'max'   => 999,
				'label' => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Margin. Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],

			'style_settings_product_details'      => [
				'id'    => 'style_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Product Details', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'details_page_note_font_size'         => [
				'id'    => 'details_page_note_font_size',
				'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
				'type'  => 'slider',
				'min'   => 10,
				'max'   => 50,
				'unit'  => 'px',
				'value' => 15,
				'tab'   => 'styles',
			],
			'details_page_note_font_color'        => [
				'id'    => 'details_page_note_font_color',
				'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'details_page_note_margin'            => [
				'id'    => 'showcase_note_margin',
				'type'  => 'text',
				'size'  => 'small',
				'min'   => 0,
				'max'   => 999,
				'label' => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Margin. Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
		];
		return $fields;
	}
}
