<?php
/**
 * Customize My Account Module Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\BulkDiscount;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Back-order Module Class.
 */
class BulkDiscount {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Asset Handle
	 *
	 * @var string
	 */
	private $handle = 'rtsb-bulk-discount';

	/**
	 * Module Class Constructor.
	 */
	private function __construct() {
		BulkDiscountApply::instance();
		if ( is_admin() ) {
			BulkDiscountAdmin::instance();
		}

		/**
		 * Public scripts.
		 */
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_public_scripts' ], 99 );
	}

	/**
	 * @return void
	 */
	public function enqueue_public_scripts() {
		wp_enqueue_script( 'rtsb-tippy' );

		// Enqueue assets.
		$this->handle = Fns::enqueue_module_assets(
			$this->handle,
			'bulk-discount-bogo',
			[
				'context' => rtsbpro(),
				'version' => RTSBPRO_VERSION,
			]
		);

		$options     = BulkDiscountFns::get_options();
		$dynamic_css = '';

		if ( ! empty( $options['badge_bg_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount] .rtsb-bulk-discount-badge{';
			$dynamic_css .= 'background-color:' . $options['badge_bg_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['badge_text_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount] .rtsb-bulk-discount-badge{';
			$dynamic_css .= 'color:' . $options['badge_text_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['notice_bg_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount]{';
			$dynamic_css .= 'background-color:' . $options['notice_bg_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['notice_border_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount]{';
			$dynamic_css .= 'border-color:' . $options['notice_border_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['notice_text_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount] :is(.min-qty, .min-discount, .max-discount){';
			$dynamic_css .= 'color:' . $options['notice_text_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['notice_list_arrow_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount] :is(.min-qty, .min-discount, .max-discount) svg{';
			$dynamic_css .= 'color:' . $options['notice_list_arrow_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['notice_number_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount] .number{';
			$dynamic_css .= 'color:' . $options['notice_number_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['notice_tooltip_arrow_color'] ) ) {
			$dynamic_css .= '.tippy-box[data-theme=rtsb-bulk-discount] .tippy-arrow{';
			$dynamic_css .= 'color:' . $options['notice_tooltip_arrow_color'] . ';';
			$dynamic_css .= '}';
		}

		if ( ! empty( $options['showcase_note_font_size'] ) ) {
			$dynamic_css .= '.rtsb-product-showcase .rtsb-bulk-discount-note{';
			$dynamic_css .= 'font-size:' . $options['showcase_note_font_size'] . 'px;';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['showcase_note_font_color'] ) ) {
			$dynamic_css .= '.rtsb-product-showcase .rtsb-bulk-discount-note{';
			$dynamic_css .= 'color:' . $options['showcase_note_font_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['showcase_note_margin'] ) ) {
			$dynamic_css .= '.rtsb-bulk-availability-notice.rtsb-product-showcase{';
			$dynamic_css .= 'margin:' . $options['showcase_note_margin'] . ';';
			$dynamic_css .= '}';
		}

		if ( ! empty( $options['details_page_note_font_size'] ) ) {
			$dynamic_css .= '.rtsb-product-details .rtsb-bulk-discount-note{';
			$dynamic_css .= 'font-size:' . $options['details_page_note_font_size'] . 'px;';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['details_page_note_font_color'] ) ) {
			$dynamic_css .= '.rtsb-product-details .rtsb-bulk-discount-note{';
			$dynamic_css .= 'color:' . $options['details_page_note_font_color'] . ';';
			$dynamic_css .= '}';
		}
		if ( ! empty( $options['details_page_note_margin'] ) ) {
			$dynamic_css .= '.rtsb-bulk-availability-notice.rtsb-product-details{';
			$dynamic_css .= 'margin:' . $options['details_page_note_margin'] . ';';
			$dynamic_css .= '}';
		}

		if ( ! empty( $dynamic_css ) ) {
			wp_add_inline_style( $this->handle, $dynamic_css );
		}
	}
}
