<?php
/**
 * Product Add-Ons Module Admin Ajax Class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\AddOns\Admin;

use RadiusTheme\SBPRO\Traits\SingletonTrait;
use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;

defined( 'ABSPATH' ) || exit();

/**
 * Product Add-Ons Module Admin Class.
 */
class AdminAjax {
	use SingletonTrait;

	/**
	 * Module Class Constructor.
	 */
	private function __construct() {
		add_action( 'wp_ajax_rtsb_get_admin_group_template', [ $this, 'get_group_template' ] );
		add_action( 'wp_ajax_rtsb_get_admin_input_template', [ $this, 'get_input_template' ] );
		add_action( 'wp_ajax_rtsb_get_admin_option_template', [ $this, 'get_option_template' ] );
		add_action( 'wp_ajax_rtsb_save_admin_product_add_ons', [ $this, 'save_product_add_ons' ] );
	}

	/**
	 * Retrieves the template for a specific group.
	 *
	 * @return void
	 */
	public function get_group_template() {
		// Verify nonce.
		check_ajax_referer( rtsb()->nonceText, rtsb()->nonceId );

		$group_index = isset( $_POST['group_index'] ) ? absint( $_POST['group_index'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$template    = AddOnsFns::render_admin_group_template( null, $group_index );

		wp_send_json( $template );
	}

	/**
	 * Retrieves the template for a specific input within a group.
	 *
	 * @return void
	 */
	public function get_input_template() {
		// Verify nonce.
		check_ajax_referer( rtsb()->nonceText, rtsb()->nonceId );

		$group_index = isset( $_POST['group_index'] ) ? absint( $_POST['group_index'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$input_index = isset( $_POST['input_index'] ) ? absint( $_POST['input_index'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$template    = AddOnsFns::render_admin_input_template( null, $group_index, $input_index );

		wp_send_json( $template );
	}

	/**
	 * Retrieves the template for a specific option within an input.
	 *
	 * @return void
	 */
	public function get_option_template() {
		// Verify nonce.
		check_ajax_referer( rtsb()->nonceText, rtsb()->nonceId );

		$group_index  = isset( $_POST['group_index'] ) ? absint( $_POST['group_index'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$input_index  = isset( $_POST['input_index'] ) ? absint( $_POST['input_index'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$option_index = isset( $_POST['option_index'] ) ? absint( $_POST['option_index'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Missing
		$template     = AddOnsFns::render_admin_option_template( null, $group_index, $input_index, $option_index );

		wp_send_json( $template );
	}

	/**
	 * Saves the product add-ons data.
	 *
	 * @return void
	 */
	public function save_product_add_ons() {
		// Verify nonce.
		check_ajax_referer( rtsb()->nonceText, rtsb()->nonceId );

		$post_id = isset( $_REQUEST['post_id'] ) ? absint( $_REQUEST['post_id'] ) : null;

		if ( ! ( isset( $_REQUEST['post_id'] ) && current_user_can( 'manage_options', $post_id ) ) ) {
			wp_send_json_error( __( 'You are not allowed to edit this post.', 'shopbuilder-pro' ) );
		}

		AddOnsFns::save_product_add_ons( $post_id );

		wp_send_json_success( 'Add-ons saved successfully.' );
	}
}
