<?php
/**
 * BuilderFns class
 *
 * The  builder.
 *
 * @package  RadiusTheme\SB
 * @since    1.0.0
 */

namespace RadiusTheme\SBPRO\Helpers;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SB\Helpers\Fns;
use WC_Order;

/**
 * BuilderFns class
 */
class BuilderFunPro {

	/**
	 * Is thank you
	 *
	 * @return boolean
	 */
	public static function is_thank_you() {
		return BuilderFns::is_page_builder( 'order-thank-you', is_checkout() && is_order_received_page() );
	}

	/**
	 * Is order pay
	 *
	 * @return boolean
	 */
	public static function is_order_pay() {
		return BuilderFns::is_page_builder( 'order-pay', is_checkout() && is_checkout_pay_page() );
	}

	/**
	 * Is account page.
	 *
	 * @return bool
	 */
	public static function is_account_dashboard() {
		return BuilderFns::is_page_builder( 'myaccount-dashboard', is_account_page() && ! is_wc_endpoint_url(), true );
	}

	/**
	 * Is orders page.
	 *
	 * @return bool
	 */
	public static function is_orders_page() {
		return BuilderFns::is_page_builder( 'myaccount-order', is_wc_endpoint_url( 'orders' ), true );
	}

	/**
	 * Checks if the provided type corresponds to a custom endpoint on the My Account page.
	 *
	 * @param string $name The name of the custom endpoint to check.
	 * @return bool
	 */
	public static function is_account_custom_endpoint( $name ) {
		return BuilderFns::is_page_builder( 'myaccount-' . $name, FnsPro::is_wc_endpoint_url( $name ), true );
	}

	/**
	 * Is orders details page.
	 *
	 * @return bool
	 */
	public static function is_orders_details_page() {
		return BuilderFns::is_page_builder( 'myaccount-order-details', is_wc_endpoint_url( 'view-order' ), true );
	}

	/**
	 * Is downloads page.
	 *
	 * @return bool
	 */
	public static function is_downloads_page() {
		return BuilderFns::is_page_builder( 'myaccount-downloads', is_wc_endpoint_url( 'downloads' ), true );
	}

	/**
	 * Is address page.
	 *
	 * @return bool
	 */
	public static function is_address_page() {
		$is_edit_address = is_wc_endpoint_url( 'edit-address' ) && ! ( self::is_myaccount_address_type( 'billing' ) || self::is_myaccount_address_type( 'shipping' ) );

		return BuilderFns::is_page_builder( 'myaccount-address', $is_edit_address, true );
	}

	/**
	 * Is edit billing address page.
	 *
	 * @return bool
	 */
	public static function is_account_edit_billing_address() {
		return BuilderFns::is_page_builder( 'myaccount-edit-billing-address', self::is_myaccount_address_type( 'billing' ), true );
	}

	/**
	 * Is edit shipping address page.
	 *
	 * @return bool
	 */
	public static function is_account_edit_shipping_address() {
		return BuilderFns::is_page_builder( 'myaccount-edit-shipping-address', self::is_myaccount_address_type( 'shipping' ), true );
	}

	/**
	 * Is account details page.
	 *
	 * @return bool
	 */
	public static function is_account_details() {
		return BuilderFns::is_page_builder( 'myaccount-edit-details', is_wc_endpoint_url( 'edit-account' ), true );
	}

	/**
	 * Is account wishlist page.
	 *
	 * @return bool
	 */
	public static function is_account_wishlist() {
		$page_id = Fns::get_option( 'modules', 'wishlist', 'page' );

		if ( ! $page_id ) {
			return false;
		}

		return BuilderFns::is_page_builder( 'myaccount-wishlist', is_page( $page_id ) );
	}

	/**
	 * Is account login register page.
	 *
	 * @return bool
	 */
	public static function is_account_login_register() {
		return BuilderFns::is_page_builder( 'myaccount-auth', ! is_user_logged_in() && is_account_page() && ! is_wc_endpoint_url() );
	}

	/**
	 * Is lost password page.
	 *
	 * @return bool
	 */
	public static function is_lost_password_page() {
		return BuilderFns::is_page_builder( 'myaccount-lost-password', is_wc_endpoint_url( 'lost-password' ) );
	}

	/**
	 * Get order.
	 *
	 * @param bool $order_key_check Order key check.
	 *
	 * @return WC_Order
	 */
	public static function get_order( $order_key_check = false ) {
		global $wp;
		$order_id = 0;
		$order    = null;
		if ( isset( $wp->query_vars['order-received'] ) ) {
			$order_id = $wp->query_vars['order-received'];
			$order    = wc_get_order( $order_id );
		}
		if ( isset( $wp->query_vars['order-pay'] ) ) {
			$order_id = $wp->query_vars['order-pay'];
			$order    = wc_get_order( $order_id );
		}
		if ( ! absint( $order_id ) ) {
			$args = [
				'limit'   => 1,
				'orderby' => 'ID',
				'order'   => 'DESC',
			];
			// Get orders.
			$orders = wc_get_orders( $args );
			if ( ! empty( $orders ) ) {
				$order = reset( $orders );
			}
			if ( is_a( $order, 'WC_Order_Refund' ) ) {
				$order = wc_get_order( $order->get_parent_id() );
			}
		}
		if ( $order instanceof WC_Order && $order_key_check ) {
			$order_key = isset( $_GET['key'] ) ? wc_clean( wp_unslash( $_GET['key'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			if ( ! hash_equals( $order->get_order_key(), $order_key ) ) {
				$order = false;
			}
		}
		return $order;
	}

	/**
	 * Is my-account address type.
	 *
	 * @param string $type Address type.
	 *
	 * @return bool
	 */
	public static function is_myaccount_address_type( $type ) {
		global $wp;
		$is_edit_address = false;

		if ( isset( $wp->query_vars['edit-address'] ) && $wp->query_vars['edit-address'] === $type ) {
			$is_edit_address = true;
		}

		return $is_edit_address;
	}

	/**
	 * Check if the current page is any My Account-related page.
	 *
	 * @return bool
	 */
	public static function is_account_page() {
		return (
			self::is_account_dashboard() ||
			self::is_orders_page() ||
			self::is_orders_details_page() ||
			self::is_downloads_page() ||
			self::is_address_page() ||
			self::is_account_edit_billing_address() ||
			self::is_account_edit_shipping_address() ||
			self::is_account_details() ||
			self::is_account_login_register() ||
			self::is_lost_password_page() ||
			is_account_page() ||
			is_wc_endpoint_url()
		);
	}
}
