<?php
/**
 * OrderReceived class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Thankyou;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\DownloadableProductSettings;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\OrderReceivedSettings;
use RadiusTheme\SBPRO\Helpers\BuilderFunPro;
use RadiusTheme\SBPRO\Helpers\FnsPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class DownloadableProducts extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Downloadable Products', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-downloadable-products';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return DownloadableProductSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'Thank you' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {

		$controllers = $this->get_settings_for_display();

		$this->theme_support();
		$order = BuilderFunPro::get_order( ! $this->is_builder_mode() );
		if ( ! $order ) {
			FnsPro::order_message();
			return;
		}
		$downloads      = $order->get_downloadable_items();
		$show_downloads = $order->has_downloadable_item() && $order->is_download_permitted();
		$show_title     = 'yes' === $controllers['show_title'] ? true : null;
		$data           = [
			'template'    => 'elementor/thankyou/downloadable-products',
			'controllers' => $controllers,
			'show_title'  => $show_title,
		];
		if ( $this->is_builder_mode() && ! $show_downloads ) {
			$preview_data = [
				'template'   => 'elementor/myaccount/order-download-preview',
				'show_title' => $show_title,
			];
			Fns::load_template( $preview_data['template'], $preview_data, false, '', rtsbpro()->get_plugin_template_path() );
			return;
		} else {
			$data['downloads']      = $downloads;
			$data['show_downloads'] = $show_downloads;
			Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		}

		$this->theme_support( 'render_reset' );
	}
}
