<?php
/**
 * Main AdvanceProductTabs class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Single;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\AdvancedProductTabSettings;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Main AdvanceProductTabs class.
 *
 * @package RadiusTheme\SB
 */
class AdvancedProductTabs extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Advanced Product Tabs', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-advance-product-tabs';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Fields
	 *
	 * @return array
	 */
	public function widget_fields() {
		return AdvancedProductTabSettings::settings( $this );
	}

	/**
	 * Apply hooks.
	 *
	 * @return void
	 */
	public function apply_hooks() {
		add_filter( 'woocommerce_product_tabs', [ $this, 'woocommerce_product_tabs' ], 999 );
		add_filter( 'woocommerce_product_description_heading', '__return_false' );
		add_filter( 'woocommerce_product_review_heading', '__return_false' );
	}

	/**
	 * Reset hooks.
	 *
	 * @return void
	 */
	public function remove_hooks() {
		remove_filter( 'woocommerce_product_tabs', [ $this, 'woocommerce_product_tabs' ], 999 );
		remove_filter( 'woocommerce_product_description_heading', '__return_false' );
		remove_filter( 'woocommerce_product_review_heading', '__return_false' );
	}

	/**
	 * @param array $tabs Tab items.
	 *
	 * @return array
	 */
	public function woocommerce_product_tabs( $tabs ) {
		$controllers  = $this->get_settings_for_display();
		$tab_items    = [];
		$review_count = get_comments_number();

		if ( empty( $controllers['advance_tabs'] ) ) {
			return [];
		}

		if ( $this->is_edit_mode() ) {
			add_filter(
				'the_content',
				function () {
					return "This is only for preview text.Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.";
				},
				1
			);
		}

		foreach ( $controllers['advance_tabs'] as $key => $advance_tab ) {
			switch ( $advance_tab['advance_tab_items'] ) {
				case 'reviews':
				case 'description':
				case 'additional_information':
					if ( ! array_key_exists( $advance_tab['advance_tab_items'], $tabs ) ) {
						continue 2;
					}

					$tabs[ $advance_tab['advance_tab_items'] ]['title'] = $advance_tab['advanced_tab_heading_title'];

					if ( ! empty( $advance_tab['enable_tab_content_title'] ) ) {
						$tabs[ $advance_tab['advance_tab_items'] ]['enable_title']  = $advance_tab['enable_tab_content_title'];
						$tabs[ $advance_tab['advance_tab_items'] ]['content_title'] = $advance_tab['advanced_tab_content_title'];
					}

					if ( 'reviews' === $advance_tab['advance_tab_items'] ) {
						$tabs[ $advance_tab['advance_tab_items'] ]['title'] .= ' <span class="review-count">(' . esc_html( $review_count ) . ')</span>';
					}

					$tab_items[ $advance_tab['advance_tab_items'] ] = $tabs[ $advance_tab['advance_tab_items'] ];
					break;

				case 'custom_tab':
					$tab_key               = $advance_tab['advance_tab_items'] . '_' . $key;
					$tab_items[ $tab_key ] = [
						'key'           => 'custom_tab',
						'title'         => $advance_tab['advanced_tab_heading_title'],
						'enable_title'  => $advance_tab['enable_tab_content_title'],
						'content_title' => $advance_tab['advanced_tab_content_title'],
						'desc'          => $advance_tab['custom_field_description'],
					];
					break;
			}
		}

		return $tab_items;
	}

	/**
	 * Editor script
	 *
	 * @return void
	 */
	public function product_page_script() {
		if ( ! $this->is_edit_mode() ) {
			return;
		}
		?>
		<script type="text/javascript">
			if (!'<?php echo esc_attr( Fns::is_optimization_enabled() ); ?>') {
				window.rtsbProductPageInit();
			} else {
				if (typeof elementorFrontend !== 'undefined') {
					elementorFrontend.hooks.addAction(
						'frontend/element_ready/rtsb-advance-product-tabs.default',
						() => {
							window.waitForRTSB((RTSB) => {
								RTSB.modules.get('singleProductTabs')?.refresh();
								RTSB.modules.get('reviewFormStar')?.refresh();
								RTSB.modules.get('addCartIcon')?.refresh();
								RTSB.modules.get('productImage')?.refresh();
								RTSB.modules.get('CartQuantityHandler')?.refresh();
							});
						}
					);
				}
			}
		</script>

		<?php
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'Product Tabs', 'Tabs' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		global $product, $post;
		$_post       = $post;
		$_product    = $product;
		$product     = Fns::get_product();
		$controllers = $this->get_settings_for_display();

		if ( $this->is_builder_mode() ) {
			// Overriding Global.
			$this->product_page_script();
			$post = get_post( Fns::get_prepared_product_id() ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		}

		if ( BuilderFns::is_builder_preview() ) {
			add_filter(
				'the_content',
				function () use ( $product ) {
					return $product->get_description();
				},
				1
			);
		}

		$this->apply_hooks();
		$this->theme_support();

		$data = [
			'template'    => 'elementor/single-product/advanced-product-tab',
			'controllers' => $controllers,
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		$this->remove_hooks();
		$this->theme_support( 'render_reset' );

		$post    = $_post; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		$product = $_product; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
	}
}
