<?php
/**
 * AccountShippingAddress class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\AccountAddressSettings;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountShippingAddress extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Shipping Address', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-shipping-address';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return AccountAddressSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();

		$data = [
			'template'        => 'elementor/myaccount/account-shipping-address',
			'controllers'     => $controllers,
			'is_builder_mode' => $this->is_builder_mode(),
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		$this->theme_support( 'render_reset' );
	}

}
