<?php
/**
 * AccountOrders class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\DownloadableProductSettings;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountOrders extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Orders', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-orders';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return array_merge(
			$this->order_table_settings(),
			$this->button_selectors()
		);
	}

	/**
	 * Table Field
	 *
	 * @return array
	 */
	public function order_table_settings() {
		$fields                         = DownloadableProductSettings::table_settings( $this );
		$extra_controls['table_layout'] = [
			'label'     => esc_html__( 'Layout', 'shopbuilder-pro' ),
			'type'      => 'rtsb-image-selector',
			'options'   => [
				'layout-1' => [
					'title' => esc_html__( 'Layout', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/grid-Layout-1.png' ) ),
				],
				'layout-2' => [
					'title' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/grid-Layout-2.png' ) ),
				],
			],
			'default'   => 'layout-1',
			'separator' => 'default',
		];
		$extra_controls['table_horizontal_scroll_on_mobile'] = [
			'label'       => esc_html__( 'Show default Table View On Mobile?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Show default Table View On Mobile?', 'shopbuilder-pro' ),
			'default'     => '',
			'separator'   => rtsb()->has_pro() ? 'default' : 'before-short',
		];
		$extra_controls['table_min_width']                   = [
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Table Minimum Width', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter table min-width (in px),', 'shopbuilder-pro' ),
			'type'        => 'slider',
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 1000,
					'step' => 5,
				],
			],
			'condition'   => [
				'table_horizontal_scroll_on_mobile' => 'yes',
			],
			'selectors'   => [
				'.rtsb-builder-content {{WRAPPER}} .rtsb-table-horizontal-scroll-on-mobile table.shop_table' => 'min-width: {{SIZE}}{{UNIT}};',
			],
		];
		$fields = Fns::insert_controls( 'table_heading_section_start', $fields, $extra_controls, true );
		$fields['table_heading_cell_border']['condition'] = [
			'table_layout!' => [ 'layout-2' ],
		];
		$fields['table_item_bg_color']['condition']       = [
			'table_layout!' => [ 'layout-2' ],
		];
		$extra_controls2['table_row_odd_bg']              = [
			'label'     => esc_html__( 'Odd Row Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'selectors' => [
				'{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 tbody tr:nth-child(odd)' => 'background-color: {{VALUE}}',
			],
			'condition' => [
				'table_layout!' => [ 'layout-1' ],
			],
			'separator' => 'default',
		];
		$extra_controls2['table_row_even_bg']             = [
			'label'     => esc_html__( 'Even Row Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'selectors' => [
				'{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 tbody tr:nth-child(even)' => 'background-color: {{VALUE}}',
			],
			'condition' => [
				'table_layout!' => [ 'layout-1' ],
			],
			'separator' => 'default',
		];
		$extra_controls2['no_order_product_bg']           = [
			'label'     => esc_html__( 'No orders products Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'selectors' => [
				'{{WRAPPER}} .woocommerce-info' => 'background-color: {{VALUE}}',
			],
			'separator' => 'default',
		];
		$extra_controls2['no_order_product_text']         = [
			'label'     => esc_html__( 'No orders products Text', 'shopbuilder-pro' ),
			'type'      => 'color',
			'selectors' => [
				'{{WRAPPER}} .woocommerce-info' => 'color: {{VALUE}}',
			],
			'separator' => 'default',
		];
		$fields = Fns::insert_controls( 'table_item_color', $fields, $extra_controls2, true );
		return $this->order_table_selectors( $fields );
	}

	/***
	 * @param Array $fields  Order Table Selectors.
	 *
	 * @return array
	 */
	public function order_table_selectors( $fields ) {
		$fields['table_heading_cell_padding']['selectors']['{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 td'] = 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}';
		$fields['table_header_typo']['selector'] = $fields['table_header_typo']['selector'] . ',{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 thead .nobr';
		$fields['table_header_align']['selectors']['{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 thead th']                 = 'text-align: {{VALUE}}!important';
		$fields['table_header_color']['selectors']['{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 thead th .nobr']           = 'color: {{VALUE}} !important';
		$fields['table_header_bg_color']['selectors']['{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 thead tr:nth-child(1)'] = 'background-color: {{VALUE}} !important';
		$fields['table_item_typo']['selector'] = $fields['table_item_typo']['selector'] . ',{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 tbody td';
		$fields['table_item_align']['selectors']['{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 tbody td,{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 tbody tr']   = 'text-align: {{VALUE}}!important';
		$fields['table_item_color']['selectors']['{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 tbody td,{{WRAPPER}} .rtsb-myacount-page .account-orders-table.layout-2 tbody td a'] = 'color: {{VALUE}}';
		return $fields;
	}
	/***
	 * @param Array $fields  Order Table Selectors.
	 *
	 * @return array
	 */
	public function button_selectors() {
		$fields = ButtonSettings::style_settings( $this );
		$fields['button_text_color_normal']['selectors']['.rtsb-account-table.layout-2 .button:before']      = 'background-color: {{VALUE}}!important';
		$fields['button_text_color_hover']['selectors']['.rtsb-account-table.layout-2 .button:hover:before'] = 'background-color: {{VALUE}}!important';

		return $fields;
	}
	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();
		global $wp;

		$current_page = 1;
		if ( ! empty( $wp->query_vars ) ) {
			$current_page = ! empty( $wp->query_vars['orders'] ) ? $wp->query_vars['orders'] : 1;
		}
		if ( $this->is_builder_mode() ) {
			$current_page = isset( $_GET['pages'] ) ? esc_html( $_GET['pages'] ) : 1;
			add_filter(
				'woocommerce_get_endpoint_url',
				function ( $url, $endpoint, $value ) {
					if ( strpos( $url, 'orders' ) ) {
						$url = preg_replace( '/orders\/\d\//', '', $url );
						$url = add_query_arg( 'pages', $value, $url );
					}
					return $url;
				},
				15,
				3
			);
		}

		$data = [
			'template'     => 'elementor/myaccount/account-orders/' . $controllers['table_layout'],
			'controllers'  => $controllers,
			'current_page' => $current_page,
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		$this->theme_support( 'render_reset' );
	}
}
