<?php
/**
 * AccountOrderDetailsOrderAgain class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Helpers\Fns;



// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountOrderAgain extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Order Again Button', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-order-again';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return ButtonSettings::style_settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();
		$this->theme_support();
		global $wp;
		if ( ! empty( $wp->query_vars['view-order'] ) && $order = wc_get_order( $wp->query_vars['view-order'] ) ) {
			$data = [
				'template'    => 'elementor/myaccount/account-order-again',
				'controllers' => $controllers,
				'order'       => $order,
			];
			Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		} else {
			?>
			<p class="order-again rtsb-myacount-page">
				<a href="#" class="button">
					<?php esc_html_e( 'Order again', 'shopbuilder-pro' ); ?>
				</a>
			</p>
			<?php
		}

		$this->theme_support( 'render_reset' );
	}

}


