<?php
/**
 * AccountNavigation class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\AccountNavigationSettings;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountNavigation extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Navigation', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-navigation';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return AccountNavigationSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	public function navigation_menu_items( $settings ) {
		add_filter(
			'woocommerce_account_menu_items',
			function ( $items ) use ( $settings ) {
				foreach ( $items as $key => $value ) {
					if ( isset( $settings[ $key . '_show' ] ) && empty( $settings[ $key . '_show' ] ) ) {
						unset( $items[ $key ] );
					}
				}
				return $items;
			}
		);
	}


	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();
		$this->navigation_menu_items( $controllers );
		$this->theme_support();

		$data = [
			'template'    => FnsPro::is_module_active( 'customize_my_account' )
								? 'elementor/myaccount/customized-account-navigation'
								: 'elementor/myaccount/account-navigation',
			'controllers' => $controllers,
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		$this->theme_support( 'render_reset' );
	}
}
