<?php
/**
 * AccountLostPassword class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\LostPasswordSettings;
use WC_Shortcode_My_Account;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountLostPassword extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Lost Password Form', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-lost-password';
		parent::__construct( $data, $args );
		$this->rtsb_category = 'rtsb-shopbuilder-general';
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return LostPasswordSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();
		$data = [
			'template'    => 'elementor/myaccount/account-lost-password',
			'controllers' => $controllers,
		];

		if ( ! empty( $_GET['reset-link-sent'] ) && 'true' == sanitize_text_field( $_GET['reset-link-sent'] ) ) {
			$data['template'] = 'elementor/myaccount/lost-password-confirmation';
		}
		if ( ! empty( $_GET['show-reset-form'] ) && 'true' == sanitize_text_field( $_GET['show-reset-form'] ) ) {
			if ( isset( $_COOKIE[ 'wp-resetpass-' . COOKIEHASH ] ) && 0 < strpos( $_COOKIE[ 'wp-resetpass-' . COOKIEHASH ], ':' ) ) {
				list( $rp_id, $rp_key ) = array_map( 'wc_clean', explode( ':', wp_unslash( $_COOKIE[ 'wp-resetpass-' . COOKIEHASH ] ), 2 ) ); // @codingStandardsIgnoreLine
				$userdata               = get_userdata( absint( $rp_id ) );
				$rp_login               = $userdata ? $userdata->user_login : '';
				$user                   = WC_Shortcode_My_Account::check_password_reset_key( $rp_key, $rp_login );
				if ( is_object( $user ) ) {
					$data['key']      = $rp_key;
					$data['login']    = $rp_login;
					$data['template'] = 'elementor/myaccount/reset-password';
				}
			}
		}

		echo '<section class="rtsb-myacount-page">';
		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		echo '</section>';

		$this->theme_support( 'render_reset' );
	}
}
