<?php
/**
 * AccountDownloads class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\AccountNavigationSettings;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\DownloadableProductSettings;
use RadiusTheme\SBPRO\Helpers\BuilderFunPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountDownloads extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Downloads', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-download';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return array_merge(
			$this->account_downloadable_product_settings(),
			ButtonSettings::style_settings( $this ),
			$this->notice_style()
		);
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function notice_style() {
		$fields = [
			'notice_section'      => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Empty Notice ', 'shopbuilder-pro' ),
			],
			'notice_typography'   => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $this->selectors['notice_typography'],
			],
			'notice_padding'      => [
				'label'      => esc_html__( 'Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$this->selectors['notice_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'separator'  => 'before',
			],

			// Tab For normal view.
			'notice_bg_color'     => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$this->selectors['notice_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'notice_text_color'   => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$this->selectors['notice_text_color'] => 'color: {{VALUE}};',
				],
			],
			'notice_border_color' => [
				'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$this->selectors['notice_border_color'] => 'border-color: {{VALUE}};',
				],
			],
			'icon_heading'        => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Icon', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'notice_icon_size'    => [
				'label'     => esc_html__( 'Notice Icon Size', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'mode'      => 'responsive',
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					$this->selectors['notice_icon_size'] => 'width: {{SIZE}}{{UNIT}};',
				],
			],
			'icon_color'          => [
				'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'before',
				'selectors' => [
					$this->selectors['icon_color'] => 'color: {{VALUE}};fill: currentColor;',
				],
			],
			'icon_bg_color'       => [
				'label'     => esc_html__( 'Icon Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$this->selectors['icon_bg_color'] => 'background-color: {{VALUE}};fill: currentColor;',
				],
			],
			'icon_margin'         => [
				'label'      => esc_html__( 'Icon Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$this->selectors['icon_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'notice_section_end'  => [
				'mode' => 'section_end',
			],
		];

		return $fields;
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function account_downloadable_product_settings() {
		$fields = DownloadableProductSettings::table_settings( $this );

		$extra_controls['table_horizontal_scroll_on_mobile'] = [
			'label'       => esc_html__( 'Show default Table View On Mobile?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Show default Table View On Mobile?', 'shopbuilder-pro' ),
			'default'     => '',
			'separator'   => rtsb()->has_pro() ? 'default' : 'before-short',
		];

		$extra_controls['table_min_width'] = [
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Table Minimum Width', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter table min-width (in px),', 'shopbuilder-pro' ),
			'type'        => 'slider',
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 1000,
					'step' => 5,
				],
			],
			'condition'   => [
				'table_horizontal_scroll_on_mobile' => 'yes',
			],
			'selectors'   => [
				$this->selectors['table_min_width'] => 'min-width: {{SIZE}}{{UNIT}};',
			],
		];

		$fields = Fns::insert_controls( 'table_heading_section_start', $fields, $extra_controls, true );

		$extra_controls['striped_row_active']       = [
			'label'       => esc_html__( 'Striped rows background?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Switch on to add striped rows background.', 'shopbuilder-pro' ),
			'default'     => '',
			'separator'   => 'default',
		];
		$extra_controls['striped_row_even_bg']      = [
			'label'     => esc_html__( 'Even Row Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'selectors' => [
				$this->selectors['striped_row_even_bg'] => 'background-color: {{VALUE}}',
			],
			'condition' => [
				'striped_row_active' => 'yes',
			],
			'separator' => 'default',
		];
		$fields['table_item_bg_color']['condition'] = [
			'striped_row_active!' => 'yes',
		];
		return Fns::insert_controls( 'table_items_label', $fields, $extra_controls, true );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();

		$data = [
			'template'    => 'elementor/myaccount/account-downloads',
			'controllers' => $controllers,
		];
		if ( $this->is_builder_mode() ) {
			wc_load_cart();
		}
		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		$this->theme_support( 'render_reset' );
	}
}
