<?php
/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\ProductLookBook;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls as SBControls;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\StyleFields;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\ContentFields;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */
class Controls {
	/**
	 * Content section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function content( $obj ) {
		return array_merge(
		// self::layout( $obj ),
			ContentFields::image( $obj ),
			ContentFields::pointers( $obj, esc_html__( 'Lookbook', 'shopbuilder-pro' ) ),
		);
	}

	/**
	 * Style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function style( $obj ) {
		$color_scheme = SBControls\StyleFields::color_scheme( $obj );
		$image        = SBControls\StyleFields::image( $obj, [] );

		$color_scheme['loader_color']['label']                    = esc_html__( 'Ajax Loader Color', 'shopbuilder-pro' );
		$color_scheme['loader_color']['default']                  = '#fff';
		$image['rtsb_el_image_styles_overlay']['condition']       = [ 'lookbook_show_overlay' => [ 'yes' ] ];
		$image['rtsb_el_image_styles_hover_overlay']['condition'] = [ 'lookbook_show_overlay' => [ 'yes' ] ];
		$image['image_styles_color_note']['separator']            = 'default';

		unset(
			$image['image_styles_dimension_note'],
			$image['image_styles_width'],
			$image['image_styles_max_width'],
			$image['image_wrapper_styles_color'],
		);

		return array_merge(
			$color_scheme,
			$image,
			StyleFields::pointer_styles( $obj ),
			self::product_popup( $obj )
		);
	}

	/**
	 * Preset section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function layout( $obj ) {
		$fields['lookbook_layout'] = $obj->start_section(
			esc_html__( 'Presentation', 'shopbuilder-pro' ),
			'content'
		);

		$fields['layout_note'] = $obj->el_heading( esc_html__( 'Predefined Layouts', 'shopbuilder-pro' ) );
		$fields['layout']      = [
			'type'    => 'rtsb-image-selector',
			'options' => apply_filters(
				'rtsb/elements/elementor/product_lookbook_layouts',
				[
					'rtsb-lookbook-layout1' => [
						'title' => esc_html__( 'Layout 1', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/heading-preset-1.png' ) ),
					],
					'rtsb-lookbook-layout2' => [
						'title' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/heading-preset-1.png' ) ),
					],
				]
			),
			'default' => 'rtsb-lookbook-layout1',
		];

		$fields['lookbook_layout_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Product Popup section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function product_popup( $obj ) {
		$css_selectors = $obj->selectors['product_popup'];

		$fields['product_popup_start'] = $obj->start_section( esc_html__( 'Product Popup', 'shopbuilder-pro' ), 'style' );

		$fields['product_popup_note'] = $obj->el_heading( esc_html__( 'Dimension', 'shopbuilder-pro' ) );

		$fields['product_popup_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Popup Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 100,
					'max' => 500,
				],
			],
			'selectors'  => [ $css_selectors['product_popup_width'] => 'width: {{SIZE}}{{UNIT}};' ],
		];

		$fields['product_popup_image_height'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Product Image Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 100,
					'max' => 500,
				],
			],
			'selectors'  => [ $css_selectors['product_popup_image_height'] => 'height: {{SIZE}}{{UNIT}};' ],
		];

		$fields['product_popup_typography_note'] = $obj->el_heading( esc_html__( 'Typography', 'shopbuilder-pro' ) );

		$fields['rtsb_el_product_title_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Title Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['title_typography'],
		];

		$fields['rtsb_el_product_price_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Price Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['price_typography'],
		];

		$fields['product_popup_color_note'] = $obj->el_heading( esc_html__( 'Colors', 'shopbuilder-pro' ) );

		$fields['popup_color_tabs'] = $obj->start_tab_group();
		$fields['popup_color_tab']  = $obj->start_tab( esc_html__( 'Normal', 'shopbuilder-pro' ) );

		$fields['popup_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Popup Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_bg_color'] => '--rtsb-tippy-bg: {{VALUE}};' ],
		];

		$fields['popup_title_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Title Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_title_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_price_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Price Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_price_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_badge_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Badge Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_badge_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_badge_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Badge Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_badge_bg_color'] => 'background-color: {{VALUE}};' ],
		];

		$fields['popup_action_button_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Action Buttons Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_action_button_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_button_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Cart Button Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_button_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_button_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Cart Button Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_button_bg_color'] => 'background-color: {{VALUE}};' ],
		];

		$fields['popup_color_tab_end']   = $obj->end_tab();
		$fields['popup_hover_color_tab'] = $obj->start_tab( esc_html__( 'Hover', 'shopbuilder-pro' ) );

		$fields['popup_title_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Title Hover Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_title_hover_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_action_button_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Action Buttons Hover Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_action_button_hover_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_button_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Cart Button Hover Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_button_hover_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_button_bg_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Cart Button Hover Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_button_bg_hover_color'] => 'background-color: {{VALUE}};' ],
		];

		$fields['product_popup_hover_color_tab_end'] = $obj->end_tab();
		$fields['product_popup_color_tabs_end']      = $obj->end_tab_group();

		$fields['product_popup_end'] = $obj->end_section();

		return $fields;
	}
}
