<?php
/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\ImageHotspots;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */
class Selectors {
	/**
	 * Image Hotspots CSS Selectors.
	 *
	 * @return array
	 */
	public static function get_selectors() {
		return [
			'pointers'       => [
				'pos_x' => '{{WRAPPER}} {{CURRENT_ITEM}}',
				'pos_y' => '{{WRAPPER}} {{CURRENT_ITEM}}',
			],
			'color_scheme'   => [
				'primary_color'   => '{{WRAPPER}} .rtsb-image-hotspots, .tippy-box[data-theme=rtsb-hotspot]',
				'secondary_color' => '{{WRAPPER}} .rtsb-image-hotspots, .tippy-box[data-theme=rtsb-hotspot]',
				'loader_color'    => '{{WRAPPER}} .rtsb-image-hotspots',
			],
			'image'          => [
				'overlay'              => '{{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.show-overlay::before',
				'hover_overlay'        => '{{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.show-overlay:hover::before',
				'img_bg_color'         => '{{WRAPPER}} .rtsb-image-hotspots .image-container img',
				'border'               => '{{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper',
				'border_radius'        => '{{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper',
				'margin'               => '{{WRAPPER}} .rtsb-image-hotspots',
				'width'                => '',
				'max_width'            => '',
				'img_wrapper_bg_color' => '',
			],
			'pointer_styles' => [
				'pointer_width'              => '{{WRAPPER}} .rtsb-image-hotspots, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset2, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset3 .popup-pointer-buttons .hotspot-button',
				'pointer_icon_size'          => '{{WRAPPER}} .rtsb-image-hotspots, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset3 .popup-pointer-buttons .hotspot-button',
				'pointer_hover_width'        => '{{WRAPPER}} .rtsb-image-hotspots',
				'pointer_scale'              => '{{WRAPPER}} .rtsb-image-hotspots, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset2, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset3',
				'pointer_color'              => '{{WRAPPER}} .rtsb-image-hotspots .popup-pointer-buttons .hotspot-button .hotspot-data',
				'pointer_bg_color'           => '{{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset2, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset3',
				'pointer_border_color'       => '{{WRAPPER}} .rtsb-image-hotspots .popup-pointer-buttons .hotspot-button, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset3',
				'pointer_hover_color'        => '{{WRAPPER}} .rtsb-image-hotspots .popup-pointer-buttons .hotspot-button:hover .hotspot-data',
				'pointer_bg_hover_color'     => '{{WRAPPER}} .rtsb-image-hotspots .popup-pointer-buttons .hotspot-button:hover .hotspot-data',
				'pointer_hover_border_color' => '{{WRAPPER}} .rtsb-image-hotspots .popup-pointer-buttons .hotspot-button:hover, {{WRAPPER}} .rtsb-image-hotspots .lookbook-wrapper.lookbook-pointer-preset3 .popup-pointer-buttons .hotspot-button:hover',
			],
			'hotspot_popup'  => [
				'hotspot_popup_width' => '.tippy-box[data-theme=rtsb-hotspot]',
				'title_typography'    => '.rtsb-elementor-container.hotspot-content .hotspot-title',
				'content_typography'  => '.rtsb-elementor-container.hotspot-content .hotspot-body',
				'hotspot_icon_size'   => [
					'font_size' => '.rtsb-elementor-container.hotspot-content .hotspot-icon',
					'width'     => '.rtsb-elementor-container.hotspot-content .hotspot-icon svg',
				],
				'popup_bg_color'      => '.tippy-box[data-theme=rtsb-hotspot]',
				'popup_title_color'   => '.rtsb-elementor-container.hotspot-content .hotspot-title',
				'popup_content_color' => '.rtsb-elementor-container.hotspot-content .hotspot-body',
				'popup_icon_color'    => '.rtsb-elementor-container.hotspot-content .hotspot-icon',
			],
		];
	}
}
