<?php
/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\ImageHotspots;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls as SBControls;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\StyleFields;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\ContentFields;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */
class Controls {
	/**
	 * Content section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function content( $obj ) {
		return array_merge(
//			self::layout( $obj ),
			ContentFields::image( $obj ),
			ContentFields::pointers( $obj, esc_html__( 'Hotspots', 'shopbuilder-pro' ), 'hotspots', 'content' ),
		);
	}

	/**
	 * Style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function style( $obj ) {
		$image = SBControls\StyleFields::image( $obj, [] );

		$image['rtsb_el_image_styles_overlay']['condition']       = [ 'lookbook_show_overlay' => [ 'yes' ] ];
		$image['rtsb_el_image_styles_hover_overlay']['condition'] = [ 'lookbook_show_overlay' => [ 'yes' ] ];
		$image['image_styles_color_note']['separator']            = 'default';

		unset(
			$image['image_styles_dimension_note'],
			$image['image_styles_width'],
			$image['image_styles_max_width'],
			$image['image_wrapper_styles_color'],
		);

		return array_merge(
			$image,
			StyleFields::pointer_styles( $obj ),
			self::hotspot_popup( $obj )
		);
	}

	/**
	 * Preset section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function layout( $obj ) {
		$fields['lookbook_layout'] = $obj->start_section(
			esc_html__( 'Presentation', 'shopbuilder-pro' ),
			'content'
		);

		$fields['layout_note'] = $obj->el_heading( esc_html__( 'Predefined Layouts', 'shopbuilder-pro' ) );
		$fields['layout']      = [
			'type'    => 'rtsb-image-selector',
			'options' => apply_filters(
				'rtsb/elements/elementor/product_lookbook_layouts',
				[
					'rtsb-lookbook-layout1' => [
						'title' => esc_html__( 'Layout 1', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/heading-preset-1.png' ) ),
					],
					'rtsb-lookbook-layout2' => [
						'title' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/heading-preset-1.png' ) ),
					],
				]
			),
			'default' => 'rtsb-lookbook-layout1',
		];

		$fields['lookbook_layout_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Product Popup section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function hotspot_popup( $obj ) {
		$css_selectors = $obj->selectors['hotspot_popup'];

		$fields['hotspot_popup_start'] = $obj->start_section( esc_html__( 'Hotspot Popup', 'shopbuilder-pro' ), 'style' );

		$fields['hotspot_popup_note'] = $obj->el_heading( esc_html__( 'Dimension', 'shopbuilder-pro' ) );

		$fields['hotspot_popup_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Popup Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 100,
					'max' => 500,
				],
			],
			'selectors'  => [ $css_selectors['hotspot_popup_width'] => 'width: {{SIZE}}{{UNIT}};' ],
		];

		$fields['hotspot_popup_typography_note'] = $obj->el_heading( esc_html__( 'Typography', 'shopbuilder-pro' ) );

		$fields['rtsb_el_title_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Title Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['title_typography'],
		];

		$fields['rtsb_el_content_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Content Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['content_typography'],
		];

		$fields['hotspot_icon_size'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 5,
					'max' => 100,
				],
			],
			'selectors'  => [
				$css_selectors['hotspot_icon_size']['font_size'] => 'font-size: {{SIZE}}{{UNIT}};',
				$css_selectors['hotspot_icon_size']['width']     => 'width: {{SIZE}}{{UNIT}};',
			],
		];

		$fields['hotspot_popup_color_note'] = $obj->el_heading( esc_html__( 'Colors', 'shopbuilder-pro' ) );

		$fields['popup_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Popup Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_bg_color'] => '--rtsb-tippy-bg: {{VALUE}};' ],
		];

		$fields['popup_title_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Title Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_title_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_content_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Content Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_content_color'] => 'color: {{VALUE}};' ],
		];

		$fields['popup_icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['popup_icon_color'] => 'color: {{VALUE}};' ],
		];

		$fields['hotspot_popup_end'] = $obj->end_section();

		return $fields;
	}
}
