<?php
/**
 * HighLightedProduct class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General;

use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;

use RadiusTheme\SB\Traits\ActionBtnTraits;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\HighlightedProductSettings;
use WC_Product_Query;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * ProductsList class.
 */
class HighLightedProduct extends ElementorWidgetBase {
	/**
	 * Action Button Traits.
	 */
	use ActionBtnTraits;
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Highlighted Product', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-highlighted-product';

		parent::__construct( $data, $args );

		$this->rtsb_category = 'rtsb-shopbuilder-general';
	}


	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return HighlightedProductSettings::widget_fields( $this );
	}

	public function get_keywords() {
		return [ 'Highlighted Product', 'Tabs' ] + parent::get_keywords();
	}


	public function widget_dependency_scripts() {
		wp_enqueue_script( 'flexslider' );
		wp_enqueue_script( 'wc-single-product' );
	}

	public function editor_scripts() {
		?>
		<script>
			/*
			* Initialize all galleries on page.
			*/
			jQuery('.woocommerce-product-gallery').each(function () {
				const that = this;
				jQuery(this).trigger('wc-product-gallery-before-init', [this, wc_single_product_params]);
				setTimeout(function () {
					jQuery(that).wc_product_gallery(wc_single_product_params);
				}, 1000);

				jQuery(this).trigger('wc-product-gallery-after-init', [this, wc_single_product_params]);
			});
			<?php if ( function_exists( 'rtwpvg' ) ) { ?>
				setTimeout(function () {
					jQuery('.rtwpvg-wrapper, .rtwpvg-grid-wrapper').rtWpVGallery();
				}, 1000);
			<?php } ?>
			jQuery(document).ready(function ($) {
				setTimeout(function () {
					const zoomIcon = $('.rtsb-product-images').attr('data-zoom-icon');
					if (!zoomIcon) {
						$('.rtsb-product-images')
							.find('.woocommerce-product-gallery__trigger,.rtwpvg-trigger')
							.remove();
					}
					$('.rtsb-product-images')
						.find('.woocommerce-product-gallery__trigger,.rtwpvg-trigger')
						.html(zoomIcon);
				}, 50);
			});

		</script>
		<?php
	}

	public function the_apply_hooks() {
		$this->product_image_hooks();
		$this->action_button_icon_modify();
		$this->action_buttons_hooks();
	}

	public function product_image_hooks() {
		$control = $this->get_settings_for_display();
		if ( empty( $control ) ) {
			return;
		}
		add_filter(
			'woocommerce_product_thumbnails_columns',
			function ( $col ) {
				$col = 0;

				return $col;
			}
		);

		if ( empty( $control['show_thumbnails'] ) ) {
			add_filter( 'rtwpvg_show_product_thumbnail_slider', '__return_false' );
			remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );
		}
		add_filter( 'rtwpvg_thumbnail_slider_js_options', [ $this, 'thumbnail_slider_js_options' ], 50 );
		add_filter( 'rtwpvg_thumbnail_position', [ $this, 'thumbnail_position' ], 50 );
		add_filter( 'rtwpvg_thumbnails_columns', [ $this, 'thumbnails_columns' ] );
		add_filter( 'rtwpvg_sm_thumbnails_columns', [ $this, 'thumbnails_columns_sm' ] );
		add_filter( 'rtwpvg_xs_thumbnails_columns', [ $this, 'thumbnails_columns_xs' ] );
	}
	public function thumbnail_slider_js_options( $options ) {
		if ( isset( $options['spaceBetween'] ) ) {
			$controllers             = $this->get_settings_for_display();
			$options['spaceBetween'] = $controllers['gallery_thumbs_column_gap']['size'];
		}
		return $options;
	}
	/**
	 * @param $position
	 *
	 * @return mixed
	 */
	public function thumbnail_position( $position ) {

		if ( ! function_exists( 'rtwpvg' ) || ! rtwpvg()->active_pro() || ! ( BuilderFns::is_product() || BuilderFns::is_quick_views_page() ) ) {
			return $position;
		}

		$controllers     = $this->get_settings_for_display();
		$show_thumbnails = ! empty( $controllers['show_thumbnails'] ) ? $controllers['show_thumbnails'] : false;

		if ( ! $show_thumbnails ) {
			add_filter( 'rtwpvg_show_product_thumbnail_slider', '__return_false', 20 );
			return 'bottom';
		}

		return ! empty( $controllers['image_layout'] ) ? $controllers['image_layout'] : 'bottom';
	}
	public function thumbnails_columns( $column ) {
		$controllers = $this->get_settings_for_display();
		$column      = ! empty( $controllers['gallery_thumbs_column']['size'] ) ? $controllers['gallery_thumbs_column']['size'] : $column;
		return $column;
	}
	public function thumbnails_columns_sm( $column ) {
		$controllers = $this->get_settings_for_display();
		$column      = ! empty( $controllers['gallery_thumbs_column_tablet']['size'] ) ? $controllers['gallery_thumbs_column_tablet']['size'] : $column;

		return $column;
	}

	public function thumbnails_columns_xs( $column ) {
		$controllers = $this->get_settings_for_display();
		$column      = ! empty( $controllers['gallery_thumbs_column_mobile']['size'] ) ? $controllers['gallery_thumbs_column_mobile']['size'] : $column;

		return $column;
	}
	/**
	 * Widget Field.
	 *
	 * @param array $controllers Control.
	 *
	 * @return void
	 */
	public function quantity_input_field_hooks( array $controllers = [] ) {
		if ( ! $controllers ) {
			return;
		}
		add_filter( 'rtsb/module/flash_sale_countdown/show_counter', '__return_false', 99 );
		$product        = Fns::get_product();
		$is_visible_qty = Fns::is_visible_qty_input( $product );
		if ( ! empty( $controllers['quantity_style'] ) && $is_visible_qty ) {
			if ( in_array( $controllers['quantity_style'], [ 'style-1', 'style-2' ] ) ) {
				add_action(
					'woocommerce_before_quantity_input_field',
					function () use ( $controllers ) {
						?>
						<!-- Quantity Wrapper Start -->
						<div class="rtsb-quantity-box-group rtsb-quantity-box-group-<?php echo esc_attr( $controllers['quantity_style'] ); ?>">
						<button type="button" class="rtsb-quantity-btn rtsb-quantity-minus">
							<?php
							echo wp_kses(
								$controllers['decrement_icon_html'],
								[
									'i' => [
										'class'       => [],
										'aria-hidden' => [],
									],
								]
							);
							?>
						</button>
						<?php
					}
				);
				add_action(
					'woocommerce_after_quantity_input_field',
					function () use ( $controllers ) {
						?>
						<button type="button" class="rtsb-quantity-btn rtsb-quantity-plus">
							<?php
							echo wp_kses(
								$controllers['increment_icon_html'],
								[
									'i' => [
										'class'       => [],
										'aria-hidden' => [],
									],
								]
							);
							?>
						</button>
						</div>
						<!-- Quantity Wrapper End -->
						<?php
					}
				);
			}
			if ( in_array( $controllers['quantity_style'], [ 'style-3', 'style-4' ] ) && $is_visible_qty ) {
				add_action(
					'woocommerce_before_quantity_input_field',
					function () use ( $controllers ) {
						$inner_border = ! empty( $controllers['show_inner_border'] ) ? 'show-inner-border' : '';
						?>
						<!-- Quantity Wrapper Start -->
						<div class="rtsb-quantity-box-group rtsb-quantity-box-group-<?php echo esc_attr( $controllers['quantity_style'] . ' ' . $inner_border ); ?>">
						<div class="rtsb-qty-btns-group">
							<button type="button" class="rtsb-quantity-btn rtsb-quantity-plus">
								<?php
								echo wp_kses(
									$controllers['increment_icon_html'],
									[
										'i' => [
											'class'       => [],
											'aria-hidden' => [],
										],
									]
								);
								?>
							</button>
							<button type="button" class="rtsb-quantity-btn rtsb-quantity-minus">
								<?php
								echo wp_kses(
									$controllers['decrement_icon_html'],
									[
										'i' => [
											'class'       => [],
											'aria-hidden' => [],
										],
									]
								);
								?>
							</button>
						</div>
						<?php
					}
				);
				add_action(
					'woocommerce_after_quantity_input_field',
					function () {
						?>
						</div>
						<!-- Quantity Wrapper End -->
						<?php
					}
				);
			}
		}
	}

	/**
	 * Widget Field.
	 *
	 * @param array $controllers Control.
	 *
	 * @return void
	 */

	public function action_buttons_hooks() {
		add_filter( 'rtsb/module/wishlist/button_params', [ $this, 'wishlist_button_params' ], 99 );
		add_filter( 'rtsb/module/compare/button_params', [ $this, 'compare_button_params' ], 99 );
	}
	public function action_buttons_remove_hooks() {
		remove_filter( 'rtsb/module/wishlist/button_params', [ $this, 'wishlist_button_params' ], 99 );
		remove_filter( 'rtsb/module/compare/button_params', [ $this, 'compare_button_params' ], 99 );
	}
	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function wishlist_button_params( $params ) {
		$controllers = $this->get_settings_for_display();
		if ( ! empty( $controllers['wishlist_button_text'] ) ) {
			$params['button_text']      = $controllers['wishlist_button_text'];
			$params['show_button_text'] = true;
		}

		return $params;
	}

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function compare_button_params( $params ) {
		$controllers = $this->get_settings_for_display();
		if ( ! empty( $controllers['comparison_button_text'] ) ) {
			$params['button_text']      = $controllers['comparison_button_text'];
			$params['show_button_text'] = true;
		}

		return $params;
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();
		if ( empty( $controllers['show_module_badges'] ) ) {
			add_filter( 'rtsb/module/badges/show', '__return_false', 99 );
		}
		$this->widget_dependency_scripts();
		$controllers['increment_icon_html'] = Fns::icons_manager( $controllers['increment_icon'] );
		$controllers['decrement_icon_html'] = Fns::icons_manager( $controllers['decrement_icon'] );
		$add_to_cart_visibility             = rtsb()->has_pro() && Fns::is_guest_feature_disabled( 'hide_add_to_cart', '' );
		$controllers['visibility']          = $add_to_cart_visibility ? ' rtsb-not-visible' : ' rtsb-is-visible';
		$this->quantity_input_field_hooks( $controllers );
		$this->the_apply_hooks();
		$this->theme_support();
		$layout     = 'layout-1';
		$data       = [
			'template'    => 'elementor/general/highlighted-product/' . $layout,
			'controllers' => $controllers,
		];
		$product_id = $controllers['product_id'];
		if ( $product_id ) {
			$product              = wc_get_product( $product_id );
			$GLOBALS['product']   = $product;
			$data['product_type'] = $product ? $product->get_type() : '';
			echo '<div class="rtsb-highlighted-product-wrapper">';
			do_action( 'rtsb_before_product_template_render' );
			Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
			/**
			 * After product template render hook.
			 */
			do_action( 'rtsb_after_product_template_render' );
			echo '</div>';
			if ( $this->is_edit_mode() ) {
				$this->editor_scripts();
			}
			$this->action_buttons_remove_hooks();
			$this->action_button_icon_set_default();
			if ( empty( $controllers['show_module_badges'] ) ) {
				remove_filter( 'rtsb/module/badges/show', '__return_false', 99 );
			}
			$this->theme_support( 'render_reset' );
			unset( $GLOBALS['product'] );
		} else {
			echo '<div class="alert alert-info" role="alert"><i class="fa fa-info-circle"></i>';
			echo esc_html__( ' Please choose product name first for showing highligted product', 'shopbuilder-pro' );
			echo '</div>';
		}
	}

}
