<?php
/**
 * Render class for Image Hotspots widget.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\HeroSlider;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Helper\RenderHelpers;
use RadiusTheme\SB\Elementor\Render\GeneralAddons;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Render class.
 *
 * @package RadiusTheme\SBPRO
 */
class Render extends GeneralAddons {
	/**
	 * Main render function for displaying content.
	 *
	 * @param array $data     Data to be passed to the template.
	 * @param array $settings Widget settings.
	 *
	 * @return string
	 */
	public function display_content( $data, $settings ) {
		$data['content'] = '';
		$this->settings  = $settings;
		$data            = wp_parse_args( $this->get_template_args(), $data );
		$data            = apply_filters( 'rtsb/general/hero_slider/args/' . $data['unique_name'], $data );

		if ( ! empty( $data['sliders'] ) ) {
			foreach ( $data['sliders'] as  $slider ) {
				$data['slider']           = $slider;
				$data['repeater_id']      = $slider['_id'];
				$data['slider_title_tag'] = $slider['slider_title_html_tag'] ?? 'h2';
				$data['slider_title']     = $slider['slider_title'] ?? '';
				$data['slider_title2']    = $slider['slider_title2'] ?? '';
				$data['slider_subtitle']  = $slider['slider_subtitle'] ?? '';
				$data['slider_content']   = $slider['slider_content'] ?? '';
				$data['slider_img_type']  = $slider['slider_img_type'] ?? '';
				$data['btn_text']         = $slider['button_text'] ?? '';
				$data['btn_link']         = $this->render_link_attributes( 'btn_' . $slider['_id'], $slider['button_link'], 'button-link' );
				$data['content']         .= Fns::load_template( $data['template'], $data, true );
			}
			return $this->addon_view( $data, $settings );
		} else {
			return '<p>' . esc_html__( 'Please add a slider items.', 'shopbuilder-pro' ) . '</p>';
		}
	}

	/**
	 * Retrieves template args based on widget settings.
	 *
	 * @return array
	 */
	private function get_template_args() {
		return [
			'sliders'                  => RenderHelpers::get_data( $this->settings, 'slider_items', [] ),
			'wrapper_classes'          => $this->get_wrapper_classes(),
			'display_title'            => ! empty( $this->settings['display_title'] ),
			'display_title2'           => ! empty( $this->settings['display_title2'] ),
			'display_subtitle'         => ! empty( $this->settings['display_subtitle'] ),
			'display_content'          => ! empty( $this->settings['display_content'] ),
			'display_button'           => ! empty( $this->settings['display_button'] ),
			'display_button_icon'      => ! empty( $this->settings['display_btn_icon'] ),
			'parallax_effect'          => 'parallax' === $this->settings['slider_effect'],
			'parallax_animation'       => 'rtFadeInUp',
			'image_animation_duration' => '1s',
			'animation_duration'       => '0.5s',
			'image_ani_delay'          => '1000ms',
			'subtitle_ani_delay'       => '1300ms',
			'title_ani_delay'          => '1500ms',
			'title2_ani_delay'         => '1700ms',
			'content_ani_delay'        => '1900ms',
			'button_ani_delay'         => '2100ms',
			'render'                   => $this,
		];
	}

	/**
	 * Function to render slider image.
	 *
	 * @param array $slider_image_attr slider image attributes.
	 *
	 * @return string
	 */
	public function render_slider_image( $slider_image_attr ) {
		$img_html = '';
		if ( ! empty( $slider_image_attr['slider_bg_foreground_img'] ) ) {
			$c_image_size         = RenderHelpers::get_data( $slider_image_attr, 'foreground_img_dimension', [] );
			$c_image_size['crop'] = RenderHelpers::get_data( $slider_image_attr, 'foreground_img_crop', [] );
			$c_image_size         = ! empty( $c_image_size ) && is_array( $c_image_size ) ? $c_image_size : [];
			$image_id             = ! empty( $slider_image_attr['slider_bg_foreground_img']['id'] ) ? $slider_image_attr['slider_bg_foreground_img']['id'] : $slider_image_attr['slider_bg_foreground_img'];
			$img_html            .= Fns::get_product_image_html(
				'',
				null,
				RenderHelpers::get_data( $slider_image_attr, 'foreground_img_size', 'full' ),
				$image_id,
				$c_image_size
			);
		}

		return $img_html;
	}

	/**
	 * Retrieves wrapper class.
	 *
	 * @return string
	 */
	private function get_wrapper_classes() {
		$classes = [
			'rtsb-slide-item',
			'swiper-slide',
			'animated',
		];
		if ( ! empty( $this->settings['slider_effect'] ) ) {
			$classes[] = $this->settings['slider_effect'];
		}
		return implode( ' ', array_filter( $classes ) );
	}
}
