<?php
/**
 * Hero Slider class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\HeroSlider;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * ImageHotspots class.
 *
 * @package RadiusTheme\SBPRO
 */
class HeroSlider extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Hero Slider', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-hero-slider';

		parent::__construct( $data, $args );

		$this->rtsb_category = 'rtsb-shopbuilder-general';
	}

	/**
	 * Whether the element returns dynamic content.
	 *
	 * @return bool
	 */
	protected function is_dynamic_content(): bool {
		return false;
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		return Controls::content( $this );
	}

	/**
	 * Style dependencies.
	 *
	 * @return array
	 */
	public function get_style_depends(): array {
		return [
			'rtsb-general-addons',
		];
	}


	/**
	 * Addon Render.
	 *
	 * @return void
	 */
	protected function render() {
		$settings         = $this->get_settings_for_display();
		$container_class  = 'hero-slider-item';
		$container_class .= ! empty( $settings['number_dot_pagination'] ) ? ' has-number-dot-pagination' : '';
		switch ( $settings['layout_style'] ) {
			case 'rtsb-hero-slider-layout4':
				$template = 'layout4';
				break;
			case 'rtsb-hero-slider-layout3':
				$template = 'layout3';
				break;
			case 'rtsb-hero-slider-layout2':
				$template = 'layout2';
				break;
			default:
				$template = 'layout1';
				break;
		}
		$template = apply_filters( 'rtsb/general_widget/hero_slider/template', $template, $settings );
		$data     = [
			'template'        => 'elementor/general/hero-slider/' . $template,
			'id'              => $this->get_id(),
			'unique_name'     => $this->get_unique_name(),
			'layout'          => $settings['layout_style'],
			'settings'        => $settings,
			'is_carousel'     => true,
			'is_grid'         => true,
			'container_class' => $container_class,
			'content_class'   => 'rtsb-hero-slider',
		];

		// Render initialization.
		$this->theme_support();

		// Call the template rendering method.
		Fns::print_html( ( new Render() )->display_content( $data, $settings ), true );
		$this->edit_mode_script();
		$this->editor_hero_slider_script();
		$this->theme_support( 'render_reset' );
	}
	/**
	 * Elementor Edit mode need some extra js for isotop reinitialize
	 *
	 * @return void
	 */
	public function editor_hero_slider_script() {
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$selector = $this->get_unique_selector() . ' .rtsb-hero-carousel-slider';
			?>
			<script>
				jQuery('<?php echo esc_attr( $selector ); ?>').rtsb_hero_slider();
			</script>
			<?php
		}
	}
}
