<?php
/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\HeroSlider;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SBPRO\Elementor\Helpers\AddonHelpersPro;
use RadiusTheme\SB\Elementor\Widgets\Controls\StyleFields;
use Elementor\Utils;
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */
class Controls {
	/**
	 * Content section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function content( $obj ) {
		return array_merge(
			self::layout( $obj ),
			self::general_settings( $obj ),
			self::slider_items( $obj ),
			self::slider_settings( $obj ),
			self::slider_item_style( $obj ),
			self::subtitle_style( $obj ),
			self::title_style( $obj ),
			self::title2_style( $obj ),
			self::content_style( $obj ),
			self::button_style( $obj ),
			self::slider_buttons( $obj ),
		);
	}
	/**
	 * Preset section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function layout( $obj ) {
		$fields['sbp_hero_slider_layout']     = $obj->start_section(
			esc_html__( 'Layout', 'shopbuilder-pro' ),
			'content'
		);
		$fields['layout_note']                = $obj->el_heading( esc_html__( 'Predefined Layouts', 'shopbuilder-pro' ) );
		$fields['layout_style']               = [
			'type'    => 'rtsb-image-selector',
			'options' => AddonHelpersPro::general_widgets_hero_slider(),
			'default' => 'rtsb-hero-slider-layout1',
		];
		$fields['sbp_hero_slider_layout_end'] = $obj->end_section();
		return $fields;
	}

	public static function general_settings( $obj ) {
		$fields['general_settings_sec_start'] = $obj->start_section(
			esc_html__( 'General Settings', 'shopbuilder-pro' ),
			'content',
			[],
		);
		$fields['display_title']              = [
			'label'       => esc_html__( 'Show Slider Title', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show slider title.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'default'     => 'yes',
			'separator'   => 'before',
		];
		$fields['display_title2']             = [
			'label'       => esc_html__( 'Show Slider Title 2', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show slider title 2.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'default'     => 'yes',
			'separator'   => 'before',
			'condition'   => [
				'layout_style' => [ 'rtsb-hero-slider-layout2','rtsb-hero-slider-layout4' ],
			],
		];
		$fields['display_subtitle']           = [
			'label'       => esc_html__( 'Show Slider Subtitle', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show slider subtitle.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'default'     => 'yes',
			'separator'   => 'before',
		];
		$fields['display_content']            = [
			'label'       => esc_html__( 'Show Slider Content', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show slider content.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'default'     => 'yes',
			'separator'   => 'before',
		];
		$fields['display_button']             = [
			'label'       => esc_html__( 'Show Slider Button', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show slider button.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'default'     => 'yes',
			'separator'   => 'before',
		];
		$fields['display_btn_icon']           = [
			'label'       => esc_html__( 'Show Button Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show button icon.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'default'     => 'yes',
			'separator'   => 'before',
			'condition'   => [
				'display_button' => 'yes',
			],
		];
		$fields['general_settings_sec_end']   = $obj->end_section();

		return $fields;
	}
	/**
	 * Team items
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function slider_items( $obj ) {
		$fields['slider_items_settings_sec_start'] = $obj->start_section(
			esc_html__( 'Slider Items', 'shopbuilder-pro' ),
			'content',
			[],
		);
		$repeater_fields                           = [
			'img_heading'                          => $obj->el_heading( esc_html__( 'Image', 'shopbuilder-pro' ) ),
			'slider_img_type'                      => [
				'label'       => esc_html__( 'Slider Image Type', 'shopbuilder-pro' ),
				'type'        => 'select',
				'options'     => [
					'background' => esc_html__( 'Background', 'shopbuilder-pro' ),
					'foreground' => esc_html__( 'Foreground', 'shopbuilder-pro' ),
				],
				'default'     => 'background',
				'label_block' => true,
			],
			'slider_bg'                            => [
				'type'           => 'background',
				'mode'           => 'group',
				'selector'       => '{{WRAPPER}} {{CURRENT_ITEM}}:not(.parallax) .rtsb-hero-slider-item,{{WRAPPER}} {{CURRENT_ITEM}} .rtsb-parallax-slider-image',
				'types'          => [ 'classic','gradient' ],
				'fields_options' => [
					'background' => [
						'label' => esc_html__( 'Item Background', 'shopbuilder' ),
					],
				],
				'default'        => [ 'classic' ],
				'condition'      => [
					'slider_img_type' => 'background',
				],
			],
			'slider_bg_foreground_color'           => [
				'label'     => esc_html__( 'Slider Foreground Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}.parallax .rtsb-hero-slider-item' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} {{CURRENT_ITEM}}  .rtsb-hero-slider-item' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'slider_img_type' => 'foreground',
				],
			],
			'slider_bg_foreground_img'             => [
				'label'     => esc_html__( 'Slider Foreground Image', 'shopbuilder-pro' ),
				'type'      => 'media',
				'default'   => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'slider_img_type' => 'foreground',
				],
			],
			'custom_img_custom_dimension_note'     => [
				'type'      => 'html',
				'raw'       => sprintf(
					'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
					esc_html__( 'Please note that,This image size will not working on parallax slider effect.', 'shopbuilder-pro' )
				),
				'condition' => [
					'slider_img_type' => 'foreground',
				],
			],
			'foreground_img_size'                  => [
				'type'            => 'select2',
				'label'           => esc_html__( 'Select Image Size', 'shopbuilder-pro' ),
				'description'     => esc_html__( 'Please select the image size.', 'shopbuilder-pro' ),
				'options'         => Fns::get_image_sizes(),
				'default'         => 'full',
				'label_block'     => true,
				'content_classes' => 'elementor-descriptor',
				'condition'       => [
					'slider_img_type' => 'foreground',
				],
			],
			'foreground_img_dimension'             => [
				'type'        => 'image-dimensions',
				'label'       => esc_html__( 'Enter Custom Image Size', 'shopbuilder-pro' ),
				'label_block' => true,
				'default'     => [
					'width'  => 400,
					'height' => 400,
				],
				'condition'   => [
					'foreground_img_size' => 'rtsb_custom',
					'slider_img_type'     => 'foreground',
				],
			],
			'foreground_img_crop'                  => [
				'type'        => 'select2',
				'label'       => esc_html__( 'Image Crop', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please click on "Apply" to update the image.', 'shopbuilder-pro' ),
				'options'     => [
					'soft' => esc_html__( 'Soft Crop', 'shopbuilder-pro' ),
					'hard' => esc_html__( 'Hard Crop', 'shopbuilder-pro' ),
				],
				'default'     => 'hard',
				'condition'   => [
					'foreground_img_size' => 'rtsb_custom',
					'slider_img_type'     => 'foreground',
				],
			],
			'foreground_img_custom_dimension_note' => [
				'type'      => 'html',
				'raw'       => sprintf(
					'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
					esc_html__( 'Please note that, if you enter image size larger than the actual image itself, the image sizes will fallback to the full image dimension.', 'shopbuilder-pro' )
				),
				'condition' => [
					'foreground_img_size' => 'rtsb_custom',
					'slider_img_type'     => 'foreground',
				],
			],
			'img_position'                         => $obj->el_heading(
				esc_html__( 'Image Position', 'shopbuilder-pro' ),
				'',
				[],
				[
					'slider_img_type' => 'foreground',
				]
			),
			'img_bottom_position'                  => [
				'type'       => 'slider',
				'mode'       => 'responsive',
				'label'      => esc_html__( 'Image Position', 'shopbuilder-pro' ),
				'size_units' => [ 'px','%' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} {{CURRENT_ITEM}}.parallax .rtsb-parallax-slider-image' => 'bottom:{{SIZE}}{{UNIT}};',
				],
				'condition'  => [
					'slider_img_type' => 'foreground',
				],
			],
			'img_position_custom_dimension_note'   => [
				'type'      => 'html',
				'raw'       => sprintf(
					'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
					esc_html__( 'Please note that, This image position settings will be working on Parallax slider effect with image foreground image type', 'shopbuilder-pro' )
				),
				'condition' => [
					'slider_img_type' => 'foreground',
				],
			],
			'content_heading'                      => $obj->el_heading( esc_html__( 'Content', 'shopbuilder-pro' ) ),
			'slider_title_html_tag'                => [
				'label'       => esc_html__( 'Slider Title Tag', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please select the name tag.', 'shopbuilder-pro' ),
				'type'        => 'select',
				'options'     => ControlHelper::heading_tags(),
				'default'     => 'h2',
				'label_block' => true,
			],
			'slider_title'                         => [
				'label'       => esc_html__( 'Slider Title', 'shopbuilder-pro' ),
				'type'        => 'text',
				'label_block' => true,
				'default'     => esc_html__( 'Apple Air Pods', 'shopbuilder-pro' ),
				'separator'   => 'before-short',
			],
			'slider_title2'                        => [
				'label'       => esc_html__( 'Slider Title 2', 'shopbuilder-pro' ),
				'type'        => 'text',
				'label_block' => true,
				'default'     => esc_html__( 'Pro Max Wireless', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Slider Title 2 will not show all slider layouts', 'shopbuilder-pro' ),
			],
			'slider_subtitle'                      => [
				'label'       => esc_html__( 'Slider Subtitle', 'shopbuilder-pro' ),
				'type'        => 'textarea',
				'label_block' => true,
				'default'     => esc_html__( 'Now In Trending', 'shopbuilder-pro' ),
				'separator'   => 'before-short',
			],
			'slider_content'                       => [
				'label'       => esc_html__( 'Slider Content', 'shopbuilder-pro' ),
				'type'        => 'wysiwyg',
				'label_block' => true,
				'default'     => esc_html__(
					'Borem ipsum dolor sit amet, vim id assentior moderatius nelig endis iuvaret est per et inani alienum.',
					'shopbuilder-pro'
				),
				'separator'   => 'before-short',
			],
			'link_heading'                         => $obj->el_heading( esc_html__( 'Slider Button', 'shopbuilder-pro' ), 'before-short' ),
			'button_text'                          => [
				'label'       => esc_html__( 'Button Text', 'shopbuilder-pro' ),
				'type'        => 'text',
				'label_block' => true,
				'default'     => esc_html__( 'Shop Now', 'shopbuilder-pro' ),
			],
			'button_link'                          => [
				'label' => esc_html__( 'Button Link', 'shopbuilder-pro' ),
				'type'  => 'url',
			],
			'btn_icon'                             => [
				'label'   => esc_html__( 'Button Icon', 'shopbuilder' ),
				'type'    => 'icons',
				'default' => [
					'value'   => 'fas fa-arrow-right',
					'library' => 'fa-solid',
				],
			],

		];
		$fields['slider_items'] = [
			'type'        => 'repeater',
			'label'       => esc_html__( 'Add Slider Items', 'shopbuilder-pro' ),
			'mode'        => 'repeater',
			'title_field' => '{{{ slider_title }}}',
			'separator'   => 'after',
			'fields'      => $repeater_fields,
			'default'     => [
				[
					'slider_title'    => esc_html__( 'Apple Air Pods', 'shopbuilder-pro' ),
					'slider_title2'   => __( 'Pro Max Wireless', 'shopbuilder-pro' ),
					'slider_subtitle' => __( 'Now In Trending', 'shopbuilder-pro' ),
					'slider_content'  => esc_html__( 'Borem ipsum dolor sit amet, vim id assentior moderatius nelig endis iuvaret est per et inani alienum.', 'shopbuilder-pro' ),
				],
				[
					'slider_title'    => esc_html__( 'Apple Air Pods', 'shopbuilder-pro' ),
					'slider_title2'   => __( 'Pro Max Wireless', 'shopbuilder-pro' ),
					'slider_subtitle' => __( 'Now In Trending', 'shopbuilder-pro' ),
					'slider_content'  => esc_html__( 'Borem ipsum dolor sit amet, vim id assentior moderatius nelig endis iuvaret est per et inani alienum.', 'shopbuilder-pro' ),
				],
				[
					'slider_title'    => esc_html__( 'Apple Air Pods', 'shopbuilder-pro' ),
					'slider_title2'   => __( 'Pro Max Wireless', 'shopbuilder-pro' ),
					'slider_subtitle' => __( 'Now In Trending', 'shopbuilder-pro' ),
					'slider_content'  => esc_html__( 'Borem ipsum dolor sit amet, vim id assentior moderatius nelig endis iuvaret est per et inani alienum.', 'shopbuilder-pro' ),
				],
				[
					'slider_title'    => esc_html__( 'Apple Air Pods', 'shopbuilder-pro' ),
					'slider_title2'   => __( 'Pro Max Wireless', 'shopbuilder-pro' ),
					'slider_subtitle' => __( 'Now In Trending', 'shopbuilder-pro' ),
					'slider_content'  => esc_html__( 'Borem ipsum dolor sit amet, vim id assentior moderatius nelig endis iuvaret est per et inani alienum.', 'shopbuilder-pro' ),
				],

			],
		];
		$fields['slider_items_settings_sec_end'] = $obj->end_section();
		return $fields;
	}
	/**
	 * Slider section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function slider_settings( $obj ) {

		$fields['slider_control_section'] = $obj->start_section(
			esc_html__( 'Slider Settings', 'shopbuilder-pro' ),
			'content'
		);

		$fields['slider_control_note'] = $obj->el_heading(
			esc_html__( 'Controls', 'shopbuilder-pro' ),
			'default'
		);
		$fields['slider_effect']       = [
			'type'    => 'select',
			'label'   => esc_html__( 'Slider Effect', 'shopbuilder-pro' ),
			'options' => [
				'slide'    => __( 'Slide', 'shopbuilder-pro' ),
				'fade'     => __( 'Fade', 'shopbuilder-pro' ),
				'parallax' => __( 'Parallax', 'shopbuilder-pro' ),
			],
			'default' => 'slide',
		];
		$fields['slider_nav']          = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Navigation Arrows', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider navigation arrows.', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['always_show_nav'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Always Show Arrows', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable always showing navigation arrows.', 'shopbuilder-pro' ),
			'condition'   => [ 'slider_nav' => [ 'yes' ] ],
		];

		$fields['slider_left_arrow_icon'] = [
			'label'       => esc_html__( 'Left Arrow Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the slider left arrow icon.', 'shopbuilder-pro' ),
			'type'        => 'icons',
			'default'     => [
				'value'   => 'fas fa-chevron-left',
				'library' => 'fa-solid',
			],
			'separator'   => 'default',
			'condition'   => [ 'slider_nav' => 'yes' ],
		];

		$fields['slider_right_arrow_icon'] = [
			'label'       => esc_html__( 'Right Arrow Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the slider right arrow icon.', 'shopbuilder-pro' ),
			'type'        => 'icons',
			'default'     => [
				'value'   => 'fas fa-chevron-right',
				'library' => 'fa-solid',
			],
			'condition'   => [ 'slider_nav' => 'yes' ],
		];

		$fields['slider_pagi'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Dot Pagination', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider dot pagination.', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['slider_pagi_type']      = [
			'type'      => 'select',
			'label'     => esc_html__( 'Pagination Type', 'shopbuilder-pro' ),
			'options'   => self::hero_slider_pagination_type(),
			'default'   => 'bullets',
			'condition' => [ 'slider_pagi' => 'yes' ],
		];
		$fields['number_dot_pagination'] = [
			'label'       => esc_html__( 'Number Pagination', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show number dot pagination.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'separator'   => 'before',
			'condition'   => [
				'slider_pagi'      => [ 'yes' ],
				'slider_pagi_type' => 'bullets',
			],
		];
		$fields['slider_dynamic_pagi']   = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Dynamic Pagination', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'It will keep only few bullets visible at the same time.', 'shopbuilder-pro' ),
			'condition'   => [
				'slider_pagi'      => 'yes',
				'slider_pagi_type' => 'bullets',
			],
		];
		$fields['slider_loop']           = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Infinite Loop', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider infinite loop.', 'shopbuilder-pro' ),
			'condition'   => [ 'tax_filter!' => [ 'yes' ] ],
		];

		$fields['slider_auto_height'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Auto Height', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider dynamic height.', 'shopbuilder-pro' ),
		];

		$fields['slider_lazy_load'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Image Lazy Load', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider image lazy load.', 'shopbuilder-pro' ),
		];

		$fields['slide_speed'] = [
			'type'        => 'number',
			'label'       => esc_html__( 'Slide Speed (in ms)', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please enter the duration of transition between slides (in ms).', 'shopbuilder-pro' ),
			'default'     => 2000,
			'separator'   => 'default elementor-control-separator-after',
		];

		$fields['slider_autoplay_note'] = $obj->el_heading(
			esc_html__( 'Autoplay', 'shopbuilder-pro' ),
			'before'
		);

		$fields['slide_autoplay'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Autoplay?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider autoplay.', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['pause_hover'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Pause on Mouse Hover?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider autoplay pause on mouse hover.', 'shopbuilder-pro' ),
			'default'     => 'yes',
			'condition'   => [ 'slide_autoplay' => 'yes' ],
		];

		$fields['autoplay_timeout'] = [
			'type'        => 'number',
			'label'       => esc_html__( 'Autoplay Delay (in ms)', 'shopbuilder-pro' ),
			'default'     => 5000,
			'description' => esc_html__( 'Please select autoplay interval delay (in ms).', 'shopbuilder-pro' ),
			'condition'   => [ 'slide_autoplay' => 'yes' ],
		];

		$fields['slider_control_section_end'] = $obj->end_section();

		return $fields;
	}
	/**
	 * Slider Box style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function slider_item_style( $obj ) {

		$fields['slider_item_sec_start']       = $obj->start_section(
			esc_html__( 'Slider Item', 'shopbuilder-pro' ),
			'style',
		);
		$fields['slider_content_alignment']    = [
			'mode'      => 'responsive',
			'type'      => 'choose',
			'label'     => esc_html__( 'Element Alignment', 'shopbuilder' ),
			'options'   => ControlHelper::alignment(),
			'separator' => 'before',
			'selectors' => [
				$obj->selectors['slider_item']['alignment'] => 'text-align: {{VALUE}};' ,
				$obj->selectors['slider_item']['justify'] => 'justify-content: {{VALUE}};',
			],
		];
		$fields['slider_items_dimension_note'] = $obj->el_heading( esc_html__( 'Dimension', 'shopbuilder-pro' ) );
		$fields['slider_item_height']          = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Slider Height', 'shopbuilder-pro' ),
			'size_units' => [ '%', 'px' ],
			'range'      => [
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
				'px' => [
					'min' => 200,
					'max' => 1200,
				],
			],
			'selectors'  => [
				$obj->selectors['slider_item']['height'] => 'height: {{SIZE}}{{UNIT}};',
			],
		];
		$fields['slider_item_container_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Container Width', 'shopbuilder-pro' ),
			'size_units' => [ '%', 'px' ],
			'range'      => [
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
				'px' => [
					'min' => 0,
					'max' => 1920,
				],

			],
			'selectors'  => [
				$obj->selectors['slider_item']['container_width'] => 'max-width: {{SIZE}}{{UNIT}};',
			],
			'condition'  => [
				'layout_style!' => [ 'rtsb-hero-slider-layout4' ],
			],
		];
		$fields['slider_item_spacing_note']  = $obj->el_heading( esc_html__( 'Spacing', 'shopbuilder-pro' ), 'before' );
		$fields['slider_item_padding']       = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [
				$obj->selectors['slider_item']['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$fields['slider_item_border_note']   = $obj->el_heading( esc_html__( 'Border', 'shopbuilder-pro' ), 'before' );
		$fields['slider_items_radius']       = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [
				$obj->selectors['slider_item']['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$fields['slider_items_spacing_note'] = $obj->el_heading( esc_html__( 'Background Overlay', 'shopbuilder-pro' ) );
		$fields['slider_item_overlay_color'] = [
			'label'          => esc_html__( 'Background Type', 'shopbuilder' ),
			'type'           => 'background',
			'mode'           => 'group',
			'exclude'        => [ 'image' ], // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_exclude
			'selector'       => $obj->selectors['slider_item']['bg_overlay_color'],
			'fields_options' => [
				'background' => [
					'label' => esc_html__( 'Overlay Background', 'shopbuilder' ),
				],
			],
		];
		$fields['slider_item_sec_end']       = $obj->end_section();

		return $fields;
	}
	/**
	 * SubTitle style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function subtitle_style( $obj ) {
		$condition     = [
			'display_subtitle' => 'yes',
		];
		$css_selectors = $obj->selectors['subtitle_style'];
		$title         = esc_html__( 'SubTitle', 'shopbuilder-pro' );
		$selectors     = [
			'typography'     => $css_selectors['typography'],
			'border'         => $css_selectors['border'],
			'color'          => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'bg_color'       => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'subtitle_width' => [ $css_selectors['subtitle_width'] => 'min-width: {{SIZE}}{{UNIT}};' ],
			'margin'         => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;' ],
			'padding'        => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;' ],
			'border_radius'  => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;' ],
		];

		$fields = ControlHelper::general_elementor_style( 'subtitle_style', $title, $obj, $condition, $selectors );
		unset(
			$fields['subtitle_style_alignment'],
			$fields['subtitle_style_color_tabs'],
			$fields['subtitle_style_color_tab'],
			$fields['subtitle_style_color_tab_end'],
			$fields['subtitle_style_hover_color_tab'],
			$fields['subtitle_style_hover_color'],
			$fields['subtitle_style_hover_bg_color'],
			$fields['subtitle_style_border_hover_color'],
			$fields['subtitle_style_hover_color_tab_end'],
			$fields['subtitle_style_color_tabs_end'],
		);
		$extra_controls['subtitle_border_radius'] = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px' ],
			'selectors'  => $selectors['border_radius'],
		];
		$fields                                   = Fns::insert_controls( 'subtitle_style_spacing_note', $fields, $extra_controls );
		$extra_controls2['subtitle_width']        = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Subtitle Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => 10,
					'max' => 600,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['subtitle_width'],
			'condition'  => [
				'layout_style' => [ 'rtsb-hero-slider-layout3' ],
			],
		];
		$fields                                   = Fns::insert_controls( 'subtitle_style_spacing_note', $fields, $extra_controls2, true );
		return $fields;
	}
	/**
	 * Title style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function title_style( $obj ) {
		$condition     = [
			'display_title' => 'yes',
		];
		$css_selectors = $obj->selectors['title_style'];
		$title         = esc_html__( 'Title', 'shopbuilder-pro' );
		$selectors     = [
			'typography'              => $css_selectors['typography'],
			'shape_position'          => [ $css_selectors['shape_position'] => 'left: {{SIZE}}{{UNIT}};' ],
			'shape_vertical_position' => [ $css_selectors['shape_vertical_position'] => 'bottom: {{SIZE}}{{UNIT}};' ],
			'shape_width'             => [ $css_selectors['shape_width'] => 'width: {{SIZE}}{{UNIT}};' ],
			'shape_height'            => [ $css_selectors['shape_height'] => 'height: {{SIZE}}{{UNIT}};' ],
			'color'                   => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'title_shape_color'       => [ $css_selectors['title_shape_color'] => 'background-color: {{VALUE}};' ],
			'margin'                  => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;' ],
		];

		$fields = ControlHelper::general_elementor_style( 'title_style', $title, $obj, $condition, $selectors );
		unset(
			$fields['title_style_alignment'],
			$fields['rtsb_el_title_style_border'],
			$fields['title_style_border_note'],
			$fields['title_style_color_tabs'],
			$fields['title_style_color_tab'],
			$fields['title_style_color_tab_end'],
			$fields['title_style_hover_color_tab'],
			$fields['title_style_bg_color'],
			$fields['title_style_hover_color'],
			$fields['title_style_hover_bg_color'],
			$fields['title_style_border_hover_color'],
			$fields['title_style_padding'],
			$fields['title_style_hover_color_tab_end'],
			$fields['title_style_color_tabs_end'],
		);
		$extra_fields['title_shape_color']            = [
			'type'      => 'color',
			'label'     => esc_html__( 'Title Shape Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['title_shape_color'],
			'condition' => [
				'layout_style' => [ 'rtsb-hero-slider-layout4' ],
			],
		];
		$fields                                       = Fns::insert_controls( 'title_style_color', $fields, $extra_fields, true );
		$extra_controls2['title_shape_position_note'] = $obj->el_heading(
			esc_html__( 'Shape', 'shopbuilder-pro' ),
			'',
			[],
			[
				'layout_style' => [ 'rtsb-hero-slider-layout4' ],
			]
		);
		$extra_controls2['shape_width']               = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Shape Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['shape_width'],
			'condition'  => [
				'layout_style' => [ 'rtsb-hero-slider-layout4' ],
			],
		];
		$extra_controls2['shape_height']              = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Shape Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['shape_height'],
			'condition'  => [
				'layout_style' => [ 'rtsb-hero-slider-layout4' ],
			],
		];
		$extra_controls2['shape_position']            = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Shape Horizontal Position', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['shape_position'],
			'condition'  => [
				'layout_style' => [ 'rtsb-hero-slider-layout4' ],
			],
		];
		$extra_controls2['shape_vertical_position']   = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Shape Vertical Position', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => -600,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['shape_vertical_position'],
			'condition'  => [
				'layout_style' => [ 'rtsb-hero-slider-layout4' ],
			],
		];
		$fields                                       = Fns::insert_controls( 'title_style_margin', $fields, $extra_controls2, true );
		return $fields;
	}
	/**
	 * Title2 style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function title2_style( $obj ) {
		$condition     = [
			'layout_style'   => [ 'rtsb-hero-slider-layout2' ],
			'display_title2' => 'yes',
		];
		$css_selectors = $obj->selectors['title_style2'];
		$title         = esc_html__( 'Title 2', 'shopbuilder-pro' );
		$selectors     = [
			'typography' => $css_selectors['typography'],
			'color'      => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'margin'     => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;' ],
		];

		$fields = ControlHelper::general_elementor_style( 'title_style2', $title, $obj, $condition, $selectors );
		unset(
			$fields['title_style2_alignment'],
			$fields['rtsb_el_title_style2_border'],
			$fields['title_style2_border_note'],
			$fields['title_style2_color_tabs'],
			$fields['title_style2_color_tab'],
			$fields['title_style2_color_tab_end'],
			$fields['title_style2_hover_color_tab'],
			$fields['title_style2_bg_color'],
			$fields['title_style2_hover_color'],
			$fields['title_style2_hover_bg_color'],
			$fields['title_style2_border_hover_color'],
			$fields['title_style2_padding'],
			$fields['title_style2_hover_color_tab_end'],
			$fields['title_style2_color_tabs_end'],
		);
		return $fields;
	}
	/**
	 * Title2 style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function content_style( $obj ) {
		$condition     = [
			'display_content' => 'yes',
		];
		$css_selectors = $obj->selectors['content_style'];
		$title         = esc_html__( 'Content', 'shopbuilder-pro' );
		$selectors     = [
			'typography' => $css_selectors['typography'],
			'color'      => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'margin'     => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;' ],
		];

		$fields = ControlHelper::general_elementor_style( 'content_style', $title, $obj, $condition, $selectors );
		unset(
			$fields['content_style_alignment'],
			$fields['rtsb_el_content_style_border'],
			$fields['content_style_border_note'],
			$fields['content_style_color_tabs'],
			$fields['content_style_color_tab'],
			$fields['content_style_color_tab_end'],
			$fields['content_style_hover_color_tab'],
			$fields['content_style_bg_color'],
			$fields['content_style_hover_color'],
			$fields['content_style_hover_bg_color'],
			$fields['content_style_border_hover_color'],
			$fields['content_style_padding'],
			$fields['content_style_hover_color_tab_end'],
			$fields['content_style_color_tabs_end'],
		);
		return $fields;
	}
	/**
	 * Button style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function button_style( $obj ) {
		$condition     = [
			'display_button' => 'yes',
		];
		$css_selectors = $obj->selectors['button_style'];
		$title         = esc_html__( ' Button', 'shopbuilder-pro' );
		$selectors     = [
			'typography'         => $css_selectors['typography'],
			'icon_size'          => [
				$css_selectors['icon_size']['font_size'] => 'font-size: {{SIZE}}{{UNIT}};',
				$css_selectors['icon_size']['svg']       => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
			],
			'icon_gap'           => [ $css_selectors['icon_gap'] => 'gap: {{SIZE}}{{UNIT}};' ],
			'btn_width'          => [ $css_selectors['btn_width'] => 'min-width: {{SIZE}}{{UNIT}};' ],
			'btn_height'         => [ $css_selectors['btn_height'] => 'height: {{SIZE}}{{UNIT}};' ],
			'color'              => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'bg_color'           => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'hover_color'        => [ $css_selectors['hover_color'] => 'color: {{VALUE}};' ],
			'hover_bg_color'     => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}};' ],
			'border'             => $css_selectors['border'],
			'box_shadow'         => $css_selectors['box_shadow'],
			'border_hover_color' => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'padding'            => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
			'margin'             => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
			'border_radius'      => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
		];

		$fields = ControlHelper::general_elementor_style( 'button_style', $title, $obj, $condition, $selectors );
		unset(
			$fields['button_style_alignment'],
		);
		$extra_controls['button_style_border_radius'] = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px' ],
			'selectors'  => $selectors['border_radius'],
		];
		$fields                                       = Fns::insert_controls( 'button_style_spacing_note', $fields, $extra_controls );
		$extra_controls2['button_style_btn_width']    = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Button Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => 10,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['btn_width'],
		];
		$extra_controls2['button_style_btn_height']   = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Button Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => 10,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['btn_height'],
		];

		$extra_controls2['button_style_icon_size']  = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['icon_size'],
			'condition'  => [
				'display_btn_icon' => 'yes',
			],
		];
		$extra_controls2['button_style_icon_gap']   = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Icon Gap', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['icon_gap'],
			'condition'  => [
				'display_btn_icon' => 'yes',
			],
		];
		$extra_controls2['button_style_box_shadow'] = [
			'type'     => 'box-shadow',
			'mode'     => 'group',
			'label'    => esc_html__( 'Box Shadow', 'shopbuilder-pro' ),
			'selector' => $selectors['box_shadow'],
		];
		$fields                                     = Fns::insert_controls( 'button_style_spacing_note', $fields, $extra_controls2, true );

		return $fields;
	}
	/**
	 * Slider Button section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function slider_buttons( $obj ) {
		$slider_btn_settings = StyleFields::slider_buttons( $obj );

		$extra_controls['slider_buttons_arrow_position_note'] = $obj->el_heading(
			esc_html__( 'Arrow Position', 'shopbuilder-pro' ),
			'',
			[],
			[
				'slider_nav' => [ 'yes' ],
			]
		);
		$extra_controls['slider_buttons_arrow_position1']     = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Arrow Position 1', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => -1000,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				$obj->selectors['slider_item']['arrow_position1'] => ' --rtsb-nav-horizontal-position: {{SIZE}}{{UNIT}};',
			],
			'condition'  => [
				'slider_nav' => [ 'yes' ],
			],
		];
		$extra_controls['slider_buttons_arrow_position2']     = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Arrow Position 2', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => -1000,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				$obj->selectors['slider_item']['arrow_position2'] => ' --rtsb-nav-vertical-position: {{SIZE}}{{UNIT}};',
			],
			'condition'  => [
				'slider_nav' => [ 'yes' ],
			],
		];
		$extra_controls['slider_buttons_dot_position_note']   = $obj->el_heading(
			esc_html__( 'Dot Position', 'shopbuilder-pro' ),
			'',
			[],
			[
				'slider_pagi' => [ 'yes' ],
			]
		);
		$extra_controls['slider_buttons_dot_position1']       = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Dot Position 1', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => -1000,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				$obj->selectors['slider_item']['dot_position1'] => ' --rtsb-dot-horizontal-position: {{SIZE}}{{UNIT}};',
			],
			'condition'  => [
				'slider_pagi' => [ 'yes' ],
			],
		];
		$extra_controls['slider_buttons_dot_position2']       = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Dot Position 2', 'shopbuilder-pro' ),
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => -1000,
					'max' => 1000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				$obj->selectors['slider_item']['dot_position2'] => ' --rtsb-dot-vertical-position: {{SIZE}}{{UNIT}};',
			],
			'condition'  => [
				'slider_pagi' => [ 'yes' ],
			],
		];
		$slider_btn_settings                                  = Fns::insert_controls( 'slider_buttons_wrapper_padding', $slider_btn_settings, $extra_controls, true );
		$extra_fields2['number_separator_color']              = [
			'type'      => 'color',
			'label'     => esc_html__( 'Separator Color', 'shopbuilder-pro' ),
			'selectors' => [
				$obj->selectors['slider_buttons']['number_separator_color'] => 'background-color:{{VALUE}}',
			],
			'condition' => [
				'slider_pagi'           => [ 'yes' ],
				'number_dot_pagination' => 'yes',
			],
		];
		$slider_btn_settings                                  = Fns::insert_controls( 'slider_buttons_color', $slider_btn_settings, $extra_fields2, true );
		$slider_btn_settings['slider_buttons_dot_width']['condition']['number_dot_pagination!']   = 'yes';
		$slider_btn_settings['slider_buttons_dot_height']['condition']['number_dot_pagination!']  = 'yes';
		$slider_btn_settings['slider_buttons_dot_spacing']['condition']['number_dot_pagination!'] = 'yes';
		$extra_fields3['number_dot_height'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Wrapper Height', 'shopbuilder-pro' ),
			'mode'       => 'responsive',
			'size_units' => [ 'px','%' ],
			'range'      => [
				'px' => [
					'min' => 20,
					'max' => 600,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				$obj->selectors['slider_buttons']['number_dot_height'] => 'min-height:{{SIZE}}{{UNIT}}',
			],
			'condition'  => [
				'slider_pagi'           => [ 'yes' ],
				'number_dot_pagination' => 'yes',
			],
		];
		$slider_btn_settings                = Fns::insert_controls( 'slider_buttons_dot_size_note', $slider_btn_settings, $extra_fields3, true );
		 return $slider_btn_settings;
	}

	public static function hero_slider_pagination_type() {
		return apply_filters(
			'rtsb/hero_slider/pagination_type',
			[
				'bullets'  => __( 'Bullet', 'shopbuilder-pro' ),
				'fraction' => __( 'Fraction', 'shopbuilder-pro' ),
			]
		);
	}
}
