<?php
/**
 * CouponList class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\CouponList;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Modules\SmartCoupons\SmartCouponsFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * CouponList class.
 *
 * @package RadiusTheme\SBPRO
 */
class CouponList extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Coupon List', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-coupon-list';

		parent::__construct( $data, $args );

		$this->rtsb_category = 'rtsb-shopbuilder-general';
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		return array_merge(
			Controls::content( $this ),
			Controls::style( $this )
		);
	}

	/**
	 * Style dependencies.
	 *
	 * @return array
	 */
	public function get_style_depends(): array {
		return [
			'rtsb-general-addons',
		];
	}

	/**
	 * Script dependencies.
	 *
	 * @return array
	 */
	public function get_script_depends(): array {
		return [
			'rtsb-tippy',
		];
	}

	/**
	 * Addon Render.
	 *
	 * @return void
	 */
	protected function render() {
		if ( ! Fns::is_module_active( 'smart_coupons' ) ) {
			ob_start();
			FnsPro::custom_notice( esc_html__( 'Please activate Smart Coupons module to use \'Coupon List\' Widget.', 'shopbuilder-pro' ) );

			Fns::print_html( ob_get_clean() );

			return;
		}

		$settings = $this->get_settings_for_display();

		switch ( $settings['layout'] ) {
			case 'rtsb-coupon-layout2':
				$template = 'layout2';
				break;
			case 'rtsb-coupon-layout3':
				$template = 'layout3';
				break;
			default:
				$template = 'layout1';
				break;
		}

		$template = apply_filters( 'rtsb/elements/general/template/coupon_list/', $template, $settings );
		$data     = [
			'template'        => 'elementor/general/coupon-list/' . $template,
			'id'              => $this->get_id(),
			'unique_name'     => $this->get_unique_name(),
			'is_grid'         => true,
			'layout'          => $settings['layout'] ?? 'rtsb-coupon-layout1',
			'container_class' => 'rtsb-coupon-grid' . ( ! empty( $settings['show_badge'] ) ? ' has-coupon-badge' : ' no-badge' ),
			'content_class'   => 'coupon-item',
			'settings'        => $settings,
			'container_attr'  => [
				'data-text'      => esc_html__( 'Click to copy Coupon Code', 'shopbuilder-pro' ),
				'data-post-text' => esc_html__( 'Copied!', 'shopbuilder-pro' ),
			],
		];

		// Render initialization.
		$this->theme_support();

		// Call the template rendering method.
		Fns::print_html( ( new Render() )->display_content( $data, $settings ), true );

		$this->theme_support( 'render_reset' );
	}
}
