<?php
/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\CouponList;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Controls class.
 *
 * @package RadiusTheme\SBPRO
 */
class Controls {
	/**
	 * Content section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function content( $obj ) {
		return array_merge(
			self::layout( $obj ),
			self::query( $obj ),
			self::settings( $obj ),
		);
	}

	/**
	 * Style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function style( $obj ) {
		return self::design( $obj );
	}

	/**
	 * Preset section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function layout( $obj ) {
		$fields['coupon_layout'] = $obj->start_section(
			esc_html__( 'Presentation', 'shopbuilder-pro' ),
			'content'
		);

		$fields['layout_note'] = $obj->el_heading( esc_html__( 'Predefined Layouts', 'shopbuilder-pro' ) );
		$fields['layout']      = [
			'type'    => 'rtsb-image-selector',
			'options' => apply_filters(
				'rtsb/elements/elementor/coupon_layouts',
				[
					'rtsb-coupon-layout1' => [
						'title' => esc_html__( 'Layout 1', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/coupons-layout-1.jpg' ) ),
					],
					'rtsb-coupon-layout2' => [
						'title' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/coupons-layout-2.jpg' ) ),
					],
					'rtsb-coupon-layout3' => [
						'title' => esc_html__( 'Layout 3', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/coupons-layout-3.jpg' ) ),
					],
				]
			),
			'default' => 'rtsb-coupon-layout1',
		];

		$fields['cols'] = [
			'type'           => 'select',
			'mode'           => 'responsive',
			'label'          => esc_html__( 'Number of Columns', 'shopbuilder-pro' ),
			'description'    => esc_html__( 'Please select the number of columns to show per row.', 'shopbuilder-pro' ),
			'options'        => ControlHelper::layout_columns(),
			'label_block'    => true,
			'render_type'    => 'template',
			'default'        => '0',
			'tablet_default' => '2',
			'mobile_default' => '1',
			'required'       => true,
			'selectors'      => [
				$obj->selectors['layout']['cols'] => 'grid-template-columns: repeat({{VALUE}}, minmax(0, 1fr));',
			],
		];

		unset(
			$fields['cols']['options'][5],
			$fields['cols']['options'][6],
			$fields['cols']['options'][7],
			$fields['cols']['options'][8],
		);

		$fields['coupon_layout_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Coupon query section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function query( $obj ) {
		$fields['coupon_query_layout'] = $obj->start_section(
			esc_html__( 'Coupon Query', 'shopbuilder-pro' ),
			'content'
		);

		$fields['coupon_note'] = [
			'type' => 'html',
			'raw'  => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
				esc_html__( 'Please note that, you need to enable the \'Show on frontend\' option in the Coupon \'General\' tab to see the coupons below.', 'shopbuilder-pro' )
			),
		];

		$fields['include_coupon'] = [
			'type'                 => 'rt-select2',
			'label'                => esc_html__( 'Include Coupons', 'shopbuilder-pro' ),
			'description'          => esc_html__( 'Please select the coupons to show. Leave it blank to include all coupons.', 'shopbuilder-pro' ),
			'source_name'          => 'post_type',
			'source_type'          => 'shop_coupon',
			'multiple'             => true,
			'label_block'          => true,
			'minimum_input_length' => 0,
		];

		$fields['exclude_coupon'] = [
			'type'                 => 'rt-select2',
			'label'                => esc_html__( 'Exclude Coupons', 'shopbuilder-pro' ),
			'description'          => esc_html__( 'Please select the coupons to show. Leave it blank to exclude none.', 'shopbuilder-pro' ),
			'source_name'          => 'post_type',
			'source_type'          => 'shop_coupon',
			'multiple'             => true,
			'label_block'          => true,
			'minimum_input_length' => 0,
		];

		$fields['filter_groups'] = [
			'type'                 => 'rt-select2',
			'label'                => esc_html__( 'Filter By Coupon Groups', 'shopbuilder-pro' ),
			'description'          => esc_html__( 'Select the groups you want to filter, Leave it blank for all groups.', 'shopbuilder-pro' ),
			'source_name'          => 'taxonomy',
			'source_type'          => 'rtsb_coupon_group',
			'multiple'             => true,
			'label_block'          => true,
			'minimum_input_length' => 0,
		];

		$fields['coupon_type'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Filter by Coupon Type', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Select the type of coupons you want to filter.', 'shopbuilder-pro' ),
			'options'     => [
				'all'                  => esc_html__( 'Show All Coupons', 'shopbuilder-pro' ),
				'percent'              => esc_html__( 'Percentage discount', 'shopbuilder-pro' ),
				'fixed_cart'           => esc_html__( 'Fixed cart discount', 'shopbuilder-pro' ),
				'fixed_product'        => esc_html__( 'Fixed product discount', 'shopbuilder-pro' ),
				'rtsb_volume_discount' => esc_html__( 'Volume Discount', 'shopbuilder-pro' ),
			],
			'label_block' => true,
			'default'     => 'all',
		];

		$fields['coupon_expiration_visibility'] = [
			'type'        => 'select2',
			'label'       => esc_html__( 'Filter by Expiration Visibility', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Select the coupon based on its expiration status.', 'shopbuilder-pro' ),
			'options'     => [
				'active'    => esc_html__( 'Active Coupons', 'shopbuilder-pro' ),
				'no_expiry' => esc_html__( 'Coupons Without Expiry', 'shopbuilder-pro' ),
				'expired'   => esc_html__( 'Expired Coupons', 'shopbuilder-pro' ),
			],
			'multiple'    => true,
			'label_block' => true,
		];

		$fields['coupon_limit'] = [
			'type'        => 'number',
			'label'       => esc_html__( 'Coupons Limit', 'shopbuilder-pro' ),
			'description' => esc_html__( 'The number of coupons to show. Set empty to show all coupons.', 'shopbuilder-pro' ),
			'default'     => 12,
		];

		$fields['coupon_query_layout_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Setting section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function settings( $obj ) {
		$fields['settings_layout'] = $obj->start_section(
			esc_html__( 'Settings', 'shopbuilder-pro' ),
			'content'
		);

		$fields['show_discount'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Discount Text?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show discount text.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['show_desc'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Description Tooltip?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show description tooltip.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
			'condition'   => [
				'show_discount' => 'yes',
			],
		];

		$fields['show_coupon'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Coupon Code?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show coupon code.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['show_expiration'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Expiration Text?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show expiration text.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['show_validity'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Validity Text?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show validity text.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
		];

		$fields['show_badge'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Badge?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show badge.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['custom_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Custom Badge Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter custom Badge text. It will override the default text.', 'shopbuilder-pro' ),
			'default'     => esc_html__( 'Coupon', 'shopbuilder-pro' ),
			'label_block' => true,
			'condition'   => [
				'show_badge' => 'yes',
			],
		];

		$fields['settings_layout_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Design section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	private static function design( $obj ) {
		$css_selectors = $obj->selectors['design'];

		$fields['design_start'] = $obj->start_section( esc_html__( 'Coupon Design', 'shopbuilder-pro' ), 'style' );

		$fields['design_note'] = $obj->el_heading( esc_html__( 'Typography', 'shopbuilder-pro' ) );

		$fields['rtsb_el_coupon_discount_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Discount Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['discount_typography'],
		];

		$fields['rtsb_el_coupon_code_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Code Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['code_typography'],
		];

		$fields['rtsb_el_coupon_validity_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Validity Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['validity_typography'],
		];

		$fields['rtsb_el_coupon_text_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Badge Typography', 'shopbuilder-pro' ),
			'selector' => $css_selectors['text_typography'],
		];

		$fields['design_color_note'] = $obj->el_heading( esc_html__( 'Colors', 'shopbuilder-pro' ) );

		$fields['coupon_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Content Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['coupon_bg_color'] => '--rtsb-coupon-background: {{VALUE}};' ],
		];

		$fields['coupon_text_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Content Text Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['coupon_text_color'] => '--rtsb-coupon-text-color: {{VALUE}};' ],
		];

		$fields['coupon_badge_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Badge Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['coupon_badge_bg_color'] => 'background-color: {{VALUE}};' ],
		];

		$fields['coupon_expired_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Expired Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['coupon_expired_bg_color'] => '--rtsb-coupon-background: {{VALUE}};' ],
		];

		$fields['coupon_badge_text_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Badge Text Color', 'shopbuilder-pro' ),
			'selectors' => [
				$css_selectors['coupon_badge_text_color']['color'] => 'color: {{VALUE}};',
				$css_selectors['coupon_badge_text_color']['bg_color'] => 'background-color: {{VALUE}};',
			],
		];

		$fields['coupon_dot_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Dot Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['coupon_dot_color'] => '--rtsb-coupon-dot-color: {{VALUE}};' ],
			'condition' => [
				'layout' => 'rtsb-coupon-layout1',
			],
		];

		$fields['coupon_badge_note'] = $obj->el_heading( esc_html__( 'Badge', 'shopbuilder-pro' ) );

		$fields['badge_x_position'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Position Offset (Horizontal)', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => -100,
					'max' => 300,
				],
			],
			'condition'  => [
				'layout' => [ 'rtsb-coupon-layout2', 'rtsb-coupon-layout3' ],
			],
			'selectors'  => [ $css_selectors['badge_x_position'] => 'right: {{SIZE}}{{UNIT}};' ],
		];

		$fields['badge_y_position'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Position Offset (Vertical)', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => -100,
					'max' => 300,
				],
			],
			'condition'  => [
				'layout' => 'rtsb-coupon-layout3',
			],
			'selectors'  => [ $css_selectors['badge_y_position'] => 'top: {{SIZE}}{{UNIT}};' ],
		];

		$fields['badge_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Badge Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [ $css_selectors['badge_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
		];

		$fields['design_gap_note'] = $obj->el_heading( esc_html__( 'Spacing', 'shopbuilder-pro' ) );

		$fields['grid_gap'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Grid Gap / Spacing (px)', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'default'     => [
				'unit' => 'px',
				'size' => 30,
			],
			'description' => esc_html__( 'Please select the grid gap in px.', 'shopbuilder-pro' ),
			'selectors'   => [
				$css_selectors['grid_gap']['padding'] => 'padding-left: calc({{SIZE}}{{UNIT}} / 2); padding-right: calc({{SIZE}}{{UNIT}} / 2);',
				$css_selectors['grid_gap']['margin']  => 'margin-left: calc(-{{SIZE}}{{UNIT}} / 2); margin-right: calc(-{{SIZE}}{{UNIT}} / 2);',
				$css_selectors['grid_gap']['element_margin'] => 'margin-bottom: {{SIZE}}{{UNIT}};',
			],
		];

		$fields['content_height'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Content Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 700,
				],
			],
			'selectors'  => [ $css_selectors['content_height'] => 'min-height: {{SIZE}}{{UNIT}};' ],
		];

		$fields['content_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Content Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [ $css_selectors['content_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
		];

		$fields['design_end'] = $obj->end_section();

		return $fields;
	}
}
