<?php
/**
 * Elementor Settings Fields Class.
 *
 * This class contains all the pro fields for Settings tab.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Helpers\Fns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Elementor Settings Fields Class.
 */
class SettingsFields {
	/**
	 * Filter section
	 *
	 * @param array  $fields Control fields.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filter_controls( $fields ) {
		unset( $fields['filter_note'] );

		$fields['tax_filter']['separator'] = 'default';

		$pro_controls['ajax_filter_type'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Ajax Filter Type.', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please select your preferred Ajax filter type.', 'shopbuilder-pro' ),
			'options'     => [
				'taxonomy' => esc_html__( 'Taxonomy Tab Filter', 'shopbuilder-pro' ),
				'special'  => esc_html__( 'Conditional Display Tab Filter', 'shopbuilder-pro' ),
			],
			'label_block' => true,
			'condition'   => [ 'tax_filter' => [ 'yes' ] ],
			'default'     => 'taxonomy',
		];

		$pro_controls['tax_filter_type'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Filter Button Type', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please select the filter button type.', 'shopbuilder-pro' ),
			'options'     => [
				'button' => esc_html__( 'Horizontal Buttons', 'shopbuilder-pro' ),
				'track'  => esc_html__( 'Horizontal Tracks', 'shopbuilder-pro' ),
			],
			'default'     => 'button',
			'label_block' => true,
			'condition'   => [ 'tax_filter' => [ 'yes' ] ],
		];

		$pro_controls['filter_taxonomy'] = [
			'type'        => 'select2',
			'label'       => __( 'Taxonomy Data Source', 'shopbuilder-pro' ),
			'description' => __( 'Please select the filter button taxonomy data Source.', 'shopbuilder-pro' ),
			'options'     => Fns::get_tax_list(),
			'default'     => 'product_cat',
			'label_block' => true,
			'condition'   => [
				'tax_filter'       => [ 'yes' ],
				'ajax_filter_type' => [ 'taxonomy' ],
			],
		];

		$taxonomies = get_object_taxonomies( rtsb()->post_type, 'objects' );

		foreach ( $taxonomies as $taxonomy => $object ) {
			if ( empty( $taxonomy ) || ! in_array( $taxonomy, array_keys( Fns::get_tax_list() ), true ) ) {
				continue;
			}

			$pro_controls[ $taxonomy . '_default' ] = [
				'type'                     => 'rt-select2',
				'label'                    => esc_html__( 'Default Selected Term', 'shopbuilder-pro' ),
				'description'              => sprintf(
					'%s<br /><span style="color: #93003c;">%s</span>',
					esc_html__( 'Please select the term you want to select by default.', 'shopbuilder-pro' ),
					esc_html__( 'Note: You have to select the above selected data source terms from top Query section.', 'shopbuilder-pro' ),
				),
				'source_name'              => 'taxonomy',
				'source_type'              => $taxonomy,
				'multiple'                 => true,
				'minimum_input_length'     => 1,
				'maximum_selection_length' => 1,
				'label_block'              => true,
				'condition'                => [
					'tax_filter'       => [ 'yes' ],
					'ajax_filter_type' => [ 'taxonomy' ],
					'filter_taxonomy'  => [ $taxonomy ],
				],
			];
		}

		$pro_controls['tax_show_count'] = [
			'type'        => 'switch',
			'label'       => __( 'Display Term Count?', 'shopbuilder-pro' ),
			'description' => __( 'Switch on to display term count.', 'shopbuilder-pro' ),
			'label_on'    => __( 'On', 'shopbuilder-pro' ),
			'label_off'   => __( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
			'condition'   => [
				'tax_filter'       => [ 'yes' ],
				'ajax_filter_type' => [ 'taxonomy' ],
			],
		];

		$default_tabs = [
			[
				'tab_title' => esc_html__( 'New', 'shopbuilder-pro' ),
				'tab_query' => 'recent',
			],
			[
				'tab_title' => esc_html__( 'Featured', 'shopbuilder-pro' ),
				'tab_query' => 'featured',
			],
			[
				'tab_title' => esc_html__( 'On Sale', 'shopbuilder-pro' ),
				'tab_query' => 'sale',
			],
		];

		$pro_controls['custom_tabs'] = [
			'type'        => 'repeater',
			'mode'        => 'repeater',
			'label'       => esc_html__( 'Please add tab elements below', 'shopbuilder-pro' ),
			'condition'   => [
				'tax_filter'       => [ 'yes' ],
				'ajax_filter_type' => [ 'special' ],
			],
			'fields'      => [
				'tab_title' => [
					'label'       => esc_html__( 'Tab Title', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Enter the tab title.', 'shopbuilder-pro' ),
					'type'        => 'text',
					'label_block' => true,
					'default'     => esc_html__( 'Best Selling', 'shopbuilder-pro' ),
					'separator'   => 'before-short',
				],
				'tab_query' => [
					'type'        => 'select',
					'label'       => esc_html__( 'Display Products By:', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please select the conditional display of products.', 'shopbuilder-pro' ),
					'options'     => [
						'recent'       => esc_html__( 'Recent Products', 'shopbuilder-pro' ),
						'featured'     => esc_html__( 'Featured Products', 'shopbuilder-pro' ),
						'best-selling' => esc_html__( 'Best Selling Products', 'shopbuilder-pro' ),
						'sale'         => esc_html__( 'On Sale Products', 'shopbuilder-pro' ),
						'top-rated'    => esc_html__( 'Top Rated Products', 'shopbuilder-pro' ),
					],
					'default'     => 'best-selling',
					'label_block' => true,
					'separator'   => 'before-short',
				],
			],
			'default'     => $default_tabs,
			'separator'   => 'before elementor-control-separator-after',
			'title_field' => '{{{ tab_title }}}',
		];

		$pro_controls['tax_show_all'] = [
			'type'        => 'switch',
			'label'       => __( 'Display \'Show All\' Button?', 'shopbuilder-pro' ),
			'description' => __( 'Switch on to display \'Show All\' button.', 'shopbuilder-pro' ),
			'label_on'    => __( 'On', 'shopbuilder-pro' ),
			'label_off'   => __( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
			'condition'   => [
				'tax_filter' => [ 'yes' ],
			],
		];

		$pro_controls['tax_show_all_text'] = [
			'type'        => 'text',
			'label'       => __( '\'Show All\' Button Text?', 'shopbuilder-pro' ),
			'description' => __( 'Please enter the \'Show All\' button text.', 'shopbuilder-pro' ),
			'default'     => __( 'All', 'shopbuilder-pro' ),
			'label_block' => true,
			'condition'   => [
				'tax_filter'   => [ 'yes' ],
				'tax_show_all' => [ 'yes' ],
			],
		];

		// TODO: Implement search later.
		// $pro_controls['tax_search'] = [
		// 'type'        => 'switch',
		// 'label'       => __( 'Enable Search Filter?', 'shopbuilder-pro' ),
		// 'description' => __( 'Switch on to enable search filter.', 'shopbuilder-pro' ),
		// 'label_on'    => __( 'On', 'shopbuilder-pro' ),
		// 'label_off'   => __( 'Off', 'shopbuilder-pro' ),
		// ];

		return Fns::insert_controls( 'tax_filter', $fields, $pro_controls, true );
	}

	/**
	 * Ordering section
	 *
	 * @param array  $fields Control fields.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function ordering_control( $fields, $obj ) {
		unset( $fields['ordering_note'] );

		$fields['custom_ordering']['separator'] = 'default';

		$defaults = [
			[
				'ordering_title' => esc_html__( 'Variation Swatches', 'shopbuilder-pro' ),
				'ordering_type'  => 'swatches',
			],
			[
				'ordering_title' => esc_html__( 'Product Categories', 'shopbuilder-pro' ),
				'ordering_type'  => 'categories',
			],
			[
				'ordering_title' => esc_html__( 'Product Title', 'shopbuilder-pro' ),
				'ordering_type'  => 'title',
			],
			[
				'ordering_title' => esc_html__( 'Product Rating', 'shopbuilder-pro' ),
				'ordering_type'  => 'rating',
			],
			[
				'ordering_title' => esc_html__( 'Short Description', 'shopbuilder-pro' ),
				'ordering_type'  => 'description',
			],
			[
				'ordering_title' => esc_html__( 'Product Price', 'shopbuilder-pro' ),
				'ordering_type'  => 'price',
			],
			[
				'ordering_title' => esc_html__( 'Product Stock Count', 'shopbuilder-pro' ),
				'ordering_type'  => 'stock',
			],
		];

		$pro_controls['custom_ordering_note'] = [
			'type'      => 'html',
			'raw'       => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
				__( 'All the elements are listed below, regardless of their visibility (enabled or disabled). Please note that, not all layouts/elements support custom ordering. <br><br>It is recommended to adjust the elements spacings manually in case of any changes to the ordering.', 'shopbuilder-pro' )
			),
			'condition' => [
				'custom_ordering' => [ 'yes' ],
				'layout!'         => [ 'grid-layout4', 'list-layout5', 'list-layout6', 'slider-layout4', 'slider-layout8' ],
			],
		];

		$pro_controls['custom_ordering_note_no_support'] = [
			'type'      => 'html',
			'raw'       => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
				esc_html__( 'This layout does not support custom ordering.', 'shopbuilder-pro' )
			),
			'condition' => [
				'layout' => [ 'grid-layout4', 'list-layout5', 'list-layout6', 'slider-layout4', 'slider-layout8' ],
			],
		];

		$pro_controls['content_ordering'] = [
			'type'         => 'repeater',
			'mode'         => 'repeater',
			'label'        => esc_html__( 'Please order elements below', 'shopbuilder-pro' ),
			'condition'    => [
				'custom_ordering' => [ 'yes' ],
				'layout!'         => [ 'grid-layout4', 'list-layout5', 'list-layout6', 'slider-layout4', 'slider-layout8' ],
			],
			'fields'       => [],
			'default'      => $defaults,
			'separator'    => 'before',
			'item_actions' => [
				'add'       => false,
				'duplicate' => false,
				'remove'    => false,
				'sort'      => true,
			],
			'title_field'  => '{{{ ordering_title }}}',
		];

		return Fns::insert_controls( 'custom_ordering', $fields, $pro_controls, true );
	}
}
