<?php
/**
 * SaleCountSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * SaleCountSettings class.
 */
class SaleCountSettings {
	/**
	 * Widget Field
	 *
	 * @param object $widget Reference widget.
	 * @return array
	 */
	public static function settings( $widget ) {
		$textstyle = TextStyleSettings::widget_fields( $widget );

		$alignment = ControlHelper::alignment();
		unset( $alignment['justify'] );

		$textstyle['align']['options']       = $alignment;
		$textstyle['align']['selectors']     = [
			$widget->selectors['align'] => 'justify-content: {{VALUE}};',
		];
		$textstyle['section_style']['label'] = esc_html__( 'Text', 'shopbuilder-pro' );
		$extra_controls['sale_counter_text'] = [
			'label'       => esc_html__( 'Text', 'shopbuilder-pro' ),
			'type'        => 'textarea',
			'default'     => esc_html__( 'This product sold %s times!', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Example: This product sold %s times!', 'shopbuilder-pro' ),
		];

		$textstyle = Fns::insert_controls( 'section_style', $textstyle, $extra_controls, true );

		$total_count_fields = [
			'total_section_style'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Count', 'shopbuilder-pro' ),
			],
			'total_typo'              => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['total_typo'],
			],
			'total_text_color'        => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['total_text_color'] => 'color: {{VALUE}};',
				],
			],
			'total_section_style_end' => [
				'mode' => 'section_end',
			],
		];

		$total_count_icon = [
			'sale_count_icon_start'  => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Icon', 'shopbuilder-pro' ),
			],
			'sale_count_icon'        => [
				'label'   => esc_html__( 'Icon', 'shopbuilder-pro' ),
				'type'    => 'icons',
				'default' => [
					'value'   => 'fas fa-fire',
					'library' => 'fa-solid',
				],
			],

			'icon_size'              => [
				'label'     => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors' => [
					$widget->selectors['icon_size']['icon'] => 'font-size: {{SIZE}}{{UNIT}};',
					$widget->selectors['icon_size']['svg'] => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			],

			'sale_count_icon_color'  => [
				'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['sale_count_icon_color'] => 'color: {{VALUE}};',
				],
			],
			'sale_count_icon_margin' => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['sale_count_icon_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],

			'sale_count_icon_end'    => [
				'mode' => 'section_end',
			],
		];

		return $textstyle + $total_count_fields + $total_count_icon;
	}
}
