<?php
/**
 * OrderReceivedSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class OrderReceivedSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function widget_fields( $widget ) {
		$textStyleSettings                         = TextStyleSettings::widget_fields( $widget );
		$textStyleSettings['section_style']['tab'] = 'style';

		return self::general_section( $widget ) +
			   $textStyleSettings +
			   ButtonSettings::style_settings( $widget );
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function general_section( $widget ) {
		$align = ControlHelper::alignment();
		unset( $align['justify'] );
		return [
			'sec_general'                => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'content_align'              => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => $align,
				'selectors' => [
					$widget->selectors['content_align'] => 'text-align: {{VALUE}};',
				],
			],

			'order_received_text'        => [
				'label'       => esc_html__( 'Alternative Text', 'shopbuilder-pro' ),
				'type'        => 'textarea',
				'description' => esc_html__( 'If you want to change woocommerce default order received text then you can add custom text from this', 'shopbuilder-pro' ),
				'separator'   => 'default',
			],
			'failed_order_received_text' => [
				'label'       => esc_html__( 'Alternative Text (Only For Failed Order)', 'shopbuilder-pro' ),
				'type'        => 'textarea',
				'description' => esc_html__( 'Add custom text to replace the default WooCommerce failed order received text.', 'shopbuilder-pro' ),
				'separator'   => 'default',
			],
			'sec_general_end'            => [
				'mode' => 'section_end',
			],
		];
	}
}
