<?php
/**
 * OrderNoteSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class OrderNoteSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function widget_fields( $widget ) {
		return TitleSettings::general_settings() +
			   TitleSettings::title_settings( $widget ) +
			   self::content_style( $widget );
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function content_style( $widget ) {
		return [
			'content_section_style'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Content Style', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'list_gap'                  => [
				'type'       => 'slider',
				'mode'       => 'responsive',
				'label'      => esc_html__( 'Spacing', 'shopbuilder-pro' ),
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 50,
					],
				],
				'selectors'  => [
					$widget->selectors['list_gap'] => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'separator'  => 'default',
			],
			'content_margin'            => [
				'label'      => esc_html__( 'Content Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					$widget->selectors['content_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'meta_heading'              => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Meta Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'meta_typography'           => [
				'mode'      => 'group',
				'type'      => 'typography',
				'seperator' => 'before',
				'label'     => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['meta_typography'],
			],
			'meta_color'                => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['meta_color'] => 'color: {{VALUE}};',
				],
			],
			'meta_margin'               => [
				'label'      => esc_html__( 'Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['meta_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'description_heading'       => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Description Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'description_typography'    => [
				'mode'      => 'group',
				'type'      => 'typography',
				'seperator' => 'before',
				'label'     => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['description_typography'],
			],
			'description_color'         => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['description_color'] => 'color: {{VALUE}};',
				],
			],
			'content_section_style_end' => [
				'mode' => 'section_end',
			],
		];
	}

}
