<?php
/**
 * OrderReceivedSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\OrderReviewTableSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class OrderDetailsTableSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		if ( 'rtsb-order-details-table' === $widget->rtsb_base ) {
			$fields = self::layout_settings() + self::visibility_settings( $widget ) + OrderReviewTableSettings::general_settings( $widget ) + self::title_settings( $widget ) + self::table_settings( $widget ) + ButtonSettings::style_settings( $widget );
		} else {
			$fields = OrderReviewTableSettings::general_settings( $widget ) + TitleSettings::title_settings( $widget ) + self::table_settings( $widget );
			if ( 'rtsb-account-order-table' === $widget->rtsb_base ) {
				$fields = array_merge( $fields, self::action_button_style( $widget ) );
			}
		}
		return $fields;
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function title_settings( $widget ) {
		$title_settings = TitleSettings::title_settings( $widget );
		$insert_array   = [
			'title_border' => [
				'mode'      => 'group',
				'type'      => 'border',
				'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['title_border'],
				'separator' => 'before',
			],
		];
		return Fns::insert_controls( 'title_text_shadow', $title_settings, $insert_array, true );
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function visibility_settings( $widget ) {
		$settings     = OrderReviewTableSettings::general_settings( $widget );
		$insert_array = [
			'show_table_heading' => [
				'label'       => esc_html__( 'Show Table Heading?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show table heading.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
				'condition'   => [
					'layout' => [ 'layout2' ],
				],
			],
		];

		return Fns::insert_controls( 'show_title', $settings, $insert_array, true );
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function layout_settings() {
		return [
			'layout_section'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Layout', 'shopbuilder-pro' ),
			],
			'layout'             => [
				'type'      => 'rtsb-image-selector',
				'options'   => [
					'layout1' => [
						'title' => esc_html__( 'Default Layout', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/grid-style-01.png' ) ),
					],
					'layout2' => [
						'title' => esc_html__( 'Layout 2', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/grid-style-01.png' ) ),
					],
				],
				'default'   => 'layout1',
				'separator' => 'default',
			],
			'layout_section_end' => [
				'mode' => 'section_end',
			],
		];
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function table_settings( $widget ) {
		$fields = OrderReviewTableSettings::table_settings( $widget );

		$insert_array = [
			'table_header_label'    => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Table Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],

			'table_header_typo'     => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['table_header_typo'],
			],
			'table_header_align'    => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['table_header_align'] => 'text-align: {{VALUE}}!important;',
				],
			],
			'table_header_color'    => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_header_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'table_header_bg_color' => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_header_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
		];

		$fields = Fns::insert_controls( 'table_cell', $fields, $insert_array );

		$insert_array = [
			'table_footer_label'    => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Table Footer', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'table_footer_typo'     => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['table_footer_typo'],
			],
			'table_footer_align'    => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['table_footer_align'] => 'text-align: {{VALUE}}!important;',
				],
			],
			'table_footer_color'    => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_footer_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'table_footer_bg_color' => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_footer_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
		];

		return Fns::insert_controls( 'table_heading_end', $fields, $insert_array );
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function action_button_style( $widget ) {
		return ButtonSettings::style_settings( $widget );
	}
}
