<?php
/**
 * OrderDetailsSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;

/**
 * OrderDetailsSettings class.
 */
class OrderDetailsSettings {


	/**
	 * @param object $widget widget object.
	 *
	 * @return mixed
	 */
	public static function widget_fields( $widget ) {

		return self::general_section( $widget ) +
			   self::general_style( $widget ) +
			   self::content_style( $widget );
	}

	/**
	 * @return array[] general section controls
	 */
	public static function general_section( $widget ) {
		return [
			'sec_general'               => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'view_mode'                 => [
				'label'     => esc_html__( 'Default View', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => [
					'flex'  => [
						'title' => esc_html__( 'Inline', 'shopbuilder-pro' ),
						'icon'  => 'eicon-posts-grid',
					],
					'block' => [
						'title' => esc_html__( 'New Line', 'shopbuilder-pro' ),
						'icon'  => 'eicon-post-list',
					],
				],
				'default'   => 'flex',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['view_mode'] => 'display: {{VALUE}}',
					'{{WRAPPER}} .rtsb-order-thankyou > li' => 'float:unset!important',
				],
			],
			'show_order_number'         => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Order Number?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show order number.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'separator'   => 'default',
			],
			'show_order_date'           => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Order Date?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show order date.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'separator'   => 'default',
			],
			'show_order_email'          => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Order Email?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show order email.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'separator'   => 'default',
			],
			'show_order_total'          => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Order Total?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show order total.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'separator'   => 'default',
			],
			'show_order_payment_method' => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Order Payment Method?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show order payment method.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'separator'   => 'default',
			],
			'sec_general_end'           => [
				'mode' => 'section_end',
			],
		];
	}

	/**
	 * @param object $widget widget object.
	 *
	 * @return array[]
	 */
	public static function general_style( $widget ) {
		return [
			'section_style'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General Style', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'content_border'    => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['content_border'],
				'size_units' => [ 'px' ],
			],
			'align'             => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['align'] => 'justify-content: {{VALUE}};',
				],
			],
			'content_padding'   => [
				'mode'       => 'responsive',
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					$widget->selectors['content_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'content_margin'    => [
				'mode'       => 'responsive',
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					$widget->selectors['content_padding'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'content_bg'               => [
				'label'     => esc_html__( 'Content Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['content_bg'] => 'background-color: {{VALUE}};',
				],
			],
			'section_style_end' => [
				'mode' => 'section_end',
			],
		];
	}

	/**
	 * @param object $widget widget object.
	 *
	 * @return array[]
	 */
	public static function content_style( $widget ) {
		return [
			'content_section_style'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Content Style', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'label_heading'             => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Label Style', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'label_view_mode'           => [
				'label'     => esc_html__( 'Default View', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => [
					'flex'  => [
						'title' => esc_html__( 'Inline', 'shopbuilder-pro' ),
						'icon'  => 'eicon-posts-grid',
					],
					'block' => [
						'title' => esc_html__( 'New Line', 'shopbuilder-pro' ),
						'icon'  => 'eicon-post-list',
					],
				],
				'default'   => 'block',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['label_view_mode'] => 'display: {{VALUE}};align-items:center!important;gap:5px!important',
				],
			],
			'label_typo'                => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['label_typo'],
			],
			'label_color'               => [
				'label'     => esc_html__( 'Label Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['label_color'] => 'color: {{VALUE}};',
				],
			],
			'value_heading'             => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Value Style', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'value_typo'                => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['value_typo'],
			],
			'value_color'               => [
				'label'     => esc_html__( 'Label Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['value_color'] => 'color: {{VALUE}};',
				],
			],
			'content_section_style_end' => [
				'mode' => 'section_end',
			],
		];
	}
}
