<?php
/**
 * OrderBillingAddressSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\OrderReviewTableSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class OrderBillingAddressSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		$fields = BillingShippingSettings::settings( $widget );

		$insert_array = [
			'contact_heading'    => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Contact Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'contact_typography' => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['contact_typography'],
			],
			'contact_color'      => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['contact_color'] => 'color: {{VALUE}};',
				],
			],
		];

		return Fns::insert_controls( 'address_color', $fields, $insert_array, true );

	}


}
