<?php
/**
 * LostPasswordSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.


use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class LostPasswordSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {

		return self::form_wrapper_settings( $widget ) + self::text_settings( $widget ) + self::form_settings( $widget ) + self::info_box_style( $widget );

	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function text_settings( $widget ) {
		$textSettings                           = TextStyleSettings::widget_fields( $widget );
		$textSettings['section_style']['tab']   = 'style';
		$textSettings['section_style']['label'] = esc_html__( 'Form Text', 'shopbuilder-pro' );
		$insert_array                           = [
			'text_margin' => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['text_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
		];

		return Fns::insert_controls( 'text_shadow', $textSettings, $insert_array, true );
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function form_settings( $widget ) {
		$fields = FormFieldSettings::widget_fields( $widget );
		unset( $fields['form_heading_label'] );
		unset( $fields['form_border_between_color'] );
		unset( $fields['fields_label_reguired_color'] );
		unset( $fields['form_heading_typo'] );
		unset( $fields['form_heading_color'] );
		unset( $fields['form_heading_gap'] );
		return $fields;
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function form_wrapper_settings( $widget ) {
		return [
			'form_wrapper_start'         => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Form Wrapper', 'shopbuilder-pro' ),
			],
			'form_wrapper_border'        => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['form_wrapper_border'],
				'size_units' => [ 'px' ],
			],
			'form_wrapper_border_radius' => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['form_wrapper_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'form_wrapper_bg_color'      => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['form_wrapper_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'form_wrapper_padding'       => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['form_wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'form_wrapper_start_end'     => [
				'mode' => 'section_end',
			],
		];
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function info_box_style( $widget ) {
		return [
			'info_box_start'         => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Info Box', 'shopbuilder-pro' ),
			],
			'info_box_typo'          => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['info_box_typo'],
			],
			'info_box_border'        => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['info_box_border'],
				'size_units' => [ 'px' ],
			],
			'info_box_border_radius' => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['info_box_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'info_box_bg_color'      => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['info_box_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'info_box_padding'       => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['info_box_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'info_box_end'           => [
				'mode' => 'section_end',
			],
		];
	}
}
