<?php
/**
 * Main HighlightedProductSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ActionsBtnSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\ModuleBtnControls;
use RadiusTheme\SB\Elementor\Widgets\Controls\QuantityFields;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Description class
 */
class HighlightedProductSettings {

	/**
	 * Widget Field
	 *
	 * @param object $widget Widget object.
	 *
	 * @return array
	 */
	public static function widget_fields( $widget ) {

		return self::layout_settings( $widget )
			   + self::content_visibility_settings()
			   + self::content_custom_ordering()
			   + self::action_button_icons()
			   + self::product_image_settings( $widget )
			   + self::quantity_settings( $widget )
			   + self::product_stock_count_settings()
			   + self::product_title_style( $widget )
			   + self::price_style( $widget )
			   + self::description_style_settings( $widget )
			   + self::product_meta_style( $widget )
			   + self::product_rating_style( $widget )
			   + self::action_buttons_style( $widget )
			   + self::add_to_cart_style( $widget )
			   + self::product_stock_count_style( $widget );
	}

	public static function layout_settings( $widget ) {
		return [
			'product_layout_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Layout', 'shopbuilder-pro' ),
			],
			'product_id'                   => [
				'label'       => esc_html__( 'Product Name', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please choose the product name.', 'shopbuilder-pro' ),
				'type'        => 'rt-select2',
				'source_name' => 'post_type',
				'source_type' => 'product',
				'label_block' => true,
				'multiple'    => false,
			],
			'highlighted_product_layout'   => [
				'label'     => esc_html__( 'Layout', 'shopbuilder-pro' ),
				'type'      => 'rtsb-image-selector',
				'options'   => FnsPro::highlighted_product_layouts(),
				'default'   => 'layout1',
				'separator' => 'default',
			],
			'product_image_width'          => [
				'type'        => 'slider',
				'mode'        => 'responsive',
				'label'       => esc_html__( 'Image Width', 'shopbuilder-pro' ),
				'size_units'  => [ 'px', '%' ],
				'range'       => [
					'%' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'     => [
					'unit' => '%',
					'size' => 45,
				],
				'description' => esc_html__( 'Please select the image width in %.', 'shopbuilder-pro' ),
				'selectors'   => [
					$widget->selectors['product_image_width'] => 'flex-basis: {{SIZE}}{{UNIT}}!important; max-width: {{SIZE}}{{UNIT}}!important;',
				],
			],
			'product_image_gap'            => [
				'type'        => 'slider',
				'mode'        => 'responsive',
				'label'       => esc_html__( 'Image Gap (px)', 'shopbuilder-pro' ),
				'size_units'  => [ 'px' ],
				'range'       => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'     => [
					'unit' => 'px',
					'size' => 40,
				],
				'description' => esc_html__( 'Please select the image gap in px.', 'shopbuilder-pro' ),
				'selectors'   => [
					$widget->selectors['product_image_gap'] => 'gap: {{SIZE}}{{UNIT}};',
				],
			],
			'vertical_alignment'           => [
				'type'      => 'select',
				'label'     => esc_html__( 'Vertical Alignment', 'shopbuilder-pro' ),
				'default'   => 'flex-start',
				'options'   => [
					'flex-start' => esc_html__( 'Top', 'shopbuilder-pro' ),
					'center'     => esc_html__( 'Center', 'shopbuilder-pro' ),
					'flex-end'   => esc_html__( 'Bottom', 'shopbuilder-pro' ),
				],
				'selectors' => [
					$widget->selectors['vertical_alignment'] => 'align-content: {{VALUE}};align-self:{{VALUE}}',
				],
			],
			'product_layout_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}
	public static function content_visibility_settings() {
		$fields = [
			'product_content_visibility_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Content Visibility', 'shopbuilder-pro' ),
			],
			'show_image'                               => [
				'label'       => esc_html__( 'Show Image?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show image.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'show_category'                            => [
				'label'       => esc_html__( 'Show Category?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show category.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'show_sku'                                 => [
				'label'       => esc_html__( 'Show SKU?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show sku.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'sku_label_text'                           => [
				'label'     => esc_html__( 'SKU Label', 'shopbuilder-pro' ),
				'type'      => 'text',
				'default'   => esc_html__( 'SKU:', 'shopbuilder-pro' ),
				'condition' => [
					'show_sku' => 'yes',
				],
			],
			'show_title'                               => [
				'label'       => esc_html__( 'Show Title?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show title.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'show_price'                               => [
				'label'       => esc_html__( 'Show Price?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show price.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'show_description'                         => [
				'label'       => esc_html__( 'Show Short Description?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show short description.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'show_rating'                              => [
				'label'       => esc_html__( 'Show Rating?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show rating.', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'default'     => 'yes',
			],
			'show_product_stock_shortcode'             => [
				'label'       => esc_html__( 'Show Product Stock?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show product stock.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'show_add_to_cart'                         => [
				'label'       => esc_html__( 'Show Add to cart?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show product add to cart.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],

			'product_content_visibility_section_end'   => [
				'mode' => 'section_end',
			],
		];

		$module_switch = ModuleBtnControls::module_switch();
		unset( $module_switch['quick_view_button'] );
		if ( Fns::is_module_active( 'wishlist' ) ) {
			$wishlist_button = [
				'wishlist_button_text' => [
					'label'       => esc_html__( 'Wishlist Button Text', 'shopbuilder-pro' ),
					'type'        => 'text',
					'label_block' => true,
					'condition'   => [
						'wishlist_button' => 'yes',
					],
				],
			];
			$module_switch   = Fns::insert_controls( 'wishlist_button', $module_switch, $wishlist_button, true );
		}
		if ( Fns::is_module_active( 'compare' ) ) {
			$comparison_button = [
				'comparison_button_text' => [
					'label'       => esc_html__( 'Compare Button Text', 'shopbuilder-pro' ),
					'type'        => 'text',
					'label_block' => true,
					'condition'   => [
						'comparison_button' => 'yes',
					],
				],
			];
			$module_switch     = Fns::insert_controls( 'comparison_button', $module_switch, $comparison_button, true );
		}
		$fields = Fns::insert_controls( 'sku_label_text', $fields, $module_switch, true );
		return $fields;
	}

	public static function content_custom_ordering() {
		$defaults = [
			[
				'ordering_title' => esc_html__( 'Product Categories & Review', 'shopbuilder-pro' ),
				'ordering_type'  => 'meta',
			],
			[
				'ordering_title' => esc_html__( 'Product SKU', 'shopbuilder-pro' ),
				'ordering_type'  => 'sku',
			],
			[
				'ordering_title' => esc_html__( 'Product Title', 'shopbuilder-pro' ),
				'ordering_type'  => 'title',
			],
			[
				'ordering_title' => esc_html__( 'Product Price', 'shopbuilder-pro' ),
				'ordering_type'  => 'price',
			],
			[
				'ordering_title' => esc_html__( 'Short Description', 'shopbuilder-pro' ),
				'ordering_type'  => 'description',
			],
			[
				'ordering_title' => esc_html__( 'Product Stock Count', 'shopbuilder-pro' ),
				'ordering_type'  => 'stock',
			],
			[
				'ordering_title' => esc_html__( 'Product Add to Cart', 'shopbuilder-pro' ),
				'ordering_type'  => 'add_to_cart',
			],
			[
				'ordering_title' => esc_html__( 'Action Buttons', 'shopbuilder-pro' ),
				'ordering_type'  => 'action_buttons',
			],
		];
		return [
			'product_custom_ordering_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Content Ordering', 'shopbuilder-pro' ),
			],
			'product_custom_ordering'       => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Enable Custom Ordering?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to enable elements custom ordering.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			],
			'product_content_ordering'      => [
				'type'         => 'repeater',
				'mode'         => 'repeater',
				'label'        => esc_html__( 'Please order elements below', 'shopbuilder-pro' ),
				'condition'    => [
					'product_custom_ordering' => [ 'yes' ],
				],
				'fields'       => [],
				'default'      => $defaults,
				'separator'    => 'before',
				'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'title_field'  => '{{{ ordering_title }}}',
			],
			'product_custom_ordering_end'   => [
				'mode' => 'section_end',
			],
		];
	}

	public static function description_style_settings( $widget ) {
		$description_settings                               = TextStyleSettings::widget_fields( $widget );
		$description_settings['section_style']['condition'] = [
			'show_description' => 'yes',
		];
		$description_settings['section_style']['label']     = esc_html__( 'Description', 'shopbuilder-pro' );
		$description_settings['section_style']['tab']       = 'style';
		return $description_settings;
	}

	public static function product_stock_count_settings() {
		return [
			'product_stock_settings_start' => [
				'mode'      => 'section_start',
				'label'     => esc_html__( 'Product Stock', 'shopbuilder-pro' ),
				'condition' => [
					'show_product_stock_shortcode' => 'yes',
				],
			],
			'product_stock_layout'         => [
				'label'     => esc_html__( 'Layout', 'shopbuilder-pro' ),
				'type'      => 'rtsb-image-selector',
				'options'   => FnsPro::product_stock_count_layouts(),
				'default'   => 'layout1',
				'separator' => 'default',
			],
			'show_stock_text'              => [
				'label'       => esc_html__( 'Show Stock Text?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show stock count text.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',

			],
			'show_stock_progress'          => [
				'label'       => esc_html__( 'Show Stock Progress?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show stock progress bar.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
			],
			'stock_text_position'          => [
				'type'        => 'select2',
				'label'       => esc_html__( 'Stock Text Position', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please select the stock text position.', 'shopbuilder-pro' ),
				'options'     => [
					'top'    => esc_html__( 'Top', 'shopbuilder-pro' ),
					'bottom' => esc_html__( 'Bottom', 'shopbuilder-pro' ),
				],
				'default'     => 'top',
				'label_block' => true,
				'condition'   => [
					'show_stock_text' => 'yes',
				],

			],
			'stock_text'                   => [
				'label'       => esc_html__( 'Stock Text', 'shopbuilder-pro' ),
				'type'        => 'textarea',
				'label_block' => true,
				'default'     => esc_html__( 'Only {count} item(s) left in stock.', 'shopbuilder-pro' ),
				'description' => __( 'Please use the {count} placeholder to dynamically show the stock count. <br />Example: Available Stock: {count} pcs.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'condition'   => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_settings_end'   => [
				'mode' => 'section_end',
			],
		];
	}

	public static function product_image_settings( $widget ) {
		$fields = [
			'image_settings_section_start' => [
				'mode'      => 'section_start',
				'label'     => esc_html__( 'Product Image', 'shopbuilder-pro' ),
				'condition' => [
					'show_image' => 'yes',
				],
			],

			'sale_flash_badge'             => [
				'label'       => esc_html__( 'Show Flash Sale?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show Flash Sale.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],

			'show_module_badges'           => [
				'label'       => esc_html__( 'Show Badges?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show the Badges form from the Module..', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'show_thumbnails'              => [
				'label'       => esc_html__( 'Show Thumbnails?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show Thumbnails.', 'shopbuilder-pro' ),
				'default'     => 'yes',
			],
			'gallery_thumbs_style'         => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Gallery Thumbnails', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'condition'       => [
					'show_thumbnails' => 'yes',
				],
			],

			'gallery_thumbs_column_gap'    => [
				'mode'            => 'responsive',
				'label'           => esc_html__( 'Thumbnail Gap', 'shopbuilder-pro' ),
				'description'     => esc_html__( 'Gallery Thumbnails Gap Is required.', 'shopbuilder-pro' ),
				'render_type'     => 'template',
				'type'            => 'slider',
				'range'           => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'         => [
					'unit' => 'px',
					'size' => 10,
				],
				'desktop_default' => [
					'size' => 10,
					'unit' => 'px',
				],
				'tablet_default'  => [
					'size' => 10,
					'unit' => 'px',
				],
				'mobile_default'  => [
					'size' => 10,
					'unit' => 'px',
				],
				'selectors'       => [
					':root' => '--rtwpvg-thumbnail-gap:{{SIZE}}{{UNIT}};',
				],
				'condition'       => [
					'show_thumbnails' => 'yes',
				],
			],
			'gallery_thumbs_column'        => [
				'mode'            => 'responsive',
				'label'           => esc_html__( 'Column', 'shopbuilder-pro' ),
				'description'     => esc_html__( 'Above Control the Gallery Thumbnails Gap is required.', 'shopbuilder-pro' ),
				'type'            => 'slider',
				'render_type'     => 'template',
				'range'           => [
					'px' => [
						'min'  => 2,
						'max'  => 8,
						'step' => 1,
					],
				],
				'default'         => [
					'unit' => 'px',
					'size' => 6,
				],
				'desktop_default' => [
					'size' => 5,
					'unit' => 'px',
				],
				'tablet_default'  => [
					'size' => 4,
					'unit' => 'px',
				],
				'mobile_default'  => [
					'size' => 3,
					'unit' => 'px',
				],
				'selectors'       => [
					$widget->selectors['gallery_thumbs_column'] => 'width: calc(100%/{{SIZE}} - ( {{gallery_thumbs_column_gap.size}}{{gallery_thumbs_column_gap.unit}} / {{SIZE}} ) *  ({{SIZE}} - 1 ) );flex: 0 0 auto;max-width: initial;',
				],
				'condition'       => [
					'show_thumbnails' => 'yes',
				],
			],
			'gallery_image_gap_with_main'  => [
				'mode'        => 'responsive',
				'label'       => esc_html__( 'Gap with main image', 'shopbuilder-pro' ),
				'type'        => 'slider',
				'render_type' => 'template',
				'range'       => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
				],
				'default'     => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors'   => [
					':root' => '--rtwpvg-thumbnail-gap-with-main:{{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'show_thumbnails' => 'yes',
				],
			],
			'thumb_border'                 => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['thumb_border'],
				'size_units' => [ 'px' ],
				'condition'  => [
					'show_thumbnails' => 'yes',
				],
			],
			'thumbs_border_radius'         => [
				'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
				'type'       => 'slider',
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'%'  => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					$widget->selectors['thumbs_border_radius'] => 'border-radius: {{SIZE}}{{UNIT}}',
				],
				'condition'  => [
					'show_thumbnails' => 'yes',
				],
			],
			'image_wrapper_margin'         => [
				'label'      => esc_html__( 'Wrapper Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['image_wrapper_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'image_settings_section_end'   => [
				'mode' => 'section_end',
			],

		];
		if ( function_exists( 'rtwpvg' ) && rtwpvg()->active_pro() ) {
			$image_layout = [
				'image_layout' => [
					'type'        => 'rtsb-image-selector',
					'label'       => esc_html__( 'Image Layout', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please choose image layout. The layout display the change after reload.', 'shopbuilder-pro' ),
					'options'     => [
						'bottom' => [
							'title' => esc_html__( 'Gallery Bottom', 'shopbuilder-pro' ),
							'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/image-layout-gallery-bottom-2.png' ) ),
						],
						'left'   => [
							'title' => esc_html__( 'Gallery left', 'shopbuilder-pro' ),
							'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/image-layout-gallery-left-2.png' ) ),
						],
						'right'  => [
							'title' => esc_html__( 'Gallery Right', 'shopbuilder-pro' ),
							'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/image-layout-gallery-right-2.png' ) ),
						],
						'grid'   => [
							'title' => esc_html__( 'Gallery Grid', 'shopbuilder-pro' ),
							'url'   => esc_url( rtsb()->get_assets_uri( 'images/layout/image-layout-gallery-grid-2.png' ) ),
						],
					],
					'default'     => 'bottom',
				],
			];
			$fields       = Fns::insert_controls( 'image_settings_section_start', $fields, $image_layout, true );
		}

		return $fields;
	}
	public static function product_meta_style( $widget ) {
		$fields = [
			'meta_content'                   => [
				'mode'       => 'section_start',
				'label'      => esc_html__( 'Meta', 'shopbuilder-pro' ),
				'tab'        => 'style',
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'show_category',
							'operator' => '==',
							'value'    => 'yes',
						],
						[
							'name'     => 'show_sku',
							'operator' => '==',
							'value'    => 'yes',
						],
					],
				],
			],
			'meta_label_heading'             => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Label', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'before',
			],
			'label_typo'                     => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Label Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['label_typo'],
				'exclude'  => [ 'text_transform', 'text_decoration', 'font_style', 'letter_spacing' ],
			],
			'meta_label_color'               => [
				'label'     => esc_html__( 'Label Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['meta_label_color'] => 'color: {{VALUE}};',
				],
			],
			'shopbuilder_meta_value_heading' => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Value', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'before',
			],
			'value_typo'                     => [
				'mode'     => 'group',
				'type'     => 'typography',
				'selector' => $widget->selectors['value_typo'],
				'exclude'  => [ 'text_transform', 'text_decoration', 'font_style', 'letter_spacing' ],
			],
			'meta_value_color'               => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['meta_value_color'] => 'color: {{VALUE}};',
				],
			],
			'meta_value_hover_color'         => [
				'label'     => esc_html__( 'Hover Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['meta_value_hover_color'] => 'color: {{VALUE}};',
				],
			],
			'meta_margin'                    => [
				'label'      => esc_html__( 'Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['meta_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'sku_margin'                     => [
				'label'      => esc_html__( 'SKU Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['sku_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'sec_general_end'                => [
				'mode' => 'section_end',
			],
		];

		return $fields;
	}

	public static function product_rating_style( $widget ) {
		$alignment = ControlHelper::alignment();
		unset( $alignment['justify'] );
		$fields = [
			'sec_product_rating_start'       => [
				'mode'      => 'section_start',
				'label'     => esc_html__( 'Rating', 'shopbuilder-pro' ),
				'tab'       => 'style',
				'condition' => [
					'show_rating' => 'yes',
				],
			],
			'rating_text_link_color'         => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['rating_text_link_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'link_typography'                => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Text Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['link_typography'],
			],
			'rating_space_between'           => [
				'label'      => esc_html__( 'Right Spacing (px)', 'shopbuilder-pro' ),
				'type'       => 'slider',
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors'  => [
					$widget->selectors['rating_space_between']['margin-right'] => 'margin-right: {{SIZE}}{{UNIT}} !important;',
					$widget->selectors['rating_space_between']['margin-left'] => 'margin-left: {{SIZE}}{{UNIT}} !important;',
				],
			],
			'review_star_heading'            => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Star', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'before',
			],
			'review_star_icon_default_color' => [
				'label'     => esc_html__( 'Default color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['review_star_icon_default_color'] => 'color: {{VALUE}};',
				],
			],
			'review_star_icon_color'         => [
				'label'     => esc_html__( 'Star icon Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['review_star_icon_color'] => 'color: {{VALUE}};',
				],
			],
			'review_star_icon_size'          => [
				'mode'       => 'responsive',
				'label'      => esc_html__( 'Star icon size (px)', 'shopbuilder-pro' ),
				'type'       => 'slider',
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					$widget->selectors['review_star_icon_size'] => 'font-size: {{SIZE}}{{UNIT}}!important;',
				],
			],
			'review_star_icon_specing'       => [
				'mode'       => 'responsive',
				'label'      => esc_html__( 'Star icon specing (px)', 'shopbuilder-pro' ),
				'type'       => 'slider',
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],

				'selectors'  => [
					$widget->selectors['review_star_icon_specing'] => 'letter-spacing: {{SIZE}}{{UNIT}};width: initial;display: inline-flex;',
					$widget->selectors['review_star_icon_specing'] . ':before' => 'position: static;',
				],
			],
			'sec_product_rating_end'         => [
				'mode' => 'section_end',
			],
		];
		return $fields;
	}

	public static function product_title_style( $widget ) {
		return [
			'title_style_start' => [
				'mode'      => 'section_start',
				'tab'       => 'style',
				'label'     => esc_html__( 'Title', 'shopbuilder-pro' ),
				'condition' => [
					'show_title' => 'yes',
				],
			],
			'title_typo'        => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['title_typo'],
			],
			'title_align'       => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['title_align'] => 'text-align: {{VALUE}};',
				],
			],
			'title_color'       => [
				'label'     => esc_html__( 'Title Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['title_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'title_text_stroke' => [
				'mode'     => 'group',
				'type'     => 'text-stroke',
				'selector' => $widget->selectors['title_text_stroke'],
			],
			'title_text_shadow' => [
				'mode'     => 'group',
				'type'     => 'text-shadow',
				'selector' => $widget->selectors['title_text_shadow'],
			],
			'title_border'      => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['title_border'],
				'size_units' => [ 'px' ],
			],
			'title_margin'      => [
				'label'      => esc_html__( 'Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['title_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'title_padding'     => [
				'label'      => esc_html__( 'Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['title_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'title_style_end'   => [
				'mode' => 'section_end',
			],
		];
	}

	public static function price_style( $widget ) {
		$alignment = ControlHelper::alignment();
		unset( $alignment['justify'] );
		return [
			'price_style_start'  => [
				'mode'      => 'section_start',
				'tab'       => 'style',
				'label'     => esc_html__( 'Price', 'shopbuilder-pro' ),
				'condition' => [
					'show_price' => 'yes',
				],
			],
			'price_align'        => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => $alignment,
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['price_align'] => 'text-align: {{VALUE}};',
				],
			],
			'price_typo'         => [
				'mode'     => 'group',
				'type'     => 'typography',
				'selector' => $widget->selectors['price_typo'],
			],
			'price_color'        => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['price_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'sale_price_heading' => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Sale Price', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'before',
			],
			'sale_price_typo'    => [
				'mode'     => 'group',
				'type'     => 'typography',
				'selector' => $widget->selectors['sale_price_typo'],
			],
			'sale_price_color'   => [
				'label'     => esc_html__( 'Sale Price Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['sale_price_color'] => ' background: transparent; color: {{VALUE}} !important;',
				],
			],
			'price_margin'       => [
				'label'      => esc_html__( 'Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['price_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'price_style_end'    => [
				'mode' => 'section_end',
			],
		];
	}

	public static function product_stock_count_style( $widget ) {
		$stock_settings                                       = ProductStockCountSettings::stock_count_style_settings( $widget );
		$stock_settings['general_section_start']['label']     = esc_html__( 'Product Stock', 'shopbuilder-pro' );
		$stock_settings['general_section_start']['condition'] = [ 'show_product_stock_shortcode' => 'yes' ];

		$extra_fields['product_stock_wrapper_style'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Wrapper', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
			'separator'       => 'default',
		];
		$extra_fields['stock_wrapper_bg']            = [
			'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'alpha'     => true,
			'selectors' => [
				$widget->selectors['stock_wrapper_bg'] => 'background-color: {{VALUE}};',
			],

		];
		$extra_fields['stock_wrapper_border']        = [
			'mode'       => 'group',
			'type'       => 'border',
			'selector'   => $widget->selectors['stock_wrapper_border'],
			'size_units' => [ 'px' ],
		];
		$extra_fields['stock_wrapper_shadow']        = [
			'mode'     => 'group',
			'type'     => 'text-shadow',
			'selector' => $widget->selectors['stock_wrapper_shadow'],
		];
		$extra_fields['stock_wrapper_border_radius'] = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				$widget->selectors['stock_wrapper_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$extra_fields['stock_wrapper_padding']       = [
			'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				$widget->selectors['stock_wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$extra_fields['stock_wrapper_margin']        = [
			'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				$widget->selectors['stock_wrapper_padding'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		return Fns::insert_controls( 'product_stock_margin', $stock_settings, $extra_fields, true );
	}

	public static function add_to_cart_style( $widget ) {
		$fields = array_merge(
			self::add_to_cart_button( $widget ),
			self::variation_style( $widget ),
			self::variation_product_price( $widget ),
			self::quantity_style( $widget )
		);
		return $fields;
	}

	public static function add_to_cart_button( $widget ) {
		return [
			'button_section_start'      => [
				'mode'      => 'section_start',
				'label'     => esc_html__( 'Add to Cart Button', 'shopbuilder-pro' ),
				'tab'       => 'style',
				'condition' => [
					'show_add_to_cart' => 'yes',
				],
			],
			'button_typography'         => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['button_typography'],
			],
			'button_height'             => [
				'label'     => esc_html__( 'Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'selectors' => [
					$widget->selectors['button_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			],

			'button_width'              => [
				'label'      => esc_html__( 'Width', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%' ],
				'mode'       => 'responsive',
				'type'       => 'slider',
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 900,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					$widget->selectors['button_width'] => 'width: {{SIZE}}{{UNIT}};',
				],
			],

			'button_tabs_start'         => [
				'mode' => 'tabs_start',
			],
			'button_normal'             => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'button_text_color_normal'  => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'separator' => 'default',
				'selectors' => [
					$widget->selectors['button_text_color_normal'] => 'color: {{VALUE}}!important;',
				],
			],
			'button_bg_color_normal'    => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['button_bg_color_normal'] => 'background-color: {{VALUE}} !important;',
				],
			],

			'button_border'             => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['button_border'],
				'size_units' => [ 'px' ],
			],
			'button_normal_end'         => [
				'mode' => 'tab_end',
			],
			'button_hover'              => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Hover', 'shopbuilder-pro' ),
			],
			'button_text_color_hover'   => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'separator' => 'default',
				'selectors' => [
					$widget->selectors['button_text_color_hover'] => 'color: {{VALUE}}!important;',
				],
			],
			'button_bg_color_hover'     => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['button_bg_color_hover']  => 'background-color: {{VALUE}} !important;',
				],
			],
			'button_border_hover_color' => [
				'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['button_border_hover_color']  => 'border-color: {{VALUE}};',
				],
			],
			'button_hover_end'          => [
				'mode' => 'tab_end',
			],
			'button_tabs_end'           => [
				'mode' => 'tabs_end',
			],
			'button_border_radius'      => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'default'    => [
					'top'      => '5',
					'right'    => '5',
					'bottom'   => '5',
					'left'     => '5',
					'unit'     => 'px',
					'isLinked' => true,
				],
				'size_units' => [ 'px' ],
				'separator'  => 'before',
				'selectors'  => [
					$widget->selectors['button_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'button_padding'            => [
				'label'      => esc_html__( 'Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['button_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'separator'  => 'before',
			],

			'button_margin'             => [
				'label'      => esc_html__( 'Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['button_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'button_section_end'        => [
				'mode' => 'section_end',
			],
		];
	}

	public static function variation_style( $widget ) {
		return [
			'variation_section'          => [
				'mode'      => 'section_start',
				'tab'       => 'style',
				'label'     => esc_html__( 'Variations', 'shopbuilder-pro' ),
				'condition' => [
					'show_add_to_cart' => 'yes',
				],
			],
			'variation_label_typography' => [
				'type'        => 'typography',
				'separator'   => 'before',
				'mode'        => 'group',
				'label'       => esc_html__( 'Label Typography', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Only for Variation Label.', 'shopbuilder-pro' ),
				'selector'    => $widget->selectors['variation_label_typography'],
			],
			'variation_stock_typography' => [
				'type'        => 'typography',
				'separator'   => 'before',
				'mode'        => 'group',
				'label'       => esc_html__( 'Stock Typography', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Only for variation stock.', 'shopbuilder-pro' ),
				'selector'    => $widget->selectors['variation_stock_typography'],
			],
			'variation_label_color'      => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['variation_label_color'] => 'color: {{VALUE}}',
				],
			],
			'variation_stock_color'      => [
				'label'     => esc_html__( 'Stock Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['variation_stock_color'] => 'color: {{VALUE}}',
				],
			],
			'variation_outofstock_color' => [
				'label'     => esc_html__( 'Out of Stock Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['variation_outofstock_color'] => 'color: {{VALUE}}',
				],
			],
			'variation_height'           => [
				'label'     => esc_html__( 'Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'selectors' => [
					$widget->selectors['variation_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			],
			'variation_width'            => [
				'label'      => esc_html__( 'Width', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%' ],
				'type'       => 'slider',
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 900,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					$widget->selectors['variation_width'] => 'width: {{SIZE}}{{UNIT}};',
				],
			],
			'variation_border'           => [
				'mode'     => 'group',
				'type'     => 'border',
				'label'    => esc_html__( 'Quantity Border', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['variation_border'],
			],
			'variation_border_radius'    => [
				'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%' ],
				'type'       => 'slider',
				'selectors'  => [
					$widget->selectors['variation_border_radius'] => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			],
			'variation_padding'          => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'default'    => [
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'unit'     => 'px',
					'isLinked' => true,
				],
				'separator'  => 'default',
				'selectors'  => [
					$widget->selectors['variation_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'variation_label_margin'     => [
				'label'      => esc_html__( 'Label Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					$widget->selectors['variation_label_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'variation_item_margin'      => [
				'label'      => esc_html__( 'Variation Item Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					$widget->selectors['variation_item_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'variation_section_end'      => [
				'mode' => 'section_end',
			],

		];
	}

	public static function variation_product_price( $widget ) {
		return [
			'price_section_style_start'  => [
				'mode'      => 'section_start',
				'tab'       => 'style',
				'label'     => esc_html__( 'Variation Price', 'shopbuilder-pro' ),
				'condition' => [
					'show_add_to_cart' => 'yes',
				],
			],
			'variation_price_typography' => [
				'type'        => 'typography',
				'separator'   => 'before',
				'mode'        => 'group',
				'label'       => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Only for Variation Price', 'shopbuilder-pro' ),
				'selector'    => $widget->selectors['variation_price_typography'],
			],
			'variation_price_color'      => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['variation_price_color'] => 'color: {{VALUE}}',
				],
			],
			'variation_price_margin'     => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'separator'  => 'default',
				'selectors'  => [
					$widget->selectors['variation_price_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'price_section_style_end'    => [
				'mode' => 'section_end',
			],
		];
	}

	public static function quantity_style( $widget ) {
		$fields = [
			'quantity_section'                  => [
				'mode'      => 'section_start',
				'tab'       => 'style',
				'label'     => esc_html__( 'Quantity', 'shopbuilder-pro' ),
				'condition' => [
					'show_add_to_cart' => 'yes',
				],
			],
			'quantity_style_heading'            => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Quantity Field Style', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'condition'       => [
					'quantity_style' => [ 'style-1', 'style-2' ],
				],
			],
			'quantity_icon_size'                => [
				'label'     => esc_html__( 'Icon size', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 50,
					],
				],
				'default'   => [
					'size' => 15,
				],
				'selectors' => [
					$widget->selectors['quantity_icon_size'] => 'font-size: {{SIZE}}{{UNIT}};',
				],
			],
			'quantitybox_border_color'          => [
				'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					'{{WRAPPER}} .rtsb-quantity-box-group' => '--rtsb-quantity-border-color: {{VALUE}}',
				],
			],

			'quantity_icon_tabs_start'          => [
				'mode' => 'tabs_start',
			],
			// Tab For normal view.
			'quantity_icon_normal'              => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'quantity_icon_color'               => [
				'label'     => esc_html__( 'Quantity icon Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['quantity_icon_color'] => 'color: {{VALUE}}',
				],
			],
			'quantity_icon_normal_end'          => [
				'mode' => 'tab_end',
			],
			'quantity_icon_hover'               => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Hover', 'shopbuilder-pro' ),
			],
			'quantity_icon_hover_color'         => [
				'label'     => esc_html__( 'Quantity icon Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['quantity_icon_hover_color'] => 'color: {{VALUE}}',
				],
			],
			'quantity_icon_hover_end'           => [
				'mode' => 'tab_end',
			],
			'quantity_icon_tabs_end'            => [
				'mode' => 'tabs_end',
			],

			'text_typography'                   => [
				'type'        => 'typography',
				'separator'   => 'before',
				'mode'        => 'group',
				'label'       => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Only for Quantity Label.', 'shopbuilder-pro' ),
				'selector'    => $widget->selectors['text_typography'],
			],
			'quantity_number_color'             => [
				'label'     => esc_html__( 'Quantity Number', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['quantity_number_color'] => 'color: {{VALUE}}',
				],
			],
			'quantity_background_color'         => [
				'label'     => esc_html__( 'Quantity Backgeound', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['quantity_background_color'] => 'background: {{VALUE}}',
				],
			],
			'quantity_border'                   => [
				'mode'           => 'group',
				'type'           => 'border',
				'fields_options' => [
					'border' => [
						'label'       => esc_html__( 'Quantity Field Border', 'shopbuilder-pro' ),
						'label_block' => true,
					],
					'color'  => [
						'label' => esc_html__( 'Border Color', 'shopbuilder-pro' ),
					],
				],
				'selector'       => $widget->selectors['quantity_border'],
			],
			'quantity_radius'                   => [
				'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%' ],
				'type'       => 'dimensions',
				'selectors'  => [
					$widget->selectors['quantity_radius'] => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			],
			'qunatity_padding'                  => [
				'label'      => esc_html__( 'Field Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					$widget->selectors['qunatity_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'quantity_increment_button_padding' => [
				'label'      => esc_html__( 'Quantity Increment Button Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['quantity_increment_button_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'quantity_decrement_button_padding' => [
				'label'      => esc_html__( 'Quantity Increment Button Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['quantity_decrement_button_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],

			'quantity_style_wrapper_heading'    => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Quantity Wrapper Style', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
			],
			'quantity_wrapper_background_color' => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['quantity_wrapper_background_color'] => 'background: {{VALUE}}',
				],

			],
			'quantity_wrapper_radius'           => [
				'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%' ],
				'type'       => 'dimensions',
				'selectors'  => [
					$widget->selectors['quantity_wrapper_radius'] => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			],
			'qunatity_wrapper_padding'          => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					$widget->selectors['qunatity_wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'quantity_section_end'              => [
				'mode' => 'section_end',
			],
		];
		return $fields;
	}

	public static function quantity_settings( $widget ) {
		$fields                              = QuantityFields::quantity_fields( $widget );
		$fields['sec_quantity']['condition'] = [
			'show_add_to_cart' => 'yes',
		];
		$fields['sec_quantity']['label']     = esc_html__( 'Add to cart', 'shopbuilder-pro' );
		$fields['quantity_style']['label']   = esc_html__( 'Quantity Style', 'shopbuilder-pro' );
		$extra_controls['enable_single_ajax_add_to_cart'] = [
			'label'       => esc_html__( 'Enable Ajax Add to Cart?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Switch on to enable Ajax add to cart.', 'shopbuilder-pro' ),
		];
		$fields = Fns::insert_controls( 'sec_quantity', $fields, $extra_controls, true );
		return $fields;

	}

	public static function action_buttons_style( $widget ) {
		$module_btn_active = Fns::is_module_active( 'wishlist' ) || Fns::is_module_active( 'compare' );
		$fields            = [];
		if ( ! $module_btn_active ) {
			return $fields;
		}
		$fields = [
			'module_section'            => [
				'mode'       => 'section_start',
				'tab'        => 'style',
				'label'      => esc_html__( 'Action Buttons', 'shopbuilder-pro' ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [],
				],
			],
			'module_width'              => [
				'label'     => esc_html__( 'Width', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'default'   => [
					'size' => 20,
				],
				'selectors' => [
					$widget->selectors['module_width'] => 'width: {{SIZE}}{{UNIT}};',
				],
			],
			'module_height'             => [
				'label'     => esc_html__( 'Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'default'   => [
					'size' => 20,
				],
				'selectors' => [
					$widget->selectors['module_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			],
			'module_item_gap'           => [
				'label'     => esc_html__( 'Item Gap (px)', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'   => [
					'size' => 5,
				],
				'selectors' => [
					$widget->selectors['module_item_gap'] => 'gap: {{SIZE}}{{UNIT}};',
				],
			],
			'module_item_alignment'     => [
				'mode'      => 'responsive',
				'type'      => 'choose',
				'label'     => esc_html__( 'Elements Alignment', 'shopbuilder-pro' ),
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'shopbuilder-pro' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					$widget->selectors['module_item_alignment'] => 'justify-content: {{VALUE}}!important;',
				],
			],
			'module_tabs_start'         => [
				'mode' => 'tabs_start',
			],
			// Tab For normal view.
			'module_normal'             => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'module_text_color_normal'  => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['module_text_color_normal'] => 'color: {{VALUE}};',
				],
			],
			'module_bg_color_normal'    => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['module_bg_color_normal'] => 'background-color: {{VALUE}};',
				],
			],
			'module_border'             => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['module_border'],
				'size_units' => [ 'px' ],
			],
			'module_normal_end'         => [
				'mode' => 'tab_end',
			],
			'module_hover'              => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Hover', 'shopbuilder-pro' ),
			],
			'module_text_color_hover'   => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'separator' => 'default',
				'selectors' => [
					$widget->selectors['module_text_color_hover'] => 'color: {{VALUE}};',
				],
			],
			'module_bg_color_hover'     => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['module_bg_color_hover'] => 'background-color: {{VALUE}};',
				],
			],
			'module_border_hover_color' => [
				'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['module_border_hover_color'] => 'border-color: {{VALUE}};',
				],
			],
			'module_hover_end'          => [
				'mode' => 'tab_end',
			],
			'module_tabs_end'           => [
				'mode' => 'tabs_end',
			],
			'module_border_radius'      => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'separator'  => 'before',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['module_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],

			'icon_size'                 => [
				'label'     => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'before',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'default'   => [
					'size' => 15,
				],
				'selectors' => [
					$widget->selectors['icon_size']['icon'] => 'font-size: {{SIZE}}{{UNIT}};',
					$widget->selectors['icon_size']['svg'] => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			],
			'module_wrapper_margin'     => [
				'label'      => esc_html__( 'Module Wrapper Gap (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['module_wrapper_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'module_section_end'        => [
				'mode' => 'section_end',
			],
		];
		if ( ! empty( $fields ) ) {
			if ( Fns::is_module_active( 'wishlist' ) ) {
				$fields['module_section']['conditions']['terms'][] = [
					'name'     => 'wishlist_button',
					'operator' => '===',
					'value'    => 'yes',
				];
			}
			if ( Fns::is_module_active( 'compare' ) ) {
				$fields['module_section']['conditions']['terms'][] = [
					'name'     => 'comparison_button',
					'operator' => '===',
					'value'    => 'yes',
				];
			}
			$extra_fields['module_text_style_heading'] = [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Text', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			];
			$extra_fields['module_text_typo']          = [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['module_text_typo'],
			];
			$extra_fields['module_text_color']         = [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['module_text_color'] => 'color: {{VALUE}};',
				],
			];
			$extra_fields['module_text_hover_color']   = [
				'label'     => esc_html__( 'Text Hover Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['module_text_hover_color'] => 'color: {{VALUE}};',
				],
			];
			$extra_fields['module_text_margin']        = [
				'mode'       => 'responsive',
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['module_text_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			];
			$fields                                    = Fns::insert_controls( 'module_wrapper_margin', $fields, $extra_fields, true );
		}
		return $fields;
	}

	public static function action_button_icons() {

		$module_btn_active = Fns::is_module_active( 'wishlist' ) || Fns::is_module_active( 'compare' );
		$fields            = [
			'module_icon_section_start' => [
				'mode'       => 'section_start',
				'label'      => esc_html__( 'Action Buttons', 'shopbuilder-pro' ),
				'tab'        => 'content',
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'wishlist_button',
							'operator' => '==',
							'value'    => 'yes',
						],
						[
							'name'     => 'comparison_button',
							'operator' => '==',
							'value'    => 'yes',
						],
					],
				],
			],
		];

		$new_fields = [];
		if ( $module_btn_active ) {
			if ( Fns::is_module_active( 'wishlist' ) ) {
				$new_fields['wishlist_icon']       = [
					'label'     => esc_html__( 'Wishlist Icon', 'shopbuilder-pro' ),
					'type'      => 'icons',
					'separator' => 'default',
					'default'   => [
						'value'   => 'rtsb-icon rtsb-icon-heart-empty',
						'library' => 'rtsb-fonts',
					],
					'condition' => [
						'wishlist_button' => 'yes',
					],
				];
				$new_fields['wishlist_icon_added'] = [
					'label'     => esc_html__( 'After Added Wishlist Icon', 'shopbuilder-pro' ),
					'type'      => 'icons',
					'default'   => [
						'value'   => 'rtsb-icon rtsb-icon-heart',
						'library' => 'rtsb-fonts',
					],
					'condition' => [
						'wishlist_button' => 'yes',
					],
				];
			}
			if ( Fns::is_module_active( 'compare' ) ) {
				$new_fields['comparison_icon']       = [
					'label'     => esc_html__( 'Compare Icon', 'shopbuilder-pro' ),
					'type'      => 'icons',
					'default'   => [
						'value'   => 'rtsb-icon rtsb-icon-exchange',
						'library' => 'rtsb-fonts',
					],
					'condition' => [
						'comparison_button' => 'yes',
					],
				];
				$new_fields['comparison_icon_added'] = [
					'label'     => esc_html__( 'After Added Compare Icon', 'shopbuilder-pro' ),
					'type'      => 'icons',
					'default'   => [
						'value'   => 'rtsb-icon rtsb-icon-check',
						'library' => 'rtsb-fonts',
					],
					'condition' => [
						'comparison_button' => 'yes',
					],
				];
			}
		}

		$fields['module_icon_section_end'] = [
			'mode' => 'section_end',
		];

		if ( empty( $new_fields ) ) {
			return [];
		}

		return Fns::insert_controls( 'module_icon_section_start', $fields, $new_fields, true );
	}
}
