<?php
/**
 * FlashSaleCountdownSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * FlashSaleCountdownSettings class.
 *
 * @package RadiusTheme\SB
 */
class FlashSaleCountdownSettings {
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {

		$fields = [
			'counter_section_start'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Counter', 'shopbuilder-pro' ),
			],
			'counter_number_typography' => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Number Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['counter_number_typography'],
			],
			'counter_text_typography'   => [
				'mode'      => 'group',
				'type'      => 'typography',
				'label'     => esc_html__( 'Text Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['counter_text_typography'],
				'condition' => [
					'layout_style!' => [ 'layout2' ],
				],
			],
			'counter_height'            => [
				'label'     => esc_html__( 'Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 500,
					],
				],
				'selectors' => [
					$widget->selectors['counter_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			],
			'counter_width'             => [
				'label'     => esc_html__( 'Width', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 1000,
					],
				],
				'selectors' => [
					$widget->selectors['counter_width'] => 'Width: {{SIZE}}{{UNIT}};',
				],
			],
			'counter_gap'               => [
				'label'     => esc_html__( 'Gap', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					$widget->selectors['counter_gap'] => 'gap: {{SIZE}}{{UNIT}};',
				],
			],

			'counter_text_color_normal' => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['counter_text_color_normal'] => 'color: {{VALUE}}!important;',
				],
			],
			'counter_bg_color_normal'   => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['counter_bg_color_normal'] => 'background-color: {{VALUE}};',
				],
			],
			'counter_border'            => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['counter_border'],
				'size_units' => [ 'px' ],
			],
			'counter_border_radius'     => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'default'    => [
					'top'      => '5',
					'right'    => '5',
					'bottom'   => '5',
					'left'     => '5',
					'unit'     => 'px',
					'isLinked' => true,
				],
				'size_units' => [ 'px' ],
				'separator'  => 'before',
				'selectors'  => [
					$widget->selectors['counter_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'counter_margin'            => [
				'mode'       => 'responsive',
				'type'       => 'dimensions',
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'default',
				'selectors'  => [
					$widget->selectors['counter_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'condition'  => [
					'layout_style!' => [ 'layout2' ],
				],
			],

			'counter_section_end'       => [
				'mode' => 'section_end',
			],
		];
		return $fields;
	}
}
