<?php
/**
 * EditAddressSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.


use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class EditAddressSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		$fields                            = TitleSettings::general_settings() + TitleSettings::title_settings( $widget ) + self::form_settings( $widget );
		$fields['show_title']['selectors'] = [
			$widget->selectors['show_title'] => 'display:block;',
		];
		return $fields;
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function form_settings( $widget ) {
		$fields = FormFieldSettings::widget_fields( $widget );
		unset( $fields['form_heading_label'] );
		unset( $fields['form_heading_typo'] );
		unset( $fields['form_heading_color'] );
		unset( $fields['form_heading_gap'] );
		return $fields;
	}
}
