<?php
/**
 * AccountAddressSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\TableSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class CustomFieldsDataSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		return self::general_settings( $widget ) + self::style( $widget ) + self::table_settings( $widget );
	}
	/**
	 * @param object $widget widgets.
	 * @return array
	 */
	private static function style( $widget ) {
		$fields = [
			'section_settions_start'  => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Section', 'shopbuilder-pro' ),
			],
			'section_bg_color'        => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['section_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'section_settions_staend' => [
				'mode' => 'section_end',
			],
		];
		$fields = $fields + TitleSettings::title_settings( $widget );
		return $fields;
	}
	/**
	 * @param object $widget widgets.
	 * @return array
	 */
	private static function general_settings( $widget ) {
		$fields                            = TitleSettings::general_settings();
		$fields['show_title']['selectors'] = [
			$widget->selectors['show_title'] => 'display:block;',
		];
		$insert_array                      = [
			'section_width_100' => [
				'label'       => esc_html__( 'Full Width Section?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to set all section to a 100% width..', 'shopbuilder-pro' ),
				'default'     => '',
			],
			'section_gap'       => [
				'label'     => esc_html__( 'Section Gap', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					$widget->selectors['section_gap'] => 'gap: {{SIZE}}{{UNIT}};',
				],
			],
		];
		return Fns::insert_controls( 'show_title', $fields, $insert_array, true );
	}
	/**
	 * @param object $widget widgets.
	 * @return array
	 */
	private static function table_settings( $widget ) {
		return [
			'table_section_start'        => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Table', 'shopbuilder-pro' ),
			],
			'table_border'               => [
				'mode'      => 'group',
				'type'      => 'border',
				'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['table_border'],
				'separator' => 'before',
			],
			'table_heading_cell_padding' => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['table_heading_cell_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'table_header_label'         => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Table Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'table_header_typo'          => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['table_header_typo'],
			],
			'table_header_align'         => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['table_header_align'] => 'text-align: {{VALUE}}!important;',
				],
			],
			'table_header_color'         => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_header_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'table_header_bg_color'      => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_header_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'table_items_label'          => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Table Items', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'table_item_typo'            => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['table_item_typo'],
			],
			'table_item_align'           => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['table_item_align'] => 'text-align: {{VALUE}}!important;',
				],
			],
			'table_item_color'           => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_item_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'table_item_bg_color'        => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_item_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'table_heading_end'          => [
				'mode' => 'section_end',
			],
		];
	}
}
