<?php
/**
 * EditAddressSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.


use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class CartCouponFormSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function widget_fields( $widget ) {
		$fields                            = TitleSettings::general_settings() + TitleSettings::title_settings( $widget );
		$fields['show_title']['selectors'] = [
			$widget->selectors['show_title'] => 'display:block;',
		];
		$insert_array['coupon_form_style'] = [
			'label'       => esc_html__( 'Coupon Form Style', 'shopbuilder-pro' ),
			'type'        => 'select',
			'description' => esc_html__( 'Select Coupon Form Style to display.', 'shopbuilder-pro' ),
			'options'     => [
				'inline'   => 'Same line',
				'new_line' => 'New line',
			],
			'default'     => 'new_line',
		];
		$insert_array['button_icon']       = [
			'label'     => esc_html__( 'Button Icon', 'shopbuilder-pro' ),
			'type'      => 'icons',
			'default'   => [
				'value'   => 'fas fa-arrow-right',
				'library' => 'fa-solid',
			],
			'condition' => [
				'coupon_form_style' => 'inline',
			],
		];
		$fields                            = Fns::insert_controls( 'show_title', $fields, $insert_array, true );

		$insert_array2['title_border']      = [
			'mode'       => 'group',
			'type'       => 'border',
			'selector'   => $widget->selectors['title_border'],
			'size_units' => [ 'px' ],
		];
		$fields                             = Fns::insert_controls( 'title_text_shadow', $fields, $insert_array2, true );
		$fields                            += self::fields_settings( $widget );
		$fields                            += ButtonSettings::style_settings( $widget );
		$insert_array3['button_icon_size']  = [
			'label'     => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
			'type'      => 'number',
			'selectors' => [
				$widget->selectors['button_icon_size']['icon'] => 'font-size: {{VALUE}}px;',
				$widget->selectors['button_icon_size']['svg'] => 'width: {{VALUE}}px;',
			],
			'condition' => [
				'coupon_form_style' => 'inline',
			],
		];
		$insert_array3['button_icon_color'] = [
			'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
			'type'      => 'color',
			'selectors' => [
				$widget->selectors['button_icon_color'] => 'color: {{VALUE}};',
			],
			'condition' => [
				'coupon_form_style' => 'inline',
			],
		];

		return Fns::insert_controls( 'button_width', $fields, $insert_array3, true );
	}


	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function fields_settings( $widget ) {
		$fields = [
			'fields_style_start'         => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Coupon Fields', 'shopbuilder-pro' ),
			],
			'fields_height'              => [
				'label'     => esc_html__( 'Fields Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'selectors' => [
					$widget->selectors['fields_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			],

			'fields_tabs_start'          => [
				'mode' => 'tabs_start',
			],
			// Tab For normal view.
			'fields_normal'              => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'fields_border'              => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['fields_border'],
				'size_units' => [ 'px' ],
			],
			'fields_border_radius'       => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['fields_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_text_color'          => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['fields_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_bg_color'            => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'fields_normal_end'          => [
				'mode' => 'tab_end',
			],
			'fields_hover'               => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Hover & Focus', 'shopbuilder-pro' ),
			],

			'fields_hover_border'        => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['fields_hover_border'],
				'size_units' => [ 'px' ],
			],
			'fields_border_radius_hover' => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['fields_border_radius_hover'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_hover_text_color'    => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['fields_hover_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_hover_bg_color'      => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_hover_bg_color'] => 'background-color: {{VALUE}};',
				],
			],

			'fields_hover_end'           => [
				'mode' => 'tab_end',
			],
			'fields_tabs_end'            => [
				'mode' => 'tabs_end',
			],

			'fields_padding'             => [
				'label'      => esc_html__( 'Fields Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['fields_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_style_end'           => [
				'mode' => 'section_end',
			],
		];

		return $fields;
	}
}
