<?php
/**
 * AccountLoginSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.


use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class AccountLoginSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {

		return self::form_visibility_settings( $widget ) +
			   TitleSettings::title_settings( $widget ) +
			   self::form_wrapper_settings( $widget ) +
			   self::text_settings( $widget ) +
			   self::lost_password_settings( $widget ) +
			   self::form_settings( $widget );
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function text_settings( $widget ) {
		$textSettings                           = TextStyleSettings::widget_fields( $widget );
		$textSettings['section_style']['tab']   = 'style';
		$textSettings['section_style']['label'] = esc_html__( 'Form Text', 'shopbuilder-pro' );
		$insert_array                           = [
			'form_link_text_color'       => [
				'label'     => esc_html__( 'Link Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['form_link_text_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'form_link_text_hover_color' => [
				'label'     => esc_html__( 'Link Text Hover Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['form_link_text_hover_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'text_margin'                => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['text_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
		];

		return Fns::insert_controls( 'text_shadow', $textSettings, $insert_array, true );
	}

	/**
	 * Lost Password Field
	 *
	 * @return array
	 */
	public static function lost_password_settings( $widget ) {
		return [
			'lost_pass_section_start' => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Lost Password Text', 'shopbuilder-pro' ),
			],
			'lost_pass_typography'    => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['lost_pass_typography'],
			],
			'lost_pass_color'         => [
				'label'     => esc_html__( 'Link Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['lost_pass_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'lost_pass_hover_color'   => [
				'label'     => esc_html__( 'Link Text Hover Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['lost_pass_hover_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'lost_pass_margin'        => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['lost_pass_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'lost_pass_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function form_settings( $widget ) {
		$fields = FormFieldSettings::widget_fields( $widget );
		unset( $fields['form_heading_label'] );
		unset( $fields['form_heading_typo'] );
		unset( $fields['form_heading_color'] );
		unset( $fields['form_heading_gap'] );
		return $fields;
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function form_wrapper_settings( $widget ) {
		return [
			'form_wrapper_start'         => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Form Wrapper', 'shopbuilder-pro' ),
			],
			'form_border_between_color'  => [
				'label'     => esc_html__( 'Border Color Between Forms', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['form_border_between_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'form_wrapper_border'        => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['form_wrapper_border'],
				'size_units' => [ 'px' ],
			],
			'form_wrapper_border_radius' => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['form_wrapper_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'form_wrapper_bg_color'      => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['form_wrapper_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'form_wrapper_padding'       => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['form_wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'form_wrapper_start_end'     => [
				'mode' => 'section_end',
			],
		];
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function form_visibility_settings( $obj ) {
		$title_settings                         = TitleSettings::general_settings();
		$extra_controls['login_note']           = $obj->el_heading( esc_html__( 'Login Form', 'shopbuilder-pro' ), 'before' );
		$extra_controls['show_remember_me']     = [
			'label'       => esc_html__( 'Show \'Remember Me\'?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Switch on to show \'Remember Me\' checkbox.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'default'     => 'yes',
		];
		$extra_controls['remember_me_lab_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( '\'Remember Me\' Label', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter custom \'Remember Me\' label. Leave empty for default label.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'label_block' => true,
			'condition'   => [
				'show_remember_me' => 'yes',
			],
		];
		$extra_controls['show_lost_password']   = [
			'label'       => esc_html__( 'Show \'Lost Password\'?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Switch on to show \'Lost Password\' link.', 'shopbuilder-pro' ),
			'separator'   => 'before',
			'default'     => 'yes',
		];
		$extra_controls['lost_password_text']   = [
			'type'        => 'text',
			'label'       => esc_html__( '\'Lost Password\' Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter custom \'Lost Password\' link text. Leave empty for default text.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'label_block' => true,
			'condition'   => [
				'show_lost_password' => 'yes',
			],
		];
		$extra_controls['login_btn_text']       = [
			'type'        => 'text',
			'label'       => esc_html__( 'Login Button Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Login button text. Leave empty for default text.', 'shopbuilder-pro' ),
			'separator'   => 'before',
			'label_block' => true,
		];
		$extra_controls['register_note']        = $obj->el_heading( esc_html__( 'Register Form', 'shopbuilder-pro' ), 'before' );
		$extra_controls['register_btn_text']    = [
			'type'        => 'text',
			'label'       => esc_html__( 'Register Button Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Register Button Text. Leave Empty For default.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'label_block' => true,
		];

		return Fns::insert_controls( 'show_title', $title_settings, $extra_controls, true );
	}
}
