<?php
/**
 * AccountLoginFormSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.


use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class AccountLoginFormSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		$fields = AccountLoginSettings::settings( $widget );
		unset( $fields['login_note'] );
		unset( $fields['register_note'] );
		unset( $fields['register_btn_text'] );
		unset( $fields['form_border_between_color'] );
		unset( $fields['section_style'] );
		unset( $fields['typo'] );
		unset( $fields['align'] );
		unset( $fields['text_color'] );
		unset( $fields['text_shadow'] );
		unset( $fields['form_link_text_color'] );
		unset( $fields['form_link_text_hover_color'] );
		unset( $fields['text_margin'] );
		unset( $fields['section_style_end'] );
		$extra_controls['login_title_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Login Title', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter custom Login Title. Leave empty for default label.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'label_block' => true,
			'condition'   => [
				'show_title' => 'yes',
			],
		];
		$fields                                 = Fns::insert_controls( 'show_title', $fields, $extra_controls, true );
		return $fields;

	}

}
